{->>>>GetDirectory<<<<-----------------------------------------}
{                                                              }
{ Filename: GETDIR.SRC -- Last modified 7/2/88                 }
{                                                              }
{ This routine returns a pointer to a linked list of type      }
{ DIRRec, which must have been previously defined this way,    }
{ along with pointer type DIRPtr to point to it:               }
{                                                              }
{ DIRPtr = ^DIRRec;                                            }
{ DIRRec = RECORD                                              }
{            FileName  : String15;                             }
{            Attrib    : Byte;                                 }
{            FileSize  : LongInt;                              }
{            TimeStamp : TimeRec;                              }
{            DateStamp : DateRec;                              }
{            Prior     : DIRPtr;                               }
{            Next      : DIRPtr;                               }
{          END;                                                }
{                                                              }
{ The linked list will contain a record for every file in the  }
{ current directory.  Since the linked list is out in heap,    }
{ your directory data takes up NO space in your data segment.  }
{ If there are no files in the current directory, the pointer  }
{ returned is equal to NIL.                                    }
{                                                              }
{ The types TimeRec and DateRec must be defined prior to using }
{ GetDirectory.  String80 & DTAToDIR must be defined as well.  }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE GetDirectory(Filespec   : String80;
                       Sorted     : Boolean;
                       SortOnName : Boolean;
                       VAR Ascending  : DIRPtr;
                       VAR Descending : DIRPtr);

TYPE
  String9 = String[9];

VAR
  I         : Integer;
  FindError : Integer;
  Regs      : Registers;
  OurDTA    : SearchRec;
  Root      : DIRPtr;
  Current   : DIRPtr;
  Last      : DIRPtr;
  Holder    : DIRPtr;
  PositionFound : Boolean;


FUNCTION LaterThan(LeftEntry,RightEntry : DirPtr) : Boolean;

BEGIN
  IF LeftEntry^.DateStamp.DateComp > RightEntry^.DateStamp.DateComp THEN
    LaterThan := True
  ELSE
    IF (LeftEntry^.DateStamp.DateComp = RightEntry^.DateStamp.DateComp)
        AND
       (LeftEntry^.TimeStamp.TimeComp > RightEntry^.TimeStamp.TimeComp)
    THEN LaterThan := True
    ELSE LaterThan := False
END;


PROCEDURE AppendToEnd(VAR Holder,Descending : DIRPtr);

BEGIN
  Descending^.Next := Holder;    { Add record to end of list }
  Descending^.Next^.Prior := Descending;  { Set reverse pointer }
  Descending := Descending^.Next;   { Bump Current to next record }
END;



BEGIN  { GetDir }
  FindFirst(FileSpec,$16,OurDTA);      { Make FIND FIRST DOS call... }
  FindError := DOSError;
  IF FindError = 2 THEN  { No files found to match FileSpec }
    BEGIN
      Ascending := NIL;     { Both linked list pointers are NIL }
      Descending := NIL
    END
  ELSE                   { There was at least one file found, so... }
    BEGIN
      New(Root);            { Create a record for the first find }
      DTAtoDIR(Root^);      { Convert first find to DIR format }
      Current := Root;      { The current record is now the root record }
      Descending := Root;   { And also the last record in the list! }
      IF FindError <> 18 THEN
        REPEAT
          FindNext(OurDTA);       { Make FIND NEXT DOS call }
          FindError := DOSError;
          IF FindError <> 18 THEN { More entries exist }
            BEGIN
              New(Holder);        { Create a record with temporary pointer }
              DTAtoDIR(Holder^);  { Convert additional finds to DIR format }
              { Sorted and unsorted lists are constructed differently. }
              { If we're building a sorted list we have to scan it for }
              { each entry to find the proper place in the list.  For  }
              { unsorted lists we just hang the latest found entry on  }
              { the end of the list and bump Current to the Next. }
              IF Sorted THEN
                BEGIN
                  Current := Root;    { Traverse list to find insert spot: }
                  REPEAT
                    IF SortOnName THEN     { To sort list on file name }
                      IF Current^.FileName > Holder^.FileName THEN
                        PositionFound := True ELSE PositionFound := False
                    ELSE                   { To sort list by time/date }
                      IF LaterThan(Current,Holder) THEN
                        PositionFound := True ELSE PositionFound := False;
                    IF NOT PositionFound THEN
                      Current := Current^.Next;  { Bump to next item }
                  UNTIL (Current = NIL) OR PositionFound;
                  { When PositionFound becomes True, the record needs }
                  { to be inserted in the list BEFORE Current^-- }
                  { This needs to be done differently if Current^ is }
                  { at the head of the list. (i.e., Current = Root)}
                  IF PositionFound THEN  { Insert at beginning... }
                    BEGIN                { ...or in the middle somewhere }
                      { NOTE:  DO NOT change the order of the }
                      { pointer assignments in the following }
                      { IF/THEN/ELSE statement!! }
                      IF Current = Root THEN  { Insert at beginning }
                        BEGIN
                          Holder^.Next := Root;
                          Current^.Prior := Holder;
                          Root := Holder;
                        END
                      ELSE    { Insert in the middle: }
                        BEGIN
                          Holder^.Next  := Current;
                          Holder^.Prior := Current^.Prior;
                          Current^.Prior^.Next := Holder;
                          Current^.Prior := Holder
                        END
                    END
                  ELSE  { The new record belongs at the end of the list }
                    AppendToEnd(Holder,Descending)
                END
              ELSE   { If no sort, we add the record to the end of the list: }
                AppendToEnd(Holder,Descending)
            END
        UNTIL FindError = 18;
      Ascending := Root
    END
END;  {GetDirectory}
