{->>>>CalcDate<<<<---------------------------------------------}
{                                                              }
{ Filename: CALCDATE.SRC -- Last Modified 7/11/88              }
{                                                              }
{ This routine fills in the DateString, LongDateString, and    }
{ DateComp fields of the DateRec record passed to it.  It      }
{ requires that the Year, Month, and Day fields be valid on    }
{ entry.  It also requires prior definition of types DateRec   }
{ and String80.  DateString is formatted this way:             }
{                                                              }
{     Wednesday, July 17, 1986                                 }
{                                                              }
{ DateRec is declared this way:                                }
{                                                              }
{     DateRec = RECORD                                         }
{                 DateComp       : Word;                       }
{                 LongDateString : String80;                   }
{                 DateString     : String80;                   }
{                 Year,Month,Day : Integer;                    }
{                 DayOfWeek      : Integer                     }
{               END;                                           }
{                                                              }
{ DayOfWeek is a code from 0-6, with 0 = Sunday.               }
{ DateComp is a cardinal generated by the formula:             }
{                                                              }
{     DateComp = (Year-1980)*512 + (Month*32) + Day            }
{                                                              }
{ It is used for comparing two dates to determine which is     }
{ earlier, and is the same format used in the date stamp in    }
{ DOS directory entries.                                       }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE CalcDate(VAR ThisDate : DateRec);

TYPE
  String9 = String[9];

CONST
  MonthTags : ARRAY [1..12] of String9 =
    ('January','February','March','April','May','June','July',
     'August','September','October','November','December');
  DayTags   : ARRAY [0..6] OF String9 =
    ('Sunday','Monday','Tuesday','Wednesday',
     'Thursday','Friday','Saturday');

VAR
  Temp1 : String80;

BEGIN
  WITH ThisDate DO
    BEGIN
      DayOfWeek := DateToDayOfWeek(Year,Month,Day);
      Str(Month,DateString);
      Str(Day,Temp1);
      DateString := DateString + '/' + Temp1;
      LongDateString := DayTags[DayOfWeek] + ', ';
      LongDateString := LongDateString +
        MonthTags[Month] + ' ' + Temp1 + ', ';
      Str(Year,Temp1);
      LongDateString := LongDateString + Temp1;
      DateString := DateString + '/' + Copy(Temp1,3,2);
      DateComp := (Year - 1980) * 512 + (Month * 32) + Day
    END
END;
