{--------------------------------------------------------------}
{                          Screen                              }
{                                                              }
{               Full-screen input demo program                 }
{                                                              }
{                             by Jeff Duntemann                }
{                             Turbo Pascal V5.0                }
{                             Last update 7/14/88              }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}


PROGRAM Screen;

USES DOS,Crt,BoxStuff;

{$V-}  { Allow length mismatch for string VAR parameters.  See 23.4 }

CONST
  Capslock      = True;
  NoCapslock   = False;
  Numeric       = True;
  NonNumeric   = False;

TYPE
  String80 = String[80];
  String30 = String[30];
  String6  = String[6];
  String4  = String[4];
  String3  = String[3];

  NAPRec   = RECORD
               Name    : String30;
               Address : String30;
               City    : String30;
               State   : String3;
               Zip     : String6
             END;


VAR
  CH            : Char;
  CurrentRecord : NAPRec;
  Edit          : Boolean;
  Quit          : Boolean;
  Escape        : Boolean;
  WIDTH,HEIGHT  : Integer;
  I,J           : Integer;
  R             : Real;


{$I UHUH.SRC }       { Described in Section 16.11 }
{$I CURSOFF.SRC }    { Described in Section 17.2 }
{$I CURSON.SRC }     { Described in Section 17.2 }
{$I YES.SRC }        { Described in Section 17.2 }
{$I GETSTRIN.SRC }   { Described in Section 15.2 }


PROCEDURE GetScreen(VAR ScreenData : NAPRec;
                        Edit       : Boolean;
                    VAR Escape     : Boolean);

BEGIN
  MakeBox(1,1,79,20,GrafChars);        { Draw the screen box }
  IF NOT Edit THEN WITH ScreenData DO  { If not editing, clear record }
    BEGIN
      Name := ''; Address := ''; City := ''; State := ''; Zip := ''
    END;
  GotoXY(23,2);
  Writeln('<< Name / Address Entry Screen >>');
  WITH ScreenData DO
    BEGIN                        { First draw field frames: }
      GotoXY(5,7);
      Write('>>Customer Name:    |..............................|');
      GotoXY(5,9);
      Write('>>Customer Address: |..............................|');
      GotoXY(5,11);
      Write('>>Customer City:    |..............................|');
      GotoXY(5,13);
      Write('>>Customer State:   |...|');
      GotoXY(5,15);
      Write('>>Customer Zip:     |......| ');
      IF Edit THEN WITH ScreenData DO  { If editing, show current values }
        BEGIN
          GotoXY(26,7);  Write(Name);
          GotoXY(26,9);  Write(Address);
          GotoXY(26,11); Write(City);
          GotoXY(26,13); Write(State);
          GotoXY(26,15); Write(Zip)
        END;                            { Now input/Edit field data: }
      GetString(25,7,Name,30,NoCapslock,NonNumeric,False,R,I,J,Escape);
      IF NOT Escape THEN
        GetString(25,9,Address,30,NoCapslock,NonNumeric,False,R,I,J,Escape);
      IF NOT Escape THEN
        GetString(25,11,City,30,NoCapslock,NonNumeric,False,R,I,J,Escape);
      IF NOT Escape THEN
        GetString(25,13,State,3,Capslock,NonNumeric,False,R,I,J,Escape);
      IF NOT Escape THEN
        GetString(25,15,Zip,6,Capslock,NonNumeric,False,R,I,J,Escape);
    END
END;


BEGIN        { SCREEN MAIN }
  Edit := False;
  CursorOff;
  REPEAT
    ClrScr;
    GetScreen(CurrentRecord,Edit,Escape);  { Input/Edit a data screen }
    IF Escape THEN Quit := True ELSE       { Quit if ESC pressed }
      BEGIN                                { Otherwise summarize data }
        Quit := False;                     { and ask for approval }
        GotoXY(1,22);
        Write('>>Summary: ');
        WITH CurrentRecord DO
          BEGIN
            Write(Name,'/',Address,'/',Zip);
            GotoXY(1,23); Write('>>OK? (Y/N): ');
            IF YES THEN Edit := False ELSE Edit := True
          END
      END
  UNTIL Quit;
  ClrScr;
  CursorOn
END.

