{->>>>DTAtoDIR<<<<---------------------------------------------}
{                                                              }
{ FILENAME DTATODIR.SRC -- Last modified 11/8/87               }
{                                                              }
{ This procedure converts data as returned by DOS FIND         }
{ calls $4E & $4F in the Disk Transfer Area (DTA) to a more    }
{ tractable form as defined by my own record type DIRRec.      }
{ This involves converting the time from a word timestamp to   }
{ a TimeRec, and the date from a word datestamp to a DateRec.  }
{                                                              }
{ DTAToDIR requires the prior definition of types DIRRec,      }
{ DIRPtr, and DTAPtr; and procedures CalcTime and CalcDate.    }
{                                                              }
{     From: COMPLETE TURBO PASCAL 5.0  by Jeff Duntemann       }
{    Scott, Foresman & Co., Inc. 1988   ISBN 0-673-38355-5     }
{--------------------------------------------------------------}

PROCEDURE DTAtoDIR(VAR OutRec : DIRRec);

VAR
  DTData      : DateTime;   { This type imported from DOS unit }
  I           : Integer;
  InRec       : SearchRec;  { Also imported from the DOS unit  }
  RegPack     : Registers;  { Also imported from the DOS unit  }
  CurrentDTA  : DTAPtr;

BEGIN
  RegPack.AX := $2F00; { Find current location of DTA }
  MSDOS(RegPack);
  WITH RegPack DO CurrentDTA := Ptr(ES,BX);
  InRec := CurrentDTA^;
  UnpackTime(InRec.Time,DTData);
  WITH OutRec DO              { Now extract and reformat data }
    BEGIN
      FileName := InRec.Name; { Extract the file name }
      Attrib := InRec.Attr;   { Extract the attribute field }
      WITH TimeStamp DO       { Expand integer time stamp }
        BEGIN
          TimeComp := InRec.Time SHR 16;
          Hours := DTData.Hour;
          Minutes := DTData.Min;
          Seconds := DTData.Sec;
          Hundredths := 0;
        END;
      CalcTime(TimeStamp);   { Fill in the other time fields }
      WITH DateStamp DO      { Expand integer date stamp }
        BEGIN
          DateComp := InRec.Time AND $0000FFFF;
          Day := DTData.Day;
          Month := DTData.Month;
          Year  := DTData.Year;
        END;
      CalcDate(DateStamp);   { Fill in the other date fields }
      FileSize := InRec.Size;
      Next := NIL;            { Initialize the "next" pointer }
      Prior := NIL;           { Ditto the "prior" pointer }
    END
END;  { DTAtoDIR }
