{*******************************************************
              ColorGen Unit

              Paul Warren
     HomeGrown Software Development
   (c) 1992 Langley British Columbia.

This unit creates an extension to the Borland supplied
CORLORSEL.PAS unit.
  
Remember, this is shareware. If you use this dialog in
your programs or you use the code in your own programs
you must register. To register send $5 to

              Paul Warren
  #232 5400 206th St. Langley BC. Canada.

********************************************************}

unit ColorGen;

interface

uses Objects, Drivers, Dialogs, Dos, Crt, ColorSel, App, MsgBox,
     Views;

type
  { This is a new object designed to show the color palette index
  into the application palette, the index into the particular color
  group and the Hex value for the particular color. It appears as a
  small Framed View. This object is supposed to make it easy to
  write palettes for objects, such as this one itself, which will
  be inserted into other objects. Take a look at the GetPalette
  method for this object.}
  PIndexView = ^TIndexView;
  TIndexView = object(TView)
    Index: byte;
    ColVal: string;
    GroupIndex: integer;
    constructor Init(var Bounds: TRect);
    procedure ShowIndex(var TheIndex: byte);
    procedure ShowColVal(var TheColor: byte);
    function Hex(a:byte):string;
    procedure Draw; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    function GetPalette: PPalette; virtual;
  end;

  { This is an extention to the Color Dialog object supplied with
  Turbo Vision. It adds a TIndexView type and Inits with the color
  groups added. If you want to include the Color groups of your own
  objects it is easy. See TVDEMO.PAS for an example. }
  PCol_Gen = ^TCol_Gen;
  TCol_Gen = object(TColorDialog)
    constructor Init;
  end;

implementation

{ TIndexView }
constructor TIndexView.Init(var Bounds: TRect);
begin
  TView.Init(Bounds);
  EventMask := EventMask + evBroadcast;
  Options := Options or ofFramed;
end;

procedure TIndexView.HandleEvent(var Event: TEvent);
begin
  TView.HandleEvent(Event);
  if (Event.What = evBroadCast) then
  case Event.Command of
    cmNewColorIndex: ShowIndex(Event.InfoByte);
    cmColorSet: ShowColVal(Event.InfoByte);
  end;
end;

function TIndexView.Hex(a:byte):string;

  function Digit(a:byte):char;
  begin
    If a>9 then digit:=chr(a+55)
    else digit:=chr(a+48);
  end;

begin
  Hex:=Digit(a div 16)+Digit(a mod 16);
end;

procedure TIndexView.ShowColVal(var TheColor: byte);
begin
  ColVal := '$' + Hex(ord(TheColor));
  DrawView;
end;

procedure TIndexView.ShowIndex(var TheIndex: byte);
begin
  Index := TheIndex;
  GroupIndex := PColorDialog(Owner)^.ColorItems^.Focused + 1;
  DrawView;
end;

procedure TIndexView.Draw;
var
  Color: Byte;
  I: Integer;
  B: TDrawBuffer;
  S: string;

    function FormatStr(A, B: string): string;
    var
      S: string;
      T: string;
    begin
      T := '';
      S := '';
      while Length(S) < Size.X-4 do begin
        T := T + ' ';
        S := A + T + B;
      end;
      FormatStr := S;
    end;

begin
  Color := GetColor(1);
  Str(index, S);
  MoveChar(B, ' ', Color, Size.X*3);
  MoveStr(B[2], FormatStr('Palette Index',S), Color);
  Str(GroupIndex, S);
  MoveStr(B[Size.X+2], FormatStr('Group Index',S), Color);
  MoveStr(B[Size.X*2+2], FormatStr('Color Value',ColVal), Color);
  WriteBuf(0, 0, Size.X, 3, B);
end;

function TIndexView.GetPalette: PPalette;
const
  CTheView = #30;
  PTheView: String[Length(CTheView)] = CTheView;
begin
  GetPalette := @PTheView;
end;

{TCol_Gen}
constructor TCol_Gen.Init;
var
  R: TRect;
  C: PView;
begin
  TColorDialog.Init('',
    ColorGroup('Desktop',
      ColorItem('Color',             1,
    nil),
    ColorGroup('Menus',
      ColorItem('Normal',            2,
      ColorItem('Disabled',          3,
      ColorItem('Shortcut',          4,
      ColorItem('Selected',          5,
      ColorItem('Selected disabled', 6,
      ColorItem('Shortcut selected', 7,
    nil)))))),
    ColorGroup('Blue Window',
      ColorItem('Window Passive', 8,
      ColorItem('Window Active', 9,
      ColorItem('Window Icons', 10,
      ColorItem('Scroll Bar ', 11,
      ColorItem('Scroll Bar Icons', 12,
      ColorItem('Text Normal', 13,
      ColorItem('Text Selected',14,
      ColorItem('Reserved',15,
    nil)))))))),
    ColorGroup('Cyan Window',
      ColorItem('Window Passive',16,
      ColorItem('Window Active',17,
      ColorItem('Window Icons',18,
      ColorItem('Scroll Bar ',19,
      ColorItem('Scroll Bar Icons',20,
      ColorItem('Text Normal',21,
      ColorItem('Text Selected',22,
      ColorItem('Reserved',23,
    nil)))))))),
    ColorGroup('Gray Window',
      ColorItem('Window Passive',24,
      ColorItem('Window Active',25,
      ColorItem('Window Icons',26,
      ColorItem('Scroll Bar ',27,
      ColorItem('Scroll Bar Icons',28,
      ColorItem('Text Normal',29,
      ColorItem('Text Selected',30,
      ColorItem('Reserved',31,
    nil)))))))),
    ColorGroup('Dialogs',
      ColorItem('Frame Passive',32,
      ColorItem('Frame/background',  33,
      ColorItem('Frame Icons',       34,
      ColorItem('Scroll Bar',   35,
      ColorItem('Scroll Bar Icons',  36,
      ColorItem('Static Text',       37,

      ColorItem('Label Normal',      38,
      ColorItem('Label Selected',    39,
      ColorItem('Label Shortcut',    40,

      ColorItem('Button Normal',     41,
      ColorItem('Button Default',    42,
      ColorItem('Button Selected',   43,
      ColorItem('Button Disabled',   44,
      ColorItem('Button Shortcut',   45,
      ColorItem('Button Shadow',     46,

      ColorItem('Cluster Normal',    47,
      ColorItem('Cluster Selected',  48,
      ColorItem('Cluster Shortcut',  49,

      ColorItem('Input Normal',      50,
      ColorItem('Input Selected',    51,
      ColorItem('Input Arrow',       52,

      ColorItem('History Button',    53,
      ColorItem('History Sides',     54,
      ColorItem('History Bar',  55,
      ColorItem('History Bar Icons', 56,

      ColorItem('List Normal',       57,
      ColorItem('List Focused',      58,
      ColorItem('List Selected',     59,
      ColorItem('List Divider',      60,

      ColorItem('Information Pane',  61,
      ColorItem('Reserved',62,
      ColorItem('Reserved',63,
    nil)))))))))))))))))))))))))))))))),
  nil)))))));

  R.Assign(7, 13, 32, 16);
  C := New(PIndexView, Init(R));
  Insert(C);
  R.Assign(9, 12, 30, 13);
  Insert(New(PLabel, Init(R, 'Palette Index Values', C)));
end;

end.