Program BufferedHeapTest;

{NOTE: There are two bits of code inserted into the BGenHeap unit
       for no useful reason other then the display during this
       test program's run.  One is in the Uses clause, and the
       other is in the Sort method.  Delete these before using
       the unit for any production code! }

Uses BHeaps,Crt;

Const
  Num = 100000;

Var
  H : RealHeap;
  I : LongInt;
  R : Real;

Begin
  ClrScr;
  Randomize;

  WriteLn (MemAvail,' Bytes Available before Initialization.');

  H.Create;
  H.Init(Num,0,'Heap.Dat');

  WriteLn (MemAvail,' Bytes Available after Initialization.');
  WriteLn ('Object Occupies ',SizeOf(H),' Bytes.');
  WriteLn;
  Write ('SORTING ',Num,' FLOATING POINT NUMBERS.');

  For I := 1 to Num do
    Begin
      R := 1000000000*Random;
      If Random(2) = 1 Then R := -R;
      GoToXY (1,7);
      Write ('Sifting Up ',I,'th Element.');
      H.SiftUp (R,I)
    End;

  GoToXY (1,7);
  Write ('Finished Sifting ',Num,' Elements. Press Return to Continue...');
  ReadLn;
  WriteLn ('Storing Heap to Disk File...');

  H.Store;

  WriteLn ('MemAvail after Storing = ',MemAvail);
  Write ('Press Return to Continue...');
  ReadLn;
  WriteLn ('Loading Heap from Disk File...');

  H.Load ('Heap.Dat',MemAvail);

  WriteLn ('MemAvail after Loading = ',MemAvail);
  Write ('Press Return to Continue...');
  ReadLn;

  GoToXY (1,15);
  Write ('Sorting Element # ');

  H.Sort;

  WriteLn;
  Write ('Done Sorting. Press Return to Continue...');

  ReadLn;

  For I := 1 to Num do WriteLn (H.Retrieve(I):5:5,' was the ',I,'th Element');

  ReadLn;

  H.Destroy;

End.