Unit BD4Array;  {Useable 4-Dimensional BufferedArrays}
{$R-}

INTERFACE
Uses BD4_Max;

Type
  BD4_IntArray = Object (D4_BufferedArray)

                   Procedure Init (Max1,Max2,Max3,Max4,MaxBuffSize : LongInt;
                                  FileName : String);

                   { BD4_xxxArrays are indexed 0..Max1-1, 0..Max2-1}
                                              {0..Max3-1, 0..Max4-1}

                   Procedure Load (FileName : String;
                                   Max1,Max2,Max3,Max4,MaxBuffSize : LongInt);

                   Procedure Accept (W,X,Y,Z : LongInt; I : Integer);

                   Procedure Retrieve (W,X,Y,Z : LongInt; Var I : Integer);

                   {NOTE: There is no reason why Retrieve could not be}
                   {redefined as a function for atomic types such as Integer}

                   Procedure Copy (From : BD4_IntArray);
                              {Target *MUST* already be initialized}
                              {to the EXACT same parameters as From}
                              {this will save checking for sufficient}
                              {available Memory!}

(* no redefinition needed

                   Procedure Store;

                   Procedure Swap (W1,X1,Y1,Z1,W2,X2,Y2,Z2 : LongInt);
                              {Swap the 1 and 2 Element}

                   Function MaxIndex (Index : Byte) : LongInt;
                                     {Return the Max legal Index}
                                     {for the Indexth Dimension}

                   Function MaxSize : LongInt;
                                      {Report Number of Array Elements}
                   Function ElemSize : Word;  {Report Element Size}
                   Procedure Destroy;
*)
          End; {BD4_IntArray}

IMPLEMENTATION

Uses BND_Max;  {Obtain the definition of the DimensionPtr Type}

Procedure BD4_IntArray.Init;
{NOTE: If ANY of the Max's is zero, ND_MAX.INIT will attempt}
{to determine and allocate the maximum possible index.  If all}
{are zero, then the largest possible evenly-indexed array will be allocated}
{There is a POSSIBILITY of allocation errors if less than all are}
{zero, but such errors will be detected and reported}
Var
  Temp : DimensionPtr;
  I    : Byte;
Begin
  I := 0;
  GetMem (Temp,4*SizeOf(LongInt));
  Temp^[I] := Max1; I := 1;  {Have to fool the compiler, even}
  Temp^[I] := Max2; I := 2;  {with Range-checking off!!}
  Temp^[I] := Max3; I := 3;
  Temp^[I] := Max4;
  D4_BufferedArray.Init (Temp,SizeOf(Integer),MaxBuffSize,FileName);
  FreeMem (Temp,4*SizeOf(LongInt));
End;

Procedure BD4_IntArray.Load;
Var
  Temp : DimensionPtr;
  I    : Byte;
Begin
  I := 0;
  GetMem (Temp,4*SizeOf(LongInt));
  Temp^[I] := Max1; I := 1;  {Have to fool the compiler, even}
  Temp^[I] := Max2; I := 2;  {with Range-checking off!!}
  Temp^[I] := Max3; I := 3;
  Temp^[I] := Max4;
  D4_BufferedArray.Load (FileName,SizeOf(Integer),MaxBuffSize,4,Temp);
  FreeMem (Temp,4*SizeOf(LongInt));
End;

Procedure BD4_IntArray.Accept (W,X,Y,Z : LongInt; I : Integer);
Var
  Temp : Integer;
Begin
  Temp := I;
  D4_BufferedArray.Accept (W,X,Y,Z,Temp,SizeOf(Integer))
End;

Procedure BD4_IntArray.Retrieve (W,X,Y,Z : LongInt; Var I : Integer);
Var
  Temp : Integer;
Begin
  D4_BufferedArray.Retrieve (W,X,Y,Z,Temp,SizeOf(Integer));
  I := Temp
End;

Procedure BD4_IntArray.Copy (From : BD4_IntArray);
{Redefined purely for type-checking}
Begin
  D4_BufferedArray.Copy (From)
End;

BEGIN
END.