Unit BND_Max;  {Primitive N-Dimensional BufferedArrays}
{$R-,O+,S-}

INTERFACE
Uses BuffAray;

Type
  DimensionPtr   = ^DimensionArray;
  DimensionArray = Array[0..0] of LongInt;

  BN_Max = Object (BufferedArray)

               Dim  : Byte;         {PRIVATE}
               Len  : DimensionPtr; {PRIVATE}

               Add1 : DimensionPtr; {Provides two arrays of the correct}
               Add2 : DimensionPtr; {size for passing the indices of the}
                                    {N-dimensional array.  this is so all}
                                    {memory needed for the N-D array can}
                                    {be allocated at creation, rather}
                                    {than being done from within applications}
                                    {For correct usage, see any of the}
                                    {BDxARRAYS Units.}

               Procedure Init (Dimension : Byte;
                         ElementsPerDimension : DimensionPtr;
                         ElementSize : Word; MaxBuffSize : LongInt;
                         FileName : String);


               Procedure Load (FileName : String; ElementSize : Word;
                               MaxBuffSize : LongInt; Dimension : Byte;
                               ElementsPerDimension : DimensionPtr);

               Procedure Accept (Var El; Address : DimensionPtr;
                                 Dimension : Byte; Size : Word);
                                       {Assign the Addressed El}

               Procedure Retrieve (Var El; Address : DimensionPtr;
                                   Dimension : Byte; Size : Word);
                                         {Get the Addressed El}

               Procedure Copy (From : BN_Max);
                              {Target *MUST* already be initialized}
                              {to the EXACT same parameters as From}
                              {this will save checking for sufficient}
                              {available Memory!}


               Procedure Swap (I,J : DimensionPtr; Dimension : Byte);
                              {Swap the Ith and Jth Elements}

               Function MaxIndex (Index : Byte) : LongInt;
                                 {Returns the Max legal Index for the}
                                 {Indexth Dimension}
               Procedure Destroy;

(* no redefinition needed

               Procedure Store;

               Function MaxSize : LongInt;   {Report Number of Array Elements}
               Function ElemSize : Word;  {Report Element Size}
*)
          End; {BN_Max}

IMPLEMENTATION

Procedure Error (Num : Byte);
Begin
  WriteLn;
  Write ('N-DimensionBufferedArray ERROR: ');
  Case Num of
            0 : WriteLn ('Attempted ACCEPT with wrong Number of Dimensions');
            1 : WriteLn ('Attempted RETRIEVE with wrong Number of Dimensions');
            2 : WriteLn ('Attempted COPY with wrong Number of Dimensions');
            3 : WriteLn ('Attempted SWAP with wrong Number of Dimensions');
            4 : WriteLn ('Attempted INIT with ElementSize <= Zero');
            5 : WriteLn ('Attempted INIT with Dimension <= Zero');
          End;
  WriteLn ('**** PROGRAM TERMINATED ****');
  WriteLn;
  Write ('Press <Return> to Continue.... ');
  ReadLn;
  HALT (0)
End;

Procedure BN_Max.Init;
Var
  ActualSize : LongInt;
  I          : Byte;
  TempAvail  : LongInt;
  MaxElems   : LongInt;
  TempIndex  : LongInt;
Begin
  If ElementSize <= 0 Then Error (4);
  If Dimension <= 0 Then Error (5);
  Dim := Dimension;
  GetMem (Len,Dimension*SizeOf(LongInt));
  GetMem (Add1,Dim*SizeOf(LongInt));
  GetMem (Add2,Dim*SizeOf(LongInt));
  TempAvail := MemAvail;
  TempAvail := TempAvail - (TempAvail Mod ElementSize);
  TempAvail := TempAvail Div ElementSize; {Max Possible elements}
  MaxElems := 1;
  TempIndex := 0;
  While MaxElems < TempAvail do
    Begin
      TempIndex := TempIndex + 1;
      MaxElems := 1;
      For I := 1 to Dimension do
        MaxElems := MaxElems * TempIndex
    End;
  If MaxElems > TempAvail Then TempIndex := TempIndex - 1; {Max Possible}
                                                          {Dimensional Length}
  For I := 0 to Dimension-1 do
    Begin
      Len^[I] := ElementsPerDimension^[I];
      If Len^[I] <= 0 Then
        Len^[I] := TempIndex
    End;
  ActualSize := Len^[0];
  For I := 1 to Dimension-1 do
    ActualSize := ActualSize * Len^[I];
  BufferedArray.Create;
  BufferedArray.Init (ActualSize,ElementSize,MaxBuffSize,FileName)
End;


Procedure BN_Max.Load (FileName : String; ElementSize : Word;
                MaxBuffSize : LongInt; Dimension : Byte;
                ElementsPerDimension : DimensionPtr);
Var
  ActualSize : LongInt;
  I          : Byte;
  TempAvail  : LongInt;
  MaxElems   : LongInt;
  TempIndex  : LongInt;
Begin
  If ElementSize <= 0 Then Error (4);
  If Dimension <= 0 Then Error (5);
  Dim := Dimension;
  GetMem (Len,Dimension*SizeOf(LongInt));
  GetMem (Add1,Dim*SizeOf(LongInt));
  GetMem (Add2,Dim*SizeOf(LongInt));
  TempAvail := MemAvail;
  TempAvail := TempAvail - (TempAvail Mod ElementSize);
  TempAvail := TempAvail Div ElementSize; {Max Possible elements}
  MaxElems := 1;
  TempIndex := 0;
  While MaxElems < TempAvail do
    Begin
      TempIndex := TempIndex + 1;
      MaxElems := 1;
      For I := 1 to Dimension do
        MaxElems := MaxElems * TempIndex
    End;
  If MaxElems > TempAvail Then TempIndex := TempIndex - 1; {Max Possible}
                                                          {Dimensional Length}
  For I := 0 to Dimension-1 do
    Begin
      Len^[I] := ElementsPerDimension^[I];
      If Len^[I] <= 0 Then
        Len^[I] := TempIndex
    End;
  ActualSize := Len^[0];
  For I := 1 to Dimension-1 do
    ActualSize := ActualSize * Len^[I];
  BufferedArray.Create;
  BufferedArray.Load (FileName,ElementSize,MaxBuffSize)
End;

Function BN_Max.MaxIndex (Index : Byte) : LongInt;
Begin
  If Index-1 > Dim Then MaxIndex := 0
  Else
    MaxIndex := Len^[Index-1] - 1
End;

Function Map (VirtualAddress : DimensionPtr; Dimension : Byte;
              Len : DimensionPtr) : LongInt;
Var
  I       : Byte;
  Address : LongInt;
  Radix   : LongInt;
Begin
  Address := 0;
  Radix := 1;
  For I := 0 to Dimension-1 do
    Begin
      Address := Address + (VirtualAddress^[I] * Radix);
      If I < Dimension-1 Then Radix := Radix * Len^[I]
    End;
  Map := Address
End;

Procedure BN_Max.Accept (Var El; Address : DimensionPtr;
                                 Dimension : Byte; Size : Word);
                                       {Assign the Addressed El}
Var
  ActualAddress : LongInt;
Begin
  If Dimension <> Dim Then Error (0);
  ActualAddress := Map(Address,Dimension,Len);
  BufferedArray.Accept (El,ActualAddress,Size)
End;

Procedure BN_Max.Retrieve (Var El; Address : DimensionPtr;
                                   Dimension : Byte; Size : Word);
                                         {Get the Addressed El}
Var
  ActualAddress : LongInt;
Begin
  If Dimension <> Dim Then Error (1);
  ActualAddress := Map(Address,Dimension,Len);
  BufferedArray.Retrieve (El,ActualAddress,Size)
End;

Procedure BN_Max.Copy (From : BN_Max);
                              {Target *MUST* already be initialized}
                              {to the EXACT same parameters as From}
                              {this will save checking for sufficient}
                              {available Memory!}
Begin
  If Dim <> From.Dim Then Error (2);
  BufferedArray.Copy (From)
End;

Procedure BN_Max.Swap (I,J : DimensionPtr; Dimension : Byte);
                              {Swap the Ith and Jth Elements}
Var
  Actual_I,Actual_J : LongInt;
Begin
  If Dimension <> Dim then Error (3);
  Actual_I := Map(I,Dimension,Len);
  Actual_J := Map(I,Dimension,Len);
  BufferedArray.Swap (Actual_I,Actual_J)
End;

Procedure BN_Max.Destroy;
Begin
  FreeMem (Len,Dim*SizeOf(LongInt));
  FreeMem (Add1,Dim*SizeOf(LongInt));
  FreeMem (Add2,Dim*SizeOf(LongInt));
  BufferedArray.Destroy
End;

BEGIN
END.