PROGRAM Create2;              { (C) 1993 John C. Leon    last updated 6/8/93 }

{
Create a Btrieve file with a meaningless and arbitrary file structure and an
owner name, just to demonstrate the BTP unit.

Creates a *variable length* file with a 10% free space threshold, with a
record length of 30 for the fixed length portion of a record, with two keys.
The owner access is set to RQ, to require the name for both read and write,
with no encryption.

After file creation, we open the file by instantiating an object of the base
class, BFile, in order to add a supplemental index which uses an alternate
collating sequence.  The typical calling convention for the AddSuppIdx
function is used, which builds a linked list of key specs on the heap on the
fly.  The heap objects are deleted internally within the AddSuppIdx function.
Note also that the alternate collating sequence is opened and read into the
data buffer transparently.  This is done within AddSuppIdx by instantiating
an object of type TAltColSeq.  Beautiful illustration of the cooperation
between objects in BTP!

Be sure to have the file UPPER.ALT in the current directory when running this
program!
}

{$IFDEF production} {$D-,R-,L-,S-} {$ENDIF}

USES
   Dos, BTP;

VAR
   Counter,
   Counter1   : integer;
   DirInfo    : SearchRec;
   MyFileSpec : PFileSpecObj;
   MyFileName : string;
   MyAltColSeq: PAltColSeq;
   TestFile   : PBFile;

BEGIN
   if not IsBtrieveLoaded then
      begin
      writeln('Please load Btrieve before running this program.');
      halt(1);
      end;

   FindFirst('Upper.ALT', Archive, DirInfo);
   if doserror <> 0 then
      begin
      writeln('This program requires the UPPER.ALT alternate collating sequence');
      writeln('in the current directory.');
      halt(2);
      end;
   write('Enter name of file to create: ');
   readln(MyFileName);
   if MyFileName = '' then
      begin
      writeln('No filename entered...aborting');
      halt(3);
      end;
   
   MyFileSpec := new(PFileSpecObj, Init(30, 512, 2, VarLength or Free10, 0,
                     NewKeySpec(11, 20, Duplicates or Modifiable or ExtType,
                                BString,
                     NewKeySpec(1, 10, Duplicates or Modifiable or ExtType,
                                BString,
                                nil))));
   
   {Create initially w/no alt col sequence.  We add it only for the supp index.}
   
   BStatus := CreateFile(MyFileName, MyFileSpec^.Specs, '', 'BTP', RQ);
   dispose(MyFileSpec, Done);
   if BStatus <> 0 then
      begin
      writeln('Error creating file.  Status = ', BStatus);
      halt(4);
      end;

   for Counter := 1 to length(MyFileName) do
      MyFileName[Counter] := upcase(MyFileName[Counter]);
   writeln('File ', MyFileName, ' created successfully.');
   
   {Now add the supplemental index ... this op requires the file be open,
    so let's instantiate a BFile object, which does it all for us.  Besides,
    the AddSuppIdx function is a member of BFile. }

   TestFile := new(PBFile, Init(MyFileName, Normal, 'BTP'));
   TestFile^.AddSuppIdx( NewKeySpec(
                         5, 2, Duplicates or Modifiable or Segmented or
                               AltCol or ExtType, BString,
                         NewKeySpec(
                         16, 2, Duplicates or Modifiable or
                                AltCol or ExtType, BString,
                         nil)),
                         'UPPER.ALT');
   TestFile^.Close;
   dispose(TestFile, Done);
   
   if (BStatus <> 0) then
      begin
      writeln('Adding of supplemental indexes failed.  Status = ', BStatus);
      halt(5);
      end
      else
      writeln('Supplemental indexes added successfully.');
END.
