TYPE
 Info=RECORD
  Address,
  City  : STRING[20];
  Phone : STRING[14];
  CASE Business : BOOLEAN OF
  False:(First : STRING[15];
         Mid   : CHAR;
         Last  : STRING[15];
         Age   : BYTE);
  True: (Name  : STRING[26];
         Years : WORD;
         PorL  : REAL;
         GorL  : INTEGER);
 END; {variable record}

VAR
 CA      : ARRAY[1..5,1..5] OF WORD;
 AddInfo,
 More    : Boolean;
 InfoFile:FILE OF Info;
 A1,A2,
 C1,C2   : WORD;
 InfoRec : Info;

PROCEDURE BlankInfo;
BEGIN
 FillChar(InfoRec,SizeOf(InfoRec),0); InfoRec.Phone:='(   )    -    ';
END;

PROCEDURE Init;
{initialize 3 pages of ASG procs, assign & open data file, init vars}
BEGIN
 MakeASGHeapPage(1,7); {Page 1 has 7 fields t/b filled}
 {set up ASG attributes}
 OrgAttr:=7; SayAttr:=7; GetAttr:=113; EndAttr:=15;
 WITH InfoRec DO
 BEGIN
  AddASGSL(1, 5,4,'First    ',@First,15);
  AddASGCP(1, 5,5,'Initial  ',@Mid,'A');
  AddASGSL(1, 5,6,'Last     ',@Last,15);
  AddASGByte(1,47,6,'Age      ',@Age,2);
  AddASGSL(1,47,7,'Address  ',@Address,20);
  AddASGSL(1,47,8,'City     ',@City,20);
  AddASGSP(1, 5,9,'Phone    ',@Phone,'(999) 999-9999');
 END;
 MakeASGHeapPage(2,4); {Page 2 has 4 fields t/b filled}
 WITH InfoRec DO
 BEGIN
  AddASGSL(2, 5,6,'Name   ',@Name,25);
  AddASGSL(2,47,6,'Address',@Address,20);
  AddASGSL(2,47,8,'City   ',@City,20);
  AddASGSP(2, 5,9,'Phone  ',@Phone,'(999) 999-9999');
 END;
 MakeASGHeapPage(3,3); {Page 3 has 3 fields t/b filled}
 {set up new ASG attributes}
 OrgAttr:=71; SayAttr:=71; GetAttr:=112; EndAttr:=79;
 WITH InfoRec DO
 BEGIN
  AddASGW (3,2,2,'Years in business.......',@Years,2);
  AddASGR (3,2,3,'Profit/Loss this year  $',@PorL,10,2);
  AddASGI (3,2,4,'Gain/Loss of employees..',@GorL,4);
 END;
 TextAttr:=7; OrgAttr:=7; SayAttr:=7; GetAttr:=113;
 AddInfo:=False; Cont:=True; More:=True; FillChar(CA,SizeOf(CA),0);
 Assign(InfoFile,'READDEMO.DAT');
 IF OnFile('READDEMO.DAT') THEN RESET(InfoFile) ELSE
 BEGIN
  REWRITE(InfoFile); AddInfo:=True;
 END;
END;
