{
Turbo Pascal ANSI Drivers
Version 1.12
Copyright (c) 1990 by Not So Serious Software

Original concept by Ian Silver
Design and implementation by Kevin Dean

Kevin Dean
Fairview Mall P.O. Box 55074
1800 Sheppard Avenue East
Willowdale, Ontario
CANADA    M2J 5B9
CompuServe ID: 76336,3114
}


{$I-,F-,S-,R-}
unit CONCOMIO;


interface


uses
  DOS,
  ANSI, ANSICON, ANSICOM;


type
  ErrorProc =			{ Communications error handling procedure }
    ANSICOM.ErrorProc;


const
  Init =			{ Initialize modem when setting parameters }
    ANSICOM.Init;
  NoInit =			{ Assume modem already initialized }
    ANSICOM.NoInit;

  SyncTransmit =		{ Synchronize transmission with output function }
    ANSICOM.SyncTransmit;
  AsyncTransmit =		{ Return from output function immediately }
    ANSICOM.AsyncTransmit;

  NoCommError =			{ No communications error }
    ANSICOM.NoCommError;
  ReceiveOverrun =		{ Received data overrun }
    ANSICOM.ReceiveOverrun;
  TransmitOverrun =		{ Output buffer overrun }
    ANSICOM.TransmitOverrun;
  ParityError =			{ Data parity error }
    ANSICOM.ParityError;
  FramingError =		{ Data framing error }
    ANSICOM.FramingError;
  BreakDetect =			{ Break signal detected }
    ANSICOM.BreakDetect;
  CommTimeOut =			{ Communications time-out (off-line) }
    ANSICOM.CommTimeOut;
  NoCarrier =			{ No carrier }
    ANSICOM.NoCarrier;
  CtrlBreak =			{ Ctrl-Break key pressed }
    ANSICOM.CtrlBreak;
  NotOnline =			{ Communications routines not online }
    ANSICOM.NotOnline;

  NoneActive =			{ No I/O driver active }
    $0000;
  ConsoleActive =		{ Console I/O driver active }
    $0001;
  CommActive =			{ Communications I/O driver active }
    $0002;
  BothActive =			{ Both I/O drivers active }
    ConsoleActive or CommActive;

  ActiveInput : word =		{ Active input drivers }
    BothActive;
  ActiveOutput : word =		{ Active output drivers }
    BothActive;


function InitCOM(COMPort : byte; Baud : integer; Bits : byte; Parity : char;
 Stop : byte; Init : boolean; Sync : boolean; Error : pointer) : integer;
function SetBaud(Baud : integer; Bits : byte; Parity : char; Stop : byte) : integer;
procedure Disconnect;
procedure ReleaseCOM;
procedure AssignCONCOM(var F : Text);
function KeyPressed : boolean;
function ReadKey : char;


implementation


{***}
{ Initialize communications port and install interrupt }
function InitCOM(COMPort : byte; Baud : integer; Bits : byte; Parity : char;
 Stop : byte; Init : boolean; Sync : boolean; Error : pointer) : integer;

begin
InitCOM := ANSICOM.InitCOM(COMPort, Baud, Bits, Parity, Stop, Init, Sync, Error)
end;


{***}
{ Change baud rate and data format dynamically }
function SetBaud(Baud : integer; Bits : byte; Parity : char; Stop : byte) : integer;

begin
SetBaud := ANSICOM.SetBaud(Baud, Bits, Parity, Stop)
end;


{***}
{ Disconnect modem }
procedure Disconnect;

begin
ANSICOM.Disconnect
end;


{***}
{ Release communications port }
procedure ReleaseCOM;

begin
ANSICOM.ReleaseCOM
end;


{$F+}

{***}
{ Handle line-oriented console or modem input }
function CONCOMIn(var F : Text) : integer;

var
  NumRead : integer;	{ Number of characters read }
  Done : boolean;	{ True if end of line }
  PendingKey : char;	{ Key waiting on input stream }

begin
case ActiveInput of
  ConsoleActive:
    CONCOMIn := ConsoleIn(F);

  CommActive:
    CONCOMIn := ModemIn(F);

  BothActive:
    begin
    NumRead := 0;

    Done := false;
    while not Done do
      begin
      { Wait for input from console or modem }
      while not KeyPressed do
	inline
	(
	$CD/$28		{ INT	28h }
	);

      { Give priority to console }
      if ANSICON.KeyPressed then
	PendingKey := ANSICON.ReadKey
      else
	PendingKey := ANSICOM.ReadKey;

      case PendingKey of
	NUL:
	  { Ignore extended keys }
	  begin
	  { Wait for input from console or modem }
	  while not KeyPressed do
	    inline
	    (
	    $CD/$28		{ INT	28h }
	    );

	  { Give priority to console }
	  if ANSICON.KeyPressed then
	    PendingKey := ANSICON.ReadKey
	  else
	    PendingKey := ANSICOM.ReadKey
	  end;

	BS:
	  { Erase last character if possible }
	  if (NumRead <> 0) and (WhereX <> 1) then
	    begin
	    Write(BS, ' ', BS);
	    Dec(NumRead)
	    end;

        CR, LF:
	  { End of line }
	  begin
	  Done := true;
	  TextRec(F).BufPtr^[NumRead] := CR;
	  Inc(NumRead);
	  TextRec(F).BufPtr^[NumRead] := LF;
	  Inc(NumRead);
	  WriteLn
	  end;

	EOF_:
	  { End of file }
	  if CheckEOF then
	    begin
	    Done := true;
	    TextRec(F).BufPtr^[NumRead] := EOF_;
	    Inc(NumRead)
	    end;

	ESC:
	  { Clear current input }
	  begin
	  Write('\', LF);
	  if MaxX = 0 then
	    GotoXY(WhereX - NumRead - 1 + MaxX, WhereY)
	  else
	    GotoXY((WhereX - NumRead + MaxX - 2) mod MaxX + 1, WhereY);
	  NumRead := 0
	  end;

	else
	  { Display the character }
	  with TextRec(F) do
	    if NumRead < BufSize - 2 then
	      begin
	      BufPtr^[NumRead] := PendingKey;
	      Write(PendingKey);
	      Inc(NumRead)
	      end
	end
      end;

    { Save buffer pointers }
    with TextRec(F) do
      begin
      BufPos := 0;
      BufEnd := NumRead
      end;

    CONCOMIn := 0
    end;

  else
    { Device read fault }
    CONCOMIn := 161
  end
end;


{***}
{ Display text on console and modem }
function CONCOMOut(var F : Text) : integer;

var
  BufPos : word;	{ Output buffer position }
  CONResult : integer;	{ Result of console output }
  COMResult : integer;	{ Result of modem output }

begin
BufPos := TextRec(F).BufPos;
case ActiveOutput of
  ConsoleActive:
    CONCOMOut := ConsoleOut(F);

  CommActive:
    CONCOMOut := ModemOut(F);

  BothActive:
    begin
    BufPos := TextRec(F).BufPos;
    CONResult := ConsoleOut(F);
    TextRec(F).BufPos := BufPos;
    COMResult := ModemOut(F);
    if CONResult = 0 then
      CONCOMOut := COMResult
    else
      CONCOMOut := CONResult
    end;

  else
    { Device write fault }
    CONCOMOut := 160
  end
end;


{***}
{ Flush console and modem buffers }
function CONCOMFlush(var F : Text) : integer;

begin
with TextRec(F) do
  if Mode = fmInput then
    { Ignore flush request }
    CONCOMFlush := 0
  else
    { Chain to F's default output routine }
    CONCOMFlush := IOFunc(InOutFunc)(F)
end;


{***}
{ Open console and modem for input or output }
function CONCOMOpen(var F : Text) : integer;

begin
with TextRec(F) do
  if Mode = fmInput then
    IOFunctions(UserData).NextInOut := @CONCOMIn
  else
    IOFunctions(UserData).NextInOut := @CONCOMOut;

CONCOMOpen := 0
end;


{***}
{ Close console and modem (do nothing) }
function CONCOMClose(var F : Text) : integer;

begin
CONCOMClose := 0
end;

{$F-}


{***}
{ Assign a file to the console and the communications port }
procedure AssignCONCOM(var F : Text);

var
  IOChain : IOFunctions;	{ Console I/O function chain }

begin
with IOChain do
  begin
  NextOpen := @CONCOMOpen;
  NextInOut := nil;
  NextFlush := @CONCOMFlush;
  NextClose := @CONCOMClose
  end;

AssignANSI(F, IOChain)
end;


{***}
{ Return true if character in either input buffer }
function KeyPressed : boolean;

begin
case ActiveInput of
  ConsoleActive:
    KeyPressed := ANSICON.KeyPressed;

  CommActive:
    KeyPressed := ANSICOM.KeyPressed;

  BothActive:
    KeyPressed := ANSICON.KeyPressed or ANSICOM.KeyPressed;

  else
    KeyPressed := false
  end
end;


{***}
{ Read character from input buffer }
function ReadKey : char;

var
  Regs : Registers;	{ MS-DOS registers }

begin
case ActiveInput of
  ConsoleActive:
    ReadKey := ANSICON.ReadKey;

  CommActive:
    ReadKey := ANSICOM.ReadKey;

  BothActive:
    begin
    { Wait for input from console or modem }
    while not KeyPressed do
      inline
      (
      $CD/$28		{ INT	28h }
      );

    { Give priority to console }
    if ANSICON.KeyPressed then
      ReadKey := ANSICON.ReadKey
    else
      ReadKey := ANSICOM.ReadKey
    end;

  else
    ReadKey := #0
  end
end;


{***}
begin
CheckBreak := false;

Close(Input);
Close(Output);

AssignCONCOM(ANSIFile);
Rewrite(ANSIFile);

AssignCONCOM(Input);
Reset(Input);

AssignCONCOM(Output);
Rewrite(Output)
end.