  Unit AnsCrt;
  {By Rick Housh - CIS PIN 72466,212}
  {ANSI Alternate to CRT unit}
  {Uses standard ANSI calls for all cursor placement, color attribute }
  {changes, etc., and Interrupt 21h DOS calls for everything else. }
  {No ROM BIOS calls at all.  Should work on any MS-DOS computer with ANSI}
  {support.}
(**************************************************************************)
{ The variable TextAttr is maintained, although not used.  Just for the
  curious.  It serves no purpose.  The variable CheckBreak is supported.
  None of the other variables are supported, as almost all have to do
  with various aspects of direct screen writing, which is not supported.

  None of the Crt Mode constants are supplied.  All of the Text Color
  constants are supported.

  It is possible to do much more with ANSI actually, than with many of
  Turbo's standard CRT procedures, but no extras were implemented, in
  the interest of compatibility with Turbo.

  There is one major limitation.  The window procedure is not supported.
  In the interest of universal compatibility Textmode is also not supported,
  although it could be.

  The following CRT unit functions and procedures are supported as follows:
    AssignCrt      :   Not supported
    ClrEol         :   Fully supported
    ClrScr         :   Fully supported
    Delay          :   Not supported
    DelLine        :   Not supported    (Could easily be, but never used it)
    GotoXY         :   Fully supported
    HighVideo      :   Fully supported
    InsLine        :   Not Supported    (See DelLine)
    LowVideo       :   Fully supported
    NoSound        :   Not supported
    Sound          :   Not supported
    TextBackground :   Fully supported
    TextColor      :   Fully supported
    TextMode       :   Not supported
    Window         :   Not supported
    KeyPressed     :   Fully supported
    NormVideo      :   Fully supported
    ReadKey        :   Fully supported
    WhereX         :   Fully supported
    WhereY         :   Fully supported

  Those miscellaneous functions which are not supported are almost all
  available in Carley Phillip's CRTI unit, available in this DL as
  CRTI.ARC.  Combine some of these and some of those in one unit if you
  need the Sound, NoSound, Delay, etc.  If you do this however, you will
  lose some of the MS-DOS generic nature of these routines, which depend
  only on DOS and ANSI, and require no IBM compatibility.  Under NO
  circumstances may this unit be used in combination with the standard
  CRT unit.  It is a replacement.  The Graph, Graph3 and Turbo3 units
  are not compatible with this unit and should not be used either.

 This unit supplies one unit not available in CRT, the GetKey function.
 Most of the time I just want a character returned.  I am not interested
 in function keys, etc.  GetKey does just that.  It first flushes the
 keyboard, in case you accidentally pressed something, ignores function
 keys, and returns the value of the keypress as a character.  Where the
 variable ch is a character, the appropriate syntax would be:
    ch := GetKey;
 It will then wait for the key.

        This program is dedicated to the public domain.
        No copyright is claimed.
        I would be interested in reports.
                    Rick Housh
                    5811 W. 85th Terr.
                    Overland Park, KS 66207
                    Tel. 913/341-7592
                    Compuserve PIN #72466,212

}




  Interface
  Const
    Black = 0; Blue = 1; Green = 2; Cyan = 3; Red = 4; Magenta = 5;
    Brown = 6; LightGray = 7; DarkGray = 8; LightBlue = 9;
    LightGreen = 10; LightCyan = 11; LightRed = 12; LightMagenta = 13;
    Yellow = 14; White = 15; Blink = 128;

  Var
    CheckBreak, CheckEOF,
     Blinking            : Boolean;
    TextAttr, ForeColour,
     BackColour          : Byte;
    Function Keypressed  : Boolean;
    Function GetKey      : Char;
    Function ReadKey     : Char;
    Function WhereX      : Byte;
    Function WhereY      : Byte;
    Procedure NormVideo;
    Procedure LowVideo;
    Procedure HighVideo;
    Procedure ClrEol;
    Procedure ClrScr;
    Procedure GotoXY(X, Y : Byte);
    Procedure TextBackGround(Back : Byte);
    Procedure TextColor(Fore : Byte);


  Implementation

  Function KeyPressed : boolean;   { Replacement for CRT.KeyPressed }
                         {  ;Detects whether a key is pressed}
                         {  ;Does nothing with the key}
                         {  ;Returns true if key is pressed}
                         {  ;Otherwise, false}
                         {  ;Key remains in kbd buffer}
    Var IsThere : Byte;
    Begin
      Inline(
      $B4/$0B/               {    MOV AH,+$0B         ;Get input status}
      $CD/$21/               {    INT $21             ;Call DOS}
      $88/$86/>ISTHERE);     {    MOV >IsThere[BP],AL ;Move into variable}
      If IsThere = $FF then Keypressed := True else keypressed := False;
    end;

  Procedure  ClrEol;     { ANSI replacement for CRT.ClrEol }
    Begin
      Write(#27'[K');
    end;

  Procedure ClrScr;     { ANSI replacement for CRT.ClrScr }
    Begin
      Write(#27'[2J');
    end;

  Function GetKey : char;     { Additional function.  Not in CRT Unit }
    Var CH : char;
    Begin
      Inline(
                     {; Function GetKey : Char}
                     {; Clears the keyboard buffer then waits until}
                     {; a key is struck.  If the key is a special, e.g.}
                     {; function key, goes back and reads the next}
                     {; byte in the keyboard buffer.  Thus does}
                     {; nothing special with function keys.}
      $B4/$0C        {       MOV  AH,$0C      ;Set up to clear buffer}
      /$B0/$08       {       MOV  AL,8        ;then to get a char}
      /$CD/$21       {SPCL:  INT  $21         ;Call DOS}
      /$3C/$00       {       CMP  AL,0        ;If it's a 0 byte}
      /$75/$04       {       JNZ  CHRDY       ;is spec., get second byte}
      /$B4/$08       {       MOV  AH,8        ;else set up for another}
      /$EB/$F6       {       JMP  SHORT SPCL  ;and get it}
      /$88/$46/>CH   {CHRDY: MOV  >CH[BP],AL  ;else put into function return}
       );
      If CheckBreak and (Ch = #3) then
        Begin        {If CheckBreak is true and it's a ^C}
          Inline(    {then execute Ctrl_Brk}
          $CD/$23);
        end;
      GetKey := Ch;
    end; {Inline function GetKey}


  Function ReadKey : char;  { Replacement for CRT.ReadKey }
    Var chrout : char;
    Begin
                         {  ;Just like ReadKey in CRT unit}
      Inline(
      $B4/$07/               {  MOV AH,$07          ;Char input w/o echo}
      $CD/$21/               {  INT $21             ;Call DOS}
      $88/$86/>CHROUT);      {  MOV >chrout[bp],AL  ;Put into variable}
      If CheckBreak and (chrout = #3) then  {If it's a ^C and CheckBreak true}
        Begin                             {then execute Ctrl_Brk}
          Inline(
          $CD/$23);           {     INT $23}
        end;
      ReadKey := chrout;                    {else return character}
    end;


  Function WhereX : byte;       { ANSI replacement for CRT.WhereX }
    var                         { Cursor position report. This is column or }
      ch  : char;               { X axis report.}
      st  : String;
      st1 : String[2];
      x   : byte;
      i   : integer;

    begin
      Write(#27'[6n');          { Ansi string to get X-Y position }
      st := '';                 { We will only use X here }
      ch := #0;                 { Make sure character is not 'R' }
      While ch <> 'R' do        { Return will be }
        begin                   { Esc - [ - Ypos - ; - Xpos - R }
          ch := #0;
          ch := readkey;        { Get one }
          st := st + ch;        { Build string }
        end;
        St1 := copy(St,6,2);    { Pick off substring having number in ASCII}
        Val(St1,x,i);           { Make it numeric }
        WhereX := x;            { Return the number }
    end;

  Function WhereY : byte;       { ANSI replacement for CRT.WhereY }
    var                         { Cursor position report.  This is row or }
      ch  : char;               { Y axis report.}
      st  : String;
      st1 : String[2];
      y   : byte;
      i   : integer;

    begin
      Write(#27'[6n');          { Ansi string to get X-Y position }
      st := '';                 { We will only use Y here }
      ch := #0;                 { Make sure character is not 'R' }
      While ch <> 'R' do        { Return will be }
        begin                   { Esc - [ - Ypos - ; - Xpos - R }
          ch := #0;
          ch := readkey;        { Get one }
          st := st + ch;        { Build string }
        end;
        St1 := copy(St,3,2);    { Pick off substring having number in ASCII}
        Val(St1,y,i);           { Make it numeric }
        WhereY := y;            { Return the number }
    end;


    Procedure GotoXY(x : byte ; y : byte); { ANSI replacement for CRT.GoToXY}
      Begin
        If (x < 1) or (y < 1) then exit;
        If (x > 80) or (y > 25) then exit;
        Write(#27'[',y,';',x,'H');
      end;

   Procedure TextColor(Fore : Byte);
     Begin
       If not ((Fore in [0..15]) or (Fore in [128..143])) then exit;
       ForeColour := Fore;
       Blinking := False;
       Write(#27'[0m');
       TextBackGround(BackColour);
       If Fore >  127 then
         begin
           If Fore > 128 then Fore := Fore - 128;
           Blinking := True;
           Write(#27'[5m');
         end;
       Case Fore of
          0  :  Write(#27'[30m');
          1  :  Write(#27'[34m');
          2  :  Write(#27'[32m');
          3  :  Write(#27'[36m');
          4  :  Write(#27'[31m');
          5  :  Write(#27'[35m');
          6  :  Write(#27'[33m');
          7  :  Write(#27'[37m');
          8  :  Write(#27'[1;30m');
          9  :  Write(#27'[1;34m');
         10  :  Write(#27'[1;32m');
         11  :  Write(#27'[1;36m');
         12  :  Write(#27'[1;31m');
         13  :  Write(#27'[1;35m');
         14  :  Write(#27'[1;33m');
         15  :  Write(#27'[1;37m');
       end;  { Case }

       TextAttr := (TextAttr AND $70) + Fore;
     end;

   Procedure TextBackGround(Back : Byte);{Replacement for CRT.TextBackground}
     Begin
       If Back > 7 then exit;     { No illegal values allowed }
       BackColour := Back;
       Case Back of
           0  :  Write(#27'[40m');
           1  :  Write(#27'[44m');
           2  :  Write(#27'[42m');
           3  :  Write(#27'[46m');
           4  :  Write(#27'[41m');
           5  :  Write(#27'[45m');
           6  :  Write(#27'[43m');
           7  :  Write(#27'[47m');
         end;  { Case }
       TextAttr := (TextAttr AND $8F) + Back * 16;
     end;


   Procedure NormVideo;   { ANSI Replacement for CRT.NormVideo }
     Begin
       Write(#27'[0m');
       ForeColour := LightGray;
       BackColour := Black;
       TextAttr := $07;   { Just to maintain it }
     end;

   Procedure LowVideo;    { Replacement for CRT.LowVideo }
     Begin
       If ForeColour > 7 then ForeColour := ForeColour - 8;
       Write(#27'[0m');
       TextBackGround(BackColour);
       If not Blinking then TextColor(ForeColour)
          else TextColor(ForeColour + 128);
       TextAttr := TextAttr AND $0F;  {Just to maintain it}
     end;

   Procedure HighVideo;   { Replacement for CRT.HighVideo }
     Begin
       If ForeColour < 8 then ForeColour := ForeColour + 8;
       If Not Blinking then TextColor(ForeColour)
           else TextColor(ForeColour + 128);
       TextAttr := TextAttr OR $0F;
     end;


   var Dummy : char;        {Local variable to eat characters}

   Begin    { Setup }
    CheckBreak := True;
    CheckEOF := False;
    TextAttr := 7;
    BackColour := Black;
    ForeColour := LightGray;
    Blinking   := False;
    Write(#27'[6n');               { Ask for cursor position report via }
      If not keypressed then       { the ANSI driver.  If it returns }
          begin                    { nothing in the keyboard buffer }
            WriteLn(               { then no ANSI, so abort }
 #13#7'This program requires the ANSI driver and it is not loaded.  Aborting.');
            Halt;
          end
            else                   { If ANSI is loaded then }
          Repeat                   { just empty the keyboard buffer }
            Dummy := Readkey;
          until not keypressed;
   end.