
        {Compiler directives}
{D-}                    {debug information}
{T-}                    {create .TPM file for debugging}
{F-}                    {automatically force far calls}
{V-}                    {var string checking}
{L+}                    {link buffer in memory}
{$R-}                   {range checking}
{$B+}                   {boolean complete evaluation}
{$S+}                   {stack checking}
{$I+}                   {I/O checking}
{$N-}                   {numeric coprocessor}
{$M 65500,0,0}          {memory sizes}

{***************************************************************************}
{*                                                                         *}
{*      MISCSTUF.PAS        Copyright - Matt Goodrich                      *}
{*                              Jun 29, 1991                               *}
{*                                                                         *}
{*   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -   *}
{*                                                                         *}
{*      Maintenance History :                                              *}
{*                                                                         *}
{*  1.A  MG  6/29/91 - Initial keyin.                                      *}
{*                                                                         *}
{***************************************************************************}

UNIT MISCSTUF;

INTERFACE

USES
  CRT, DOS;

TYPE
  IntPtr    = ^INTEGER;
  ScrnArray = ARRAY [0..3999] OF BYTE;
  ScreenPtr = ^ScrnArray;

CONST
  Reverse_Video     = 1;
  Yes               = 'Y';
  Normal_Video      = 0;
  No                = 'N';
  Blink_Video       = 4;
  Bold_Video        = 2;
  Bla               = ' ';
  Bla50             = '                                                  ';


{$I MISCSTUF.INC}    { Has the various 'scan codes' used by 'Keyin_Char'.}


VAR
  SomePtr          : IntPtr;
  ScreenAddress    : WORD;
  ScrnPtr          : ScreenPtr;

  Ctrl_Key         : INTEGER;       {has a value if ESC, PgUp, etc was hit  }
  Ins_Mode         : STRING [ 1];   {Keyin insert mode on? (Y/N)            }

{***************************************************************************}
{***************************************************************************}
{***************************************************************************}
{********           Here are the routines in this UNIT               *******}
{***************************************************************************}
{***************************************************************************}
{***************************************************************************}

  PROCEDURE Disp_String (Out_String : String; X, Y, Attrib : INTEGER);

  PROCEDURE Disp_Blanks (HowMany : INTEGER; X, Y, Attrib : INTEGER);

  PROCEDURE Keyin_String (VAR In_String                : STRING;
                              X, Y, Attrib, Str_Length : INTEGER;
                              Retain_Value             : STRING;
                          VAR Ins_Mode                 : STRING;
                          VAR Ctrl_Key                 : INTEGER);

  PROCEDURE Disp_Number (Number  : REAL; X, Y, Attrib, Num_Length,
                         Num_Dec : INTEGER);


  FUNCTION  Valid_Date (MM, DD, YYYY : STRING) : STRING;

  PROCEDURE Keyin_Date (VAR MM, DD, YYYY  : STRING;
                            X,Y, Vid_Mode : INTEGER;
                        VAR Ins_Mode : STRING;
                        VAR Ctrl_Key : INTEGER);

  PROCEDURE NormToGreg (    GMM, GDD, GYYYY : STRING;
                        VAR GregDate        : LONGINT);

  PROCEDURE GregToNorm (    GregDate        : LONGINT;
                        VAR GMM, GDD, GYYYY : STRING);


  PROCEDURE Convert_Upper      (VAR InOutString255 : STRING);

  PROCEDURE Strip_Trail_Blanks (VAR InOutString255 : STRING);

  PROCEDURE Cursor_Off;

  PROCEDURE Cursor_On;

  PROCEDURE Keyin_Char (VAR MyKeyedChar : INTEGER);

  PROCEDURE Set_Video (Attribute : INTEGER);

  PROCEDURE Copy_File (SourceName, DestName : STRING;
                   VAR CopyError            : INTEGER);


  PROCEDURE Get_New_Masks (VAR NewMask, NewDirMask, NewFileMask : STRING);

  PROCEDURE Save_Screen;

  PROCEDURE Restore_Screen;

  PROCEDURE Draw_DBox (X1, Y1, X2, Y2, VidMode : INTEGER);


IMPLEMENTATION

{***************************************************************************}
{***************************************************************************}
{***************************************************************************}
{***************************************************************************}
{***************************************************************************}
{***************************************************************************}
{***************************************************************************}


PROCEDURE Set_Video;

{---------------------------------------------------------------------------}
{ This routine sets the video attributes for future input and output.       }
{                                                                           }
{  INPUT:    Attribute (INTEGER) = video attribute [0-9]                    }
{                                                                           }
{  NOTES:    0 normal                5 reverse, blinking                    }
{            1 reverse               6 bold, blinking                       }
{            2 bold                  7 bold, underline                      }
{            3 underline             8 underline, blinking                  }
{            4 blinking              9 bold, underline, blinking            }
{                                                                           }
{---------------------------------------------------------------------------}

BEGIN

  { TEXTATTR is TEXTBACKGROUND & TEXTCOLOR combined together (I think!) }


  IF Attribute = 0                     {normal}
    THEN BEGIN
           TEXTBACKGROUND (  0);
           TEXTCOLOR      (  2);
         END

  ELSE IF Attribute = 1                {reverse}
    THEN BEGIN
           TEXTBACKGROUND (  7);
           TEXTCOLOR      (  0);
         END

  ELSE IF Attribute = 2                {bold}
    THEN BEGIN
           TEXTBACKGROUND (  0);
           TEXTCOLOR      ( 11);
         END

  ELSE IF Attribute = 3                {underline}
    THEN BEGIN
           TEXTBACKGROUND (  0);
           TEXTCOLOR      (  1);
         END

  ELSE IF Attribute = 4                {blinking}
    THEN BEGIN
           TEXTBACKGROUND (  0);
           TEXTCOLOR      ( 19);
         END

  ELSE IF Attribute = 5                {reverse blinking}
    THEN BEGIN
           TEXTBACKGROUND ( 15);
           TEXTCOLOR      ( 16);
         END

  ELSE IF Attribute = 6                {bold blinking}
    THEN BEGIN
           TEXTBACKGROUND (  8);
           TEXTCOLOR      ( 26);
         END

  ELSE IF Attribute = 7                {bold underline}
    THEN BEGIN
           TEXTBACKGROUND (  0);
           TEXTCOLOR      (  9);
         END

  ELSE IF Attribute = 8                {underline blinking}
    THEN BEGIN
           TEXTBACKGROUND (  8);
           TEXTCOLOR      ( 17);
         END

  ELSE IF Attribute = 9                {bold underline blinking}
    THEN BEGIN
           TEXTBACKGROUND (  8);
           TEXTCOLOR      ( 25);
         END;

END;

{***************************************************************************}


PROCEDURE Disp_String;

{---------------------------------------------------------------------------}
{ This routine displays a string at a given location on the screen with a   }
{      given video attribute.                                               }
{                                                                           }
{  INPUT:    Out_String (String 80) = string to be displayed                }
{            X          (INTEGER)   = screen column number                  }
{            Y          (INTEGER)   = screen line   number                  }
{            Attrib     (INTEGER)   = video attribute [0-7]                 }
{                                                                           }
{---------------------------------------------------------------------------}

BEGIN

   {set video attributes and the cursor location}
   Set_Video (Attrib);
   GotoXY (X, Y);
   Write (Out_String);

   { reset to normal video}
   Set_Video (0);

END;

{***************************************************************************}



PROCEDURE Disp_Number;

{---------------------------------------------------------------------------}
{ This routine displays a number (with commas inserted) at a given location }
{      on the screen with a given video attribute.                          }
{                                                                           }
{  INPUT:    Number     (numeric)   = number to be displayed                }
{            X          (INTEGER)   = screen column number                  }
{            Y          (INTEGER)   = screen line   number                  }
{            Attrib     (INTEGER)   = video attribute [0-7]                 }
{            Num_Length (INTEGER)   = total length of display string        }
{                                         (including commas & decimal)      }
{            Num_Dec    (INTEGER)   = number of decimal places to display   }
{                                                                           }
{---------------------------------------------------------------------------}

VAR
  DispString80 : STRING [80];
  TempString80 : STRING [80];
  Counter      : INTEGER;
  DecPntPos    : INTEGER;

BEGIN

  {convert the number to a string}
  STR (Number : Num_Length : Num_Dec, DispString80);


  {if there is a decimal, we will have to account for it in our position }
  {     calculations                                                     }
  IF Num_Dec > 0
    THEN DecPntPos := 1
    ELSE DecPntPos := 0;


  {this loop creates a reversed string and puts commas in the appropriate}
  {            columns                                                   }
  TempString80 := '';
  FOR Counter := LENGTH (DispString80) DOWNTO 1 DO
    BEGIN
      IF (Counter > (Length (DispString80) - Num_Dec - DecPntPos))
        THEN BEGIN
               TempString80 := TempString80 + COPY (DispString80, Counter, 1);
             END
        ELSE BEGIN
               IF (LENGTH (DispString80) - Num_Dec - DecPntPos - Counter > 0)
                              AND
                 ((LENGTH (DispString80) - Num_Dec - DecPntPos - Counter) MOD 3
                           = 0)
                              AND
                 (COPY (DispString80, Counter, 1) <> ' ')
                              AND
                 (COPY (DispString80, Counter, 1) <> '-')
                      THEN TempString80 := TempString80 + ',' +
                                   COPY (DispString80, Counter, 1)
                      ELSE TempString80 := TempString80 +
                                   COPY (DispString80, Counter, 1);
             END;
    END;


  {the string is longer now, cuz of the inserted commas.  chop it back to}
  {it's proper size. (if the field overflowed, this will chop that off!) }
  TempString80 := COPY (TempString80, 1, Num_Length);


  {this loop reverses that backwards string}
  DispString80 := '';
  FOR Counter := LENGTH (TempString80) DOWNTO 1 DO
     BEGIN
        DispString80 := DispString80 + COPY (TempString80, Counter, 1);
     END;


  {output the string}
  Disp_String (DispString80, X, Y, Attrib);

END;

{***************************************************************************}



PROCEDURE Disp_Blanks;

{---------------------------------------------------------------------------}
{ This routine displays blanks at a given location on the screen with a     }
{      given video attribute.                                               }
{                                                                           }
{  INPUT:    HowMany    (INTEGER)   = how many blanks to display            }
{            X          (INTEGER)   = screen column number                  }
{            Y          (INTEGER)   = screen line   number                  }
{            Attrib     (INTEGER)   = video attribute [0-7]                 }
{                                                                           }
{---------------------------------------------------------------------------}

VAR
  TempInteger   : INTEGER;
  TempString80  : STRING [80];

BEGIN

  TempString80 := '';

  {create a string of blanks of the appropriate length}
  FOR TempInteger := 1 TO HowMany DO
    BEGIN
      TempString80 := TempString80 + ' ';
    END;

   Disp_String (TempString80, X, Y, Attrib);

END;

{***************************************************************************}



PROCEDURE Keyin_String;

{---------------------------------------------------------------------------}
{ This routine displays a string at a given location on the screen with a   }
{      given video attribute.                                               }
{                                                                           }
{  INPUT:    In_String                = string to be keyed into             }
{            Ins_Mode     (STRING 1)  = Insert mode on? (Y/N)               }
{            Y            (INTEGER)   = screen line   number                }
{            X            (INTEGER)   = screen column number                }
{            Attrib       (INTEGER)   = video attribute [0-7]               }
{            Str_Length   (INTEGER)   = Length of string being keyed (1-80) }
{            Retain_Value (STRING 1)  = Retain previous value of variable   }
{                                         before doing the keyin (Y/N)      }
{                                                                           }
{  OutPut:   In_String    (STRING)    = string to be keyed into             }
{            Ctrl_Key     (INTEGER)   = Has a value if a 'Ctrl key' was hit }
{                                         such as PgUp or ESC               }
{                                                                           }
{---------------------------------------------------------------------------}

CONST

     {Some of these are Pascal codes, not mine.  Don't use MISCSTUF.INC!!!}
  Back_Space      =   8;
  Bell            =   7;
  Carr_Return     =  13;
  Lft_Arrow_Code  =  75;
  Ctrl_PgUp_Code  = 132;
  Ctrl_PgDn_Code  = 118;
  Ctrl_Lft_Code   = 115;
  Ctrl_Rgt_Code   = 116;
  Del_Code        =  83;
  End_Code        =  79;
  Home_Code       =  71;
  Ins_Code        =  82;
  Null            =   0;
  Rgt_Arrow_Code  =  77;
  ESC_Code        =  27;

  Up_Code         =  72;
  Up_Key          = 199;
  Dn_Code         =  80;
  Dn_Key          = 207;

  PgUp_Code     =  73;
  PgUp_Key      = 200;
  PgDn_Code     =  81;
  PgDn_Key      = 208;

  F1_Code       =  59;
  F2_Code       =  60;
  F3_Code       =  61;
  F4_Code       =  62;
  F5_Code       =  63;
  F6_Code       =  64;
  F7_Code       =  65;
  F8_Code       =  66;
  F9_Code       =  67;
  F10_Code      =  68;

  Tab_Code      =   9;

  Blank           = ' ';
  No              = 'N';
  Yes             = 'Y';

VAR

  Cursor_Pos    : INTEGER;
  End_Loop      : STRING [ 1];
  EndBigLoop    : STRING [ 1];
  I             : INTEGER;
  In_Char       : CHAR;
  TempString80  : String [80];


{**************************************************************************}

PROCEDURE ProcessCtrlLeft;
BEGIN
   IF Cursor_Pos <= 2
     THEN Cursor_Pos := 1
     ELSE BEGIN
            IF COPY (In_String, Cursor_Pos - 1, 1) = Blank
              THEN BEGIN

                     End_Loop := No;
                     WHILE (End_Loop = No) DO
                       BEGIN
                         Cursor_Pos := Cursor_Pos - 2;
                         IF (Cursor_Pos = 0) OR
                            (COPY (In_String, Cursor_Pos, 1) <> Blank)
                           THEN BEGIN
                                  End_Loop   := Yes;
                                  Cursor_Pos := Cursor_Pos + 1;
                                END
                           ELSE Cursor_Pos   := Cursor_Pos + 1;
                       END;

                     End_Loop := No;
                     WHILE (End_Loop = No) DO
                       BEGIN
                         Cursor_Pos := Cursor_Pos - 2;
                         IF (Cursor_Pos <= 0) OR
                            (COPY (In_String, Cursor_Pos, 1) = Blank)
                           THEN BEGIN
                                  End_Loop   := Yes;
                                  Cursor_Pos := Cursor_Pos + 1;
                                END
                           ELSE Cursor_Pos   := Cursor_Pos + 1;
                       END;

                     IF Cursor_Pos <= 0
                       THEN Cursor_Pos := 1;

                   END

              ELSE BEGIN
                     End_Loop := No;
                     WHILE End_Loop = No DO
                       BEGIN
                         Cursor_Pos := Cursor_Pos - 2;
                         IF (Cursor_Pos = 0) OR (COPY (In_String, Cursor_Pos,
                                                                                        1) = Blank)
                           THEN BEGIN
                                  Cursor_Pos := Cursor_Pos + 1;
                                  End_Loop   := Yes;
                                END
                           ELSE BEGIN
                                  Cursor_Pos := Cursor_Pos + 1;
                                END;
                       END;
                   END;
          END;

END;

{**************************************************************************}

PROCEDURE ProcessCtrlRgt;
BEGIN
   IF Cursor_Pos >= LENGTH (In_String)
     THEN Cursor_Pos := LENGTH (In_String) + 1
     ELSE BEGIN
            IF COPY (In_String, Cursor_Pos, 1) = Blank
              THEN BEGIN

                     End_Loop := No;
                     WHILE (End_Loop = No) DO
                       BEGIN
                         Cursor_Pos := Cursor_Pos + 1;
                         IF (COPY (In_String, Cursor_Pos, 1) <> Blank) OR
                            (Cursor_Pos > Length (In_String))
                           THEN End_Loop := Yes;
                       END;

                   END
              ELSE BEGIN

                     End_Loop := No;
                     WHILE (End_Loop = No) DO
                       BEGIN
                         Cursor_Pos := Cursor_Pos + 1;
                         IF (COPY (In_String, Cursor_Pos, 1) = Blank) OR
                            (Cursor_Pos > Length (In_String))
                           THEN End_Loop := Yes;
                       END;

                     End_Loop := No;
                     WHILE (End_Loop = No) DO
                       BEGIN
                         Cursor_Pos := Cursor_Pos + 1;
                         IF (COPY (In_String, Cursor_Pos, 1) <> Blank) OR
                            (Cursor_Pos > Length (In_String))
                           THEN End_Loop := Yes;
                       END;

                     IF Cursor_Pos > LENGTH (In_String)
                       THEN Cursor_Pos := LENGTH (In_String) + 1;

                   END;
          END;
END;

{**************************************************************************}
{**************************************************************************}

BEGIN  {PROCEDURE Keyin_String}

  Ctrl_Key := 0;
  Cursor_On;

  IF Retain_Value <> 'Y'
    THEN In_String := '';

  {display the string (or blanks)}
  Disp_String (In_String, X, Y, Attrib);
  FOR I:=LENGTH (In_String) TO (Str_Length - 1) DO
    Disp_String (Blank, X+I, Y, Attrib);

  Cursor_Pos :=1;
  EndBigLoop := No;

 {**************************************************************************}

  WHILE (EndBigLoop = No) DO
    BEGIN

      GOTOXY (X + Cursor_Pos - 1, Y);
      In_Char := READKEY;

      IF (ORD (In_Char) = Carr_Return)
        THEN EndBigLoop := Yes

      ELSE IF (ORD (In_Char) = ESC_Code)
        THEN BEGIN
               EndBigLoop := Yes;
               Ctrl_Key   := ESC_Code;
             END

      ELSE IF (ORD (In_Char) = Tab_Code)
        THEN BEGIN
               EndBigLoop := Yes;
               Ctrl_Key   := Tab_Key;
             END

      ELSE IF (ORD (In_Char) = Back_Space)
        THEN BEGIN
               IF Cursor_Pos > 1
                  THEN BEGIN
                         Cursor_Pos := Cursor_Pos - 1;
                         DELETE (In_String, Cursor_Pos, 1);
                       END;
             END

      { -- Ctrl-A thru Ctrl-Z }
      ELSE IF (ORD (In_Char) >= 1) AND (ORD (In_Char) <= 26)
        THEN BEGIN
               EndBigLoop := Yes;
               Ctrl_Key   := ORD (In_Char);
             END

      {*****************************************************************}

      ELSE IF (In_Char >= Blank) AND
              (In_Char <= '~') AND
              (Cursor_Pos <= Str_Length)
        THEN BEGIN
               IF Ins_Mode = 'Y'
                 THEN BEGIN
                        In_String := COPY (In_String, 1, Cursor_Pos - 1) +
                                     In_Char +
                                     COPY (In_String, Cursor_Pos,
                                           Str_Length - Cursor_Pos);
                        Cursor_Pos := Cursor_Pos + 1;
                      END
                 ELSE BEGIN
                        In_String := COPY (In_String, 1, Cursor_Pos - 1) +
                                     In_Char +
                                     COPY (In_String, Cursor_Pos + 1,
                                           Str_Length - Cursor_Pos);
                        Cursor_Pos := Cursor_Pos + 1;
                      END;

             END

      {*****************************************************************}

      ELSE IF ORD (In_Char) = Null
        THEN BEGIN

               In_Char := READKEY;

               IF ORD (In_Char) = Lft_Arrow_Code
                 THEN BEGIN
                        IF Cursor_Pos > 1
                          THEN Cursor_Pos := Cursor_Pos - 1;
                      END

               ELSE IF ORD (In_Char) = Rgt_Arrow_Code
                 THEN BEGIN
                        IF Cursor_Pos <= LENGTH (In_String)
                          THEN Cursor_Pos := Cursor_Pos + 1;
                      END

               ELSE IF ORD (In_Char) = Ctrl_Lft_Code
                 THEN BEGIN
                        ProcessCtrlLeft;
                      END

               ELSE IF ORD (In_Char) = Ctrl_Rgt_Code
                 THEN BEGIN
                       ProcessCtrlRgt;
                      END

               ELSE IF ORD (In_Char) = Del_Code
                 THEN BEGIN
                         In_String := COPY (In_String, 1, Cursor_Pos - 1) +
                                      COPY (In_String, Cursor_Pos + 1,
                                                Length (In_String)
                                                - Cursor_Pos);
                      END

               ELSE IF ORD (In_Char) = Ins_Code
                 THEN BEGIN
                        IF Ins_Mode = 'Y'
                          THEN Ins_Mode := 'N'
                          ELSE Ins_Mode := 'Y';
                      END

               ELSE IF ORD (In_Char) = Home_Code
                 THEN BEGIN
                        Cursor_Pos := 1;
                      END

               ELSE IF ORD (In_Char) = End_Code
                 THEN BEGIN
                        Cursor_Pos := Length (In_String) + 1;
                      END

               ELSE IF ORD (In_Char) = Up_Code
                 THEN BEGIN
                        Ctrl_Key   := Up_Key;
                        EndBigLoop := Yes;
                      END

               ELSE IF ORD (In_Char) = Dn_Code
                 THEN BEGIN
                        Ctrl_Key   := Dn_Key;
                        EndBigLoop := Yes;
                      END

               ELSE IF ORD (In_Char) = PgUp_Code
                 THEN BEGIN
                        Ctrl_Key   := PgUp_Key;
                        EndBigLoop := Yes;
                      END

               ELSE IF ORD (In_Char) = PgDn_Code
                 THEN BEGIN
                        Ctrl_Key   := PgDn_Key;
                        EndBigLoop := Yes;
                      END

               ELSE IF ORD (In_Char) = Ctrl_PgUp_Code
                 THEN BEGIN
                        Ctrl_Key   := Ctrl_PgUp_Key;
                        EndBigLoop := Yes;
                      END

               ELSE IF ORD (In_Char) = Ctrl_PgDn_Code
                 THEN BEGIN
                        Ctrl_Key   := Ctrl_PgDn_Key;
                        EndBigLoop := Yes;
                      END


               ELSE
               { -- Function keys F1 thru F10. }
               IF ((ORD (In_Char) >= 59) AND (ORD (In_Char) <= 68))      OR

               { -- Function keys F11 & F12. }
                  (ORD (In_Char) = 133)                                  OR
                  (ORD (In_Char) = 134)                                  OR

               { -- Ctrl F11, F12  &  Alt F11, F12. }
                  ((ORD (In_Char) >= 137) AND (ORD (In_Char) <= 140))    OR

               { -- Ctrl F1 thru F10  &  Alt F1 thru F10. }
                  ((ORD (In_Char) >=  94) AND (ORD (In_Char) <= 113))    OR

               { -- Alt-A thru Alt-Z. }
                  (ORD (In_Char) >= 16) AND (ORD (In_Char) <=  25)       OR
                  (ORD (In_Char) >= 30) AND (ORD (In_Char) <=  38)       OR
                  (ORD (In_Char) >= 44) AND (ORD (In_Char) <=  50)

                 THEN BEGIN
                        Ctrl_Key   := ORD (In_Char) + 127;
                        EndBigLoop := Yes;
                      END



               ;

             END


      ELSE WRITE (CHR (Bell));

      {*******************************************************************}

      {display the entire string}
      TempString80 := In_String;
      FOR I:= LENGTH (In_String) TO (Str_Length - 1) DO
        TempString80 := TempString80 + Blank;

      Disp_String (TempString80, X, Y, Attrib);

    END;

END;

{**************************************************************************}

FUNCTION Valid_Date;

{---------------------------------------------------------------------------}
{ This checks a date to make sure it is valid.  For example, 6/31/1991 and  }
{   2/29/1700 are invalid dates.                                            }
{                                                                           }
{                                                                           }
{  INPUT:   MM, DD, YYYY (STRING)    = date to be evaluated                 }
{                                                                           }
{  Output:   Valid_Date  (STRING 1)  = is it valid? (Y/N)                   }
{                                                                           }
{---------------------------------------------------------------------------}

VAR
  IntMM       : INTEGER;
  IntDD       : INTEGER;
  IntYYYY     : INTEGER;
  ValError    : INTEGER;
  LeapYear    : STRING [ 1];
  DaysInMonth : INTEGER;

BEGIN
  Valid_Date := No;

  VAL (MM, IntMM, ValError);
  IF ValError <> 0
    THEN EXIT;

  VAL (DD, IntDD, ValError);
  IF ValError <> 0
    THEN EXIT;

  VAL (YYYY, IntYYYY, ValError);
  IF ValError <> 0
    THEN EXIT;


  { -- First check some reasonable boundaries}
  IF (IntMM < 1) OR (IntMM > 12)
    THEN EXIT;
  IF (IntDD < 1) OR (IntMM > 31)
    THEN EXIT;
  IF (IntYYYY < 400)  {I don't trust my other date routines when < year 100}
    THEN EXIT;        {since there is no year 1.}


  { -- Figure out if it's a leap year.}
  LeapYear := No;
  IF (IntYYYY MOD 4 = 0)
    THEN BEGIN
           IF (IntYYYY MOD 100 = 0) AND (IntYYYY MOD 400 <> 0)
              THEN LeapYear := No
              ELSE LeapYear := Yes;
         END;



  CASE IntMM OF
     1,3,5,7,8,10,12 : DaysInMonth := 31;
     4,6,9,11        : DaysInMonth := 30;
     2               : BEGIN
                         IF LeapYear = No
                             THEN DaysInMonth := 28
                             ELSE DaysInMonth := 29;
                       END;
  END;


  IF IntDD > DaysInMonth
    THEN EXIT;


  Valid_Date := Yes;

END;

{**************************************************************************}

PROCEDURE Keyin_Date;

{---------------------------------------------------------------------------}
{ This routine makes the user keyin a date in the form of 'mm/dd/yyyy'.     }
{                                                                           }
{                                                                           }
{  INPUT:    X,Y          (INTEGER)   = screen position                     }
{            Vid_Mode     (INTEGER)   = video attribute                     }
{            Ins_Mode     (STRING 1)  = video attribute                     }
{                                                                           }
{  Output:   MM, DD, YYYY (STRING)    = fields to be keyed into             }
{            Ctrl_Key     (INTEGER)   = Has a value if a 'Ctrl key' was hit }
{                                         such as PgUp or ESC               }
{                                                                           }
{---------------------------------------------------------------------------}

VAR
  EndLoopKeyin : STRING [ 1];
  ValError     : INTEGER;
  WhichKeyin   : INTEGER;
  KeyedMM      : STRING [ 2];
  KeyedDD      : STRING [ 2];
  KeyedYYYY    : STRING [ 4];
  TempInteger  : INTEGER;


BEGIN

  Disp_String ('/  /', X+2, Y, Vid_Mode);

  WhichKeyin := 1;

  KeyedMM    := MM;
  KeyedDD    := DD;
  KeyedYYYY  := YYYY;
  Disp_String (KeyedMM,   X,   Y, Vid_Mode);
  Disp_String (KeyedDD,   X+3, Y, Vid_Mode);
  Disp_String (KeyedYYYY, X+6, Y, Vid_Mode);



  EndLoopKeyin := No;
  WHILE (EndLoopKeyin = No) DO
    BEGIN

       CASE WhichKeyin OF
         1 : BEGIN
               KeyedMM := MM;
               Keyin_String (KeyedMM, X, Y, Vid_Mode, 2, Yes, Ins_Mode, Ctrl_Key);
             END;
         2 : BEGIN
               KeyedDD := DD;
               Keyin_String (KeyedDD, X+3, Y, Vid_Mode, 2, Yes, Ins_Mode, Ctrl_Key);
             END;
         3 : BEGIN
               KeyedYYYY := YYYY;
               Keyin_String (KeyedYYYY, X+6, Y, Vid_Mode, 4, Yes, Ins_Mode, Ctrl_Key);
             END;
       END;

       IF Ctrl_Key = ESC_Key
          THEN EXIT;

       WhichKeyin := WhichKeyin + 1;

       IF (Ctrl_Key = Up_Key) OR (Ctrl_Key = Dn_Key) OR (WhichKeyin = 4)
         THEN BEGIN
                IF (Valid_Date (KeyedMM, KeyedDD, KeyedYYYY) = Yes)
                  THEN BEGIN
                          EndLoopKeyin := Yes;

                          VAL (KeyedMM, TempInteger, ValError);
                          STR (TempInteger:2, MM);
                          VAL (KeyedDD, TempInteger, ValError);
                          STR (TempInteger:2, DD);
                          VAL (KeyedYYYY, TempInteger, ValError);
                          STR (TempInteger:4, YYYY);

                          Disp_String (MM,     X,   Y, Vid_Mode);
                          Disp_String (DD,     X+3, Y, Vid_Mode);
                          Disp_String (YYYY,   X+6, Y, Vid_Mode);
                       END
                  ELSE BEGIN
                          WhichKeyin := 1;
                          KeyedMM    := MM;
                          KeyedDD    := DD;
                          KeyedYYYY  := YYYY;
                          Disp_String (KeyedMM,   X,   Y, Vid_Mode);
                          Disp_String (KeyedDD,   X+3, Y, Vid_Mode);
                          Disp_String (KeyedYYYY, X+6, Y, Vid_Mode);
                       END;

              END;

    END;

END;

{***************************************************************************}

PROCEDURE NormToGreg;

{*****************************************************************************}
{*                                                                           *}
{*  Input : GMM         STRING  2                                            *}
{*          GDD         STRING  2                                            *}
{*          GYYYY       STRING  4                                            *}
{*                                                                           *}
{*  Output: GREGDATE    LONGINT                                              *}
{*                                                                           *}
{*                                                                           *}
{*  Description: This routine calculates the 'Gregorian Date' based on       *}
{*         the passed MM/DD/YYYY.  For example, July 4, 1776 gets converted  *}
{*         to '648491' which means it is the 648491th day since the year 1.  *}
{*                                                                           *}
{*         This may not be technically correct, since it doesn't take into   *}
{*         account the 11 days that were 'lost' when the switch was made     *}
{*         from the Julian to the Gregorian calendar.  Plus, the New Years   *}
{*         Day got switched from March 25 to January 1st, causing that year  *}
{*         to be about 9 months long. (That's why George Washington has two  *}
{*         different birthdays, falling 1 year 11 days apart.)  Also, this   *}
{*         routine is going to retroactively take away leap years from those *}
{*         first centuries.                                                  *}
{*                                                                           *}
{*         So the result is this routine is only accurate after 1582 if      *}
{*         you are Catholic, after 1752 if you lived in England or the       *}
{*         colonies, and after 1919 if you are Russian.  I think that's      *}
{*         good enough.                                                      *}
{*                                                                           *}
{*                                                                           *}
{*         Here's the rule:  Every 4th year is a leap year, except for       *}
{*         century years.  Every 4th century year is a leap year.  Thus      *}
{*         1700, 1800, 1900 are not leap years, but the year 2000 is.        *}
{*                                                                           *}
{*         This routine does NOT edit check your input.  If you tell it to   *}
{*         calculate the date for Feb 31 or Jan -68, it will do it as best   *}
{*         it can.                                                           *}
{*                                                                           *}
{*****************************************************************************}

CONST
  GJan             =    0;
  GFeb             =   31;
  GMar             =   59;
  GApr             =   90;
  GMay             =  120;
  GJun             =  151;
  GJul             =  181;
  GAug             =  212;
  GSep             =  243;
  GOct             =  273;
  GNov             =  304;
  GDec             =  334;


VAR
  ValError     : INTEGER;
  GMMInt       : LONGINT;
  GDDInt       : LONGINT;
  GYYYYInt     : LONGINT;

BEGIN

  VAL (GMM,   GMMInt,   ValError);
  VAL (GDD,   GDDInt,   ValError);
  VAL (GYYYY, GYYYYInt, ValError);


  { -- Calculate number of days so far this year.}
  GregDate := GDDInt;

  CASE GMMInt OF
     1 : GregDate := GregDate + GJan;
     2 : GregDate := GregDate + GFeb;
     3 : GregDate := GregDate + GMar;
     4 : GregDate := GregDate + GApr;
     5 : GregDate := GregDate + GMay;
     6 : GregDate := GregDate + GJun;
     7 : GregDate := GregDate + GJul;
     8 : GregDate := GregDate + GAug;
     9 : GregDate := GregDate + GSep;
    10 : GregDate := GregDate + GOct;
    11 : GregDate := GregDate + GNov;
    12 : GregDate := GregDate + GDec;
  END;

  {*******************************************************}

  { -- Add 1 if the current year is a leap year. }
  IF (GMMInt >= 3) AND (GYYYYInt MOD 4 = 0)
    THEN BEGIN
           IF (GYYYYInt MOD 100 = 0) AND (GYYYYInt MOD 400 = 0)
              THEN GregDate := GregDate + 1
           ELSE IF GYYYYInt MOD 100 <> 0
              THEN GregDate := GregDate + 1;
         END;

  {*******************************************************}

  { -- Add the number of days depending on what year it is.}
  GregDate := GregDate + ((GYYYYInt - 1) *   365);

  GregDate := GregDate + ((GYYYYInt - 1) DIV   4);

  GregDate := GregDate - ((GYYYYInt - 1) DIV 100);

  GregDate := GregDate + ((GYYYYInt - 1) DIV 400);

END;

{***************************************************************************}

PROCEDURE GregToNorm;

{*****************************************************************************}
{*                                                                           *}
{*  Input  : GREGDATE    LONGINT                                             *}
{*                                                                           *}
{*  Output : GMM         STRING  2                                           *}
{*           GDD         STRING  2                                           *}
{*           GYYYY       STRING  4                                           *}
{*                                                                           *}
{*                                                                           *}
{*                                                                           *}
{*  Description: This routine takes a 'Gregorian date' and calculates the    *}
{*       'normal date'.  See 'NormToGreg' for an explanation of the rules    *}
{*       for Gregorian dates.  For example, '727012' gets converted to June  *}
{*       21, 1991.                                                           *}
{*                                                                           *}
{*       This works by first figuring out which 400 year block it is in,     *}
{*       then which 100 year block within the 400 block, then which year     *}
{*       within the 100 year block, then the month, then the day.            *}
{*                                                                           *}
{*       At each step, GregDate gets whittled down.  For example, if         *}
{*       '727004' got passed in, it would determine that the 400 year block  *}
{*       starts at 1600, and so the year would get set to 1600 and GregDate  *}
{*       would have 584022 (for 12/31/1599) subtracted from it, leaving      *}
{*       142982.  We now know that we are 142982 days past 12/31/1599.  Then *}
{*       it would figure that we are in the 300th year of that 400 year      *}
{*       block, and would therefore add 300 to the year and subtract 109573  *}
{*       from GregDate, leaving 33409.  That means we are 33409 days past    *}
{*       1900.  This continues on until GregDate is reduced to the day of    *}
{*       the month.                                                          *}
{*                                                                           *}
{*       All the work variables are defined as LONGINT, so there are         *}
{*       numerous places where truncation occurs after a division.           *}
{*                                                                           *}
{*       This routine does NOT edit check your input.  If you tell it to     *}
{*       calculate the date for -68, it will do it as best it can.           *}
{*                                                                           *}
{*****************************************************************************}


VAR

  ValError      : INTEGER;
  LeapYear      : STRING [ 1];
  DaysMonth     : ARRAY [1..12] OF INTEGER;

  DaysFirstYear : INTEGER;

  MMInt         : LONGINT;
  DDInt         : LONGINT;
  YYYYInt       : LONGINT;


BEGIN

  { -- Figure out which 400 year block we are in. (ie 1600, 2000, 2400, etc)}

  YYYYInt := ((GregDate + 365) DIV 146097) * 400;

  GregDate := GregDate - (((GregDate + 365) DIV 146097) * 146097) + 366;


                {*********************************}

  { -- Within the 400 year block, figure out which 100 year block we are in.}
  {      (ie 1700, 1800, 1900, etc)}

  IF      (GregDate >=     1) AND (GregDate <  36526)
     THEN BEGIN
            YYYYInt  := YYYYInt +   0;
            GregDate := GregDate - 1     + 1;
          END

  ELSE IF (GregDate >= 36526) AND (GregDate <  73050)
     THEN BEGIN
            YYYYInt  := YYYYInt + 100;
            GregDate := GregDate - 36526 + 1;
          END

  ELSE IF (GregDate >= 73050) AND (GregDate < 109574)
     THEN BEGIN
            YYYYInt  := YYYYInt + 200;
            GregDate := GregDate - 73050 + 1;
          END

  ELSE IF (GregDate >= 109574)
     THEN BEGIN
            YYYYInt  := YYYYInt + 300;
            GregDate := GregDate - 109574 + 1;
          END

  ;

                {*********************************}

  { -- The first year of a century (eg 1900, 2000) may or may not be a leap }
  {     year.  After that are 3 years of 365, then 1 year of 366 days (1461 }
  {     days).  Let's go past that first year, then figure out how many     }
  {     there are by how many 1461 year blocks there are left in GregDate.  }

  IF (YYYYInt MOD 400 = 0)
     THEN DaysFirstYear := 366
     ELSE DaysFirstYear := 365;

  IF GregDate > DaysFirstYear
     THEN BEGIN
             GregDate := GregDate - DaysFirstYear;
             YYYYInt  := YYYYInt + 1;

             YYYYInt  := YYYYInt + (((GregDate-1) DIV 1461) * 4);
             GregDate := GregDate - (((GregDate-1) DIV 1461) * 1461);

             IF      (GregDate >=    1) AND (GregDate <=  365)
                THEN BEGIN
                       GregDate := GregDate -    0;
                       YYYYInt  := YYYYInt  +    0;
                     END
             ELSE IF (GregDate >= 366) AND (GregDate <= 730)
                THEN BEGIN
                       GregDate := GregDate - 365;
                       YYYYInt  := YYYYInt  +    1;
                     END
             ELSE IF (GregDate >= 731) AND (GregDate <= 1095)
                THEN BEGIN
                       GregDate := GregDate - 730;
                       YYYYInt  := YYYYInt  +    2;
                     END
             ELSE IF (GregDate >= 1096) AND (GregDate <= 1461)
                THEN BEGIN
                       GregDate := GregDate - 1095;
                       YYYYInt  := YYYYInt  +    3;
                     END
             ;

          END;

                {*********************************}

  { -- Now figure out the month. }

  IF (YYYYInt MOD 4 = 0) AND (YYYYInt MOD 100 <> 0)
    THEN LeapYear := Yes
  ELSE IF (YYYYInt MOD   4 = 0) AND
          (YYYYInt MOD 100 = 0) AND
          (YYYYInt MOD 400 = 0)
    THEN LeapYear := Yes
  ELSE LeapYear := No;


  DaysMonth [ 1] :=   31;
  IF LeapYear = Yes
     THEN DaysMonth [ 2] := 29
     ELSE DaysMonth [ 2] := 28;
  DaysMonth [ 3] :=   31;
  DaysMonth [ 4] :=   30;
  DaysMonth [ 5] :=   31;
  DaysMonth [ 6] :=   30;
  DaysMonth [ 7] :=   31;
  DaysMonth [ 8] :=   31;
  DaysMonth [ 9] :=   30;
  DaysMonth [10] :=   31;
  DaysMonth [11] :=   30;
  DaysMonth [12] :=   31;


  MMInt := 1;

  WHILE (GregDate > DaysMonth [MMInt]) DO
    BEGIN
      GregDate := GregDate - DaysMonth [MMInt];
      MMInt := MMInt + 1;
    END;

                {*********************************}


  DDInt := GregDate;


                {*********************************}


  STR (MMInt:2,   GMM);
  STR (DDInt:2,   GDD);
  STR (YYYYInt:4, GYYYY);

END;

{**************************************************************************}

PROCEDURE Convert_Upper;

   {*----------------------------------------------------------*}
   {* This converts a character string to all upper case.      *}
   {*----------------------------------------------------------*}

VAR
   Counter                   :INTEGER;
   TempChar                  :CHAR;
   TempString1               :STRING [  1];
   InputString               :STRING [255];
   OutputString              :STRING [255];

BEGIN
   Counter            := 0;
   OutputString       := '';
   InputString        := InOutString255;

   FOR Counter := 1 TO LENGTH (InputString) DO
      BEGIN
         TempString1  := COPY (InputString, Counter, 1);
         TempChar     := TempString1 [1];
         TempChar     := UPCASE (TempChar);
         OutputString := OutputString + TempChar;
      END;

   InOutString255     := OutputString;

END;

{**************************************************************************}

PROCEDURE Strip_Trail_Blanks;

   {*----------------------------------------------------------*}
   {* This strips any trailing blanks from a character string  *}
   {*----------------------------------------------------------*}

VAR
  Counter : INTEGER;

BEGIN

  Counter := LENGTH (InOutString255);

  WHILE (Counter > 0) AND (COPY (InOutString255, Counter, 1) = ' ') DO
    BEGIN
      Counter := Counter - 1;
    END;

  InOutString255 := COPY (InOutString255, 1, Counter);

END;

{***************************************************************************}

PROCEDURE Cursor_Off;

{---------------------------------------------------------------------------}
{   This routine simply turns off the display of the cursor.                }
{---------------------------------------------------------------------------}

VAR
  Regs : Registers;  {8086 register type}

BEGIN
  Regs.AX := $0100;
  Regs.CX := $2000;
  INTR ($10, Regs);
END;

{***************************************************************************}

PROCEDURE Cursor_On;

{---------------------------------------------------------------------------}
{   This routine simply turns on the display of the cursor.                 }
{---------------------------------------------------------------------------}

VAR
  Regs : Registers;

BEGIN
  Regs.AX := $0f00;  {Get current video mode service}
  INTR ($10, Regs);

  IF ((Regs.AX) AND ($0007)) = $0007
     THEN Regs.CX := $0C0D         {mono  mode}
     ELSE Regs.CX := $0607;        {color mode}

  Regs.AX := $0100;
  INTR ($10, Regs);

END;

{***************************************************************************}

PROCEDURE Keyin_Char;

{---------------------------------------------------------------------------}
{ This routine keys in a single character.  That includes special characters}
{   such as Alt-F3, Ctrl-V, F1, PgUp, BackSpace, etc.  Those special        }
{   characters for which Turbo Pascal returns a scan code of 00 then some   }
{   number, I just take that second number and add 127 to it.  Thus, the F5 }
{   key, which returns a scan code value of 0 and 63, becomes 190.          }
{                                                                           }
{  INPUT:    None                                                           }
{                                                                           }
{  OUTPUT:   MyKeyedChar - An integer value containing my scan code value   }
{                             of the key that was pressed.                  }
{                                                                           }
{  NOTES:                                                                   }
{                                                                           }
{                                                                           }
{                                                                           }
{---------------------------------------------------------------------------}

VAR
  In_Char : CHAR;


BEGIN

  In_Char := READKEY;

  IF ORD (In_Char) = 0    {Null Character - means another character follows}
    THEN BEGIN
           In_Char := READKEY;
           MyKeyedChar := ORD (In_Char);
           MyKeyedChar := MyKeyedChar + 127; {my values for these kind of keys}
         END
    ELSE BEGIN
           MyKeyedChar := ORD (In_Char);
         END;

END;

{***************************************************************************}


PROCEDURE Copy_File;

{---------------------------------------------------------------------------}
{ This routine copies an external file.                                     }
{                                                                           }
{  INPUT:    SourceName = Source      file name (to be copied from)         }
{            DestName   = Destination file name (to be copied to)           }
{                                                                           }
{  OUTPUT:   CopyOk     = Did copy work ok? (Y/N);                          }
{                                                                           }
{---------------------------------------------------------------------------}

CONST
  No   = 'N';
  Yes  = 'Y';

VAR
  BytesWrit      : INTEGER;     {number of bytes written}
  BytesRead      : INTEGER;     {number of bytes read}
  FileTime       : LONGINT;     {date & time of the file to be copied}

  SourceFile     : FILE;
  DestFile       : FILE;

  ReadBuffer     : ARRAY [1..MAXINT] OF BYTE;

  IOError        : INTEGER;      {used to hold IORESULT after IO operations}


  SourceAttr     : WORD;
  DestAttr       : WORD;

  SaveSourceAttr : WORD;
  SaveDestAttr   : WORD;


BEGIN

  ASSIGN (SourceFile, SourceName);
  ASSIGN (DestFile, DestName);

  {************************************}

  {Some tricky code here to see if we are copying from/to the same file.    }
  {First, get the attributes of both files.  Then change the attribute of   }
  {one file and see if the second file has also changed.  If so, both the   }
  {source and destination are the same file, so don't copy.                 }

  GETFATTR (SourceFile, SourceAttr);
  GETFATTR (DestFile,   DestAttr);

  SaveSourceAttr := SourceAttr;
  SaveDestAttr   := DestAttr;

  {change the read only bit of Attribute byte}
  IF SourceAttr MOD 2 = 0
    THEN SourceAttr := SourceAttr + 1
    ELSE SourceAttr := SourceAttr - 1;

  SETFATTR (SourceFile, SourceAttr);
  GETFATTR (DestFile, DestAttr);

  SETFATTR (SourceFile, SaveSourceAttr);    {restore file to original attrib}

  IF DestAttr <> SaveDestAttr
    THEN BEGIN
           CopyError := 5;        {arbitrarily setting error code to 5}
           EXIT;
         END;

  {************************************}


  FileMode := 0;      {all file opens now in read only mode}

  {$I-}
  RESET (SourceFile, 1);
  {$I+}
  IOError := IORESULT;

  FileMode := 2;      {all file opens now in read/write mode}

  IF IOError <> 0
     THEN BEGIN
            CopyError := IOError;
            EXIT;                 {exit this procedure}
          END;


  {$I-}
  REWRITE (DestFile, 1);
  {$I+}
  IOError := IORESULT;

  IF (IOError <> 0)
     THEN BEGIN
             CopyError := IOError;
             EXIT;            {exit this procedure}
          END;



  GETFTIME (SourceFile, FileTime);

  REPEAT
     BLOCKREAD  (SourceFile, ReadBuffer, MAXINT, BytesRead);
     BLOCKWRITE (DestFile, ReadBuffer, BytesRead, BytesWrit);
  UNTIL (BytesRead = 0) OR (BytesRead <> BytesWrit);

  IF BytesWrit = BytesRead
     THEN BEGIN
            CopyError := 0;
            SETFTIME (DestFile, FileTime);
          END
     ELSE BEGIN
            CopyError := 101;   {the disk is full}
          END;

  CLOSE (SourceFile);
  CLOSE (DestFile);

END;

{***************************************************************************}

PROCEDURE Get_New_Masks;

{----------------------------------------------------------------------------}
{  this routine evaluates the input string NewMask and tries to turn it into }
{     a legitimate DOS directory mask and file mask                          }
{                                                                            }
{                                                                            }
{ Input : NewMask - with many possible input forms, such as:                 }
{               'K:MAT.TXT' or '\GO\DATA'    or 'K:\USR\MAT\*.*' or 'FILE*.*'}
{                                                                            }
{ Output: NewDirMask   - directory portion of NewMask, such as:              }
{               'K:'        or 'K:\GO\DATA\' or 'K:\USR\MAT\'    or '\'      }
{                                                                            }
{         NewFileMask  - file portion of NewMask, such as:                   }
{               'MAT.TXT'   or '*.*'         or '*.*'            or 'FILE*.*'}
{                                                                            }
{         NewMask      - just NewDirMask & NewFileMask appended together     }
{                                                                            }
{----------------------------------------------------------------------------}

CONST
  No               = 'N';
  Yes              = 'Y';

VAR
  EndSlashLoop     : STRING [ 1];   {end loop flag when looking for last slash}
  LastSlash        : INTEGER;       {position of last slash in a string}
  TempString80     : STRING [80];   {work variable}

BEGIN
  IF COPY (NewMask, LENGTH (NewMask), 1) = ':'  {'K:' was input}
    THEN BEGIN
           NewDirMask  := NewMask;
           NewFileMask := '*.*';
         END

  ELSE IF POS ('..', NewMask) > 0               {the input was some '..' crap}
     THEN BEGIN
           NewDirMask  := NewMask;              {who knows what they'll get!}
           NewFileMask := '*.*';
          END

  ELSE IF POS ('\', NewMask) = 0                 {have an imbedded '\'?}
    THEN BEGIN                                   {no imbedded '\'}
           IF COPY (NewMask, 2, 1) = ':'
              THEN BEGIN                         {begins with 'K:'}
                     NewDirMask  := COPY (NewMask, 1, 2);
                     NewFileMask := COPY (NewMask, 3, LENGTH (NewMask) - 2);
                   END
              ELSE BEGIN                         {doesn't have 'K:'}
                     NewFileMask := NewMask;

                     {input string had very little, get current directory}
                     GETDIR (0, TempString80);

                     {if at the root level, GETDIR returns trailing slash}
                     IF COPY (TempString80, LENGTH (TempString80), 1) = '\'
                       THEN NewDirMask := COPY (TempString80, 1, 2)
                       ELSE NewDirMask := TempString80 + '\';

                   END;
         END

    ELSE BEGIN                                  {it has an imbedded '\'}
           IF POS ('.', NewMask) = 0            {does it have an imbedded '.'?}
             THEN BEGIN                         {doesn't have imbedded period}
                    {is there a trailing slash?}
                    IF COPY (NewMask, LENGTH (NewMask), 1) = '\'
                      THEN NewDirMask := NewMask
                      ELSE NewDirMask := NewMask + '\';

                    NewFileMask := '*.*';
                  END
             ELSE BEGIN                         {it has imbedded period}
                    {loop to find position of last backslash}
                    EndSlashLoop  := No;
                    LastSlash     := LENGTH (NewMask);
                    WHILE (EndSlashLoop = No) DO
                      BEGIN
                        IF COPY (NewMask, LastSlash, 1) = '\'
                          THEN EndSlashLoop := Yes
                          ELSE LastSlash    := LastSlash - 1;
                      END;

                    NewDirMask  := COPY (NewMask, 1, LastSlash);
                    NewFileMask := COPY (NewMask, LastSlash + 1,
                                           LENGTH (NewMask) - LastSlash);
                  END;
         END;

  Convert_Upper (NewDirMask);
  Convert_Upper (NewFileMask);

  NewMask := NewDirMask + NewFileMask;

END;

{***************************************************************************}

PROCEDURE Save_Screen;

BEGIN
  IF (MEM [0000:1040] AND 48) <> 48
    THEN ScreenAddress := $B800
    ELSE ScreenAddress := $B000;

  MARK (SomePtr);
  NEW (ScrnPtr);
  MOVE (MEM[ScreenAddress:0000], ScrnPtr^, 4000);
END;

{***************************************************************************}

PROCEDURE Restore_Screen;

BEGIN
  IF (MEM [0000:1040] AND 48) <> 48
    THEN ScreenAddress := $B800
    ELSE ScreenAddress := $B000;

  MOVE (SomePtr^, MEM [ScreenAddress:0000], 4000);
  RELEASE (SomePtr);
END;

{***************************************************************************}

PROCEDURE Draw_DBox;

VAR
  I : INTEGER;

BEGIN
  WINDOW (X1, Y1, X2, Y2);
  CLRSCR;
  WINDOW (1, 1, 80, 25);

  Disp_String ('', X1, Y1, VidMode);
  Disp_String ('', X2, Y1, VidMode);
  Disp_String ('', X1, Y2, VidMode);
  Disp_String ('', X2, Y2, VidMode);

  FOR I := 1 TO (X2-X1-1) DO
    BEGIN
      Disp_String ('', X1+I, Y1, VidMode);
      Disp_String ('', X1+I, Y2, VidMode);
    END;

  FOR I := 1 TO (Y2-Y1-1) DO
    BEGIN
      Disp_String ('', X1, Y1+I, VidMode);
      Disp_String ('', X2, Y1+I, VidMode);
    END;

END;

{***************************************************************************}




END.

{***************************************************************************}
{***                       End of MISCSTUF.PAS                           ***}
{***************************************************************************}
