Unit QM; {QuickMount}
Interface
Uses DOS,CRT,TenTools;

Procedure QuickMount(ServID : S12);

Implementation

Procedure QuickMount(ServID : S12);

TYPE
   ScreenPage = Array[1..4000] of Char;
   ASCII = Set of Char;
   DCharType= (UD,UR,UL,DR,DL,URL,DRL,URD,ULD,RL,URDL);
   Charset = 'A'..'Z';
   RDRTable = Array[1..200] of Char;
   ColorSelections=(Normal,Inverse,Warning);
CONST
   DChar : Array[UD..URDL] of Char= ('','','','','','','','','','','');
   LocalColor =Blue;
VAR
   ColorScreen : ScreenPage absolute $B800:$0000;
   CurrentColors : ColorSelections;
   ScreenSave,HelpSave : ScreenPage;
   First,MainScreen,PreviousMounts,LoggedIn : Boolean;
   DeviceList : DeviceArray;
   UseList : Array[0..24] of set of Char;
   MaxDevice,I,J : Integer;
   GX1,GY1,GX2,GY2,GWidth,PX1,PY1,PMaxRow,PXOfs,Cursor,TCursor : Integer;
   HoldY : Integer;
   UseLetter,Inchar,CChar,GAR : Char;
   RetCode : Word;
   LocalTable : DriveArray;
   LocalPrint : PrintArray;
   CVAR : CharSet;
   LChar : Char;
Procedure ResetColors;
Begin
   Case CurrentColors of
   Normal : Begin
               TextColor(Yellow);
               TextBackground(Cyan);
            end;
   Inverse : Begin
                TextColor(Red);
                TextBackground(White);
             end;
   Warning : Begin
                TextColor(White);
                TextBackground(Red);
             end;
   end;
End;

Function Trim(InString : String) : String;
Begin
   While Pos(' ',InString)>0 do Delete(Instring,Pos(' ',InString),1);
   While Pos(#0,Instring)>0 do Delete(Instring,Pos(#0,Instring),1);
   Trim:=InString;
End;

Procedure Beep;
VAR
   I,J : Integer;
Begin
   For J:=1 to 3 do for I:=5 to 10 do
    begin
       Sound(I*J*100);
       Delay(3);
       NoSound;
    end;
   For J:=3 downto 1 do for I:=10 downto 5 do
    begin
       Sound(I*J*100);
       Delay(3);
       NoSound;
    end;
   Sound(400);
   Delay(50);
   NoSound;
End;


Procedure Outline(X1,Y1,X2,Y2 : Integer;BridgePt : Integer);
VAR
   I : Integer;
Begin
   Window(1,1,80,25);
   GotoXY(X1,Y1);
   Write(DChar[DR]);
   For I:=1 to X2-X1-1 do Write(DChar[RL]);
   Write(DChar[DL]);
   For I:= Y1+1 to Y2-1 do
    begin
       GotoXY(X1,I);
       Write(DChar[UD]);
       GotoXY(X2,I);
       Write(DChar[UD]);
    end;
   GotoXY(X1,Y2);
   Write(DChar[UR]);
   For I:=1 to X2-X1-1 do Write(DChar[RL]);
   Write(DChar[UL]);
   Window(X1+1,Y1+1,X2-1,Y2-1);
   ClrScr;
   Window(1,1,80,25);
   If BridgePt>0
   then
    begin
       GotoXY(X1,Y1+BridgePt);
       Write(DChar[URD]);
       For I:=1 to X2-X1-1 do Write(DChar[RL]);
       Write(DChar[ULD]);
    End;
   Window(X1+1,Y1+1,X2-1,Y2-1);
   If MainScreen
   then
    begin
       GX1:=X1+1;
       GY1:=Y1+1;
       GX2:=X2-1;
       GY2:=Y2-1;
       GWidth:=GX2-GX1+1;
    end;
End;

Procedure CenteredWindow(XSize,YSize : Integer);
{ Creates a Centered window box on the screen with the width XSize and the
  height YSize. }
VAR
   X1,Y1 : Integer;
Begin
   X1:=(80-XSize)div 2;
   Y1:=(25-YSize)div 2;
   Outline(X1,Y1,X1+XSize,Y1+YSize,0);
End;


Procedure CenterWrite(S : String; Line : Integer);
Begin
   GotoXY((GWidth-Length(S))div 2+1,Line);
   Write(S);
End;

Procedure GetLogList(VAR LoginList : LogArray; VAR LogCount : Integer);
VAR
   I,J : Integer;
   L : Word;
Begin
   If LogList(LoginList,I)=0
   then LogCount:=I
   else LogCount:=0;
End;


Procedure Devices(ServerName : S12;VAR DList : DeviceArray;VAR DeviceCount : Integer);
VAR
   SaveUser : S8;
   SavePW : PW8;
   LogList : LogArray;
   I,D,E : Integer;
   RetCode : Word;
   MaxNodes : Integer;
Begin
   ServerName:=Upcase12(ServerName);
   GetLogList(LogList,MaxNodes);
   SaveUser:=ConfigTable^.CT_LName;
   LoggedIn:=False;
   I:=0;
   If (MaxNodes>0) then
    begin
       while not (Loggedin or (I=MaxNodes)) do
       begin
          LoggedIN:=(LogList[I]=ServerName);
          If not Loggedin then Inc(I);
       end;
    end
   else LoggedIn:=False;
   If Not Loggedin
   then
    begin
       SetUsername('TESTING0');
       RetCode:=Login(ServerName,'TESTPW');
    end
   else RetCode:=0;
   If (RetCode=0)
   then
    begin
       RetCode:=GetDevices(ServerName,DList,D);
       DeviceCount:=D;
       If not LoggedIN
       then
        begin
           RetCode:=Logoff(Servername);
           SetUserName(SaveUser);
        end;
    end
   else Writeln('Can''t access ',Servername,' : ',RetCode);
End;


{ The following "Pointer Procedures" will point at an item arranges in
  rows by columns, indexed from 1 up by positive integer. }

Procedure SetPointer(X1,Y1,XOfs,MaxRow : Integer);
Begin
   PX1:=X1;
   PY1:=Y1;
   PMaxRow:=MaxRow;
   PXOfs:=XOfs;
End;

Procedure PointAt(Index : Integer);
VAR
 XPos,YPos : Integer;
Begin
   XPos:=(Index-1) div PMaxRow;
   XPos:=PX1+(XPos * PXOfs);
   YPos:=(Index-1)mod PMaxRow+1+PY1;
   GotoXY(XPos,YPos);
end;

Procedure DisplayList;
VAR
   I : Integer;
   UseLetter : Char;
Begin
   For I:=1 to MaxDevice do
    begin
       PointAt(I);
       TextColor(LocalColor);
       If (Uselist[I-1]<>[])
       then
        begin
           First:=True;
           For UseLetter:='1' to 'Z' do if not (UseLetter in ['4'..'@'])
           then
            begin
               If (UseLetter in UseList[I-1])
               then
                begin
                   If not First then Write(',');
                   Write(UseLetter);
                   First:=False;
                end;
            end;
           Write('=');
        end;
       ResetColors;
       Write(DeviceList[I-1]);
       ClrEol;
    end;
End;


Procedure NVideo;
Begin
   CurrentColors:=Normal;
End;

Procedure IVideo;
Begin
   CurrentColors:=Inverse;
End;

Procedure WVideo;
Begin
   CurrentColors:=Warning;
end;


Procedure AlreadyAttached;
VAR
   TestID : S12;
Begin
   CenterWrite(Inchar+' is already attached!',1);
   CenterWrite(Inchar+'='+LocalTable[Inchar].RPath+','+LocalTable[Inchar].ServerID,3);
   CenterWrite('< to Change, [ESC] to abort',5);
    Repeat
       CChar:=Upcase(Readkey);
       If (CChar=#0) then Gar:=Readkey;
    Until (CChar in [#13,#27]);
   If (CChar=#13)
   then
    begin  {Unmount/UnUse first}
       If (Length(LocalTable[Inchar].RPath)>1)
        then RetCode:=UnUse(Inchar)
       else RetCode:=Unmount(Inchar);
       TestID:=Trim(LocalTable[Inchar].ServerID);
       If (TestID=ServID)
       then
        begin
           J:=0;
           While (Not(Inchar in UseList[J]) or (J=MaxDevice)) do Inc(J);
{}           If (Inchar in UseList[J]) then UseList[J]:=Uselist[J]-[Inchar];
        end;
       LocalTable[Inchar].RPath:='';
       LocalTable[Inchar].ServerID:='';
       RetCode:=1;
    end
   else RetCode:=0;
End;

Procedure DriveUnavailable;
Begin
   CenterWrite(Inchar+' is not available',1);
   CenterWrite('in the local drive list.',3);
   CenterWrite('Press any key to Continue',5);
   CChar:=Upcase(Readkey);
   If (CChar=#0) then Gar:=Readkey;
   RetCode:=0;
End;

Function Listed(DriveChar : Char): Boolean;
Begin
   Listed:=Trim(LocalTable[DriveChar].ServerID)<>'';
End;


Begin {QMount}
   NVideo;
   HoldY:=WhereY;
   For I:=0 to 24 do UseList[I]:=[];
   For I:=1 to Length(ServID) do ServID[I]:=Upcase(ServID[I]);
   Devices(ServID,DeviceList,MaxDevice);
   J:=26;
   PreviousMounts:=((Mountlist(LocalTable,LocalPrint,J)=0)and (J>0));
   If MaxDevice>0 then for I:=0 to MaxDevice-1 do
    begin
       DeviceList[I]:=Trim(DeviceList[I]);
       if DeviceList[I][1]='_' then DeviceList[I]:=Copy(DeviceList[I],2,Length(DeviceList[I])-1);
       If PreviousMounts
       then
        begin
           CVAR:='A';
           While not ((CVAR=Char(64+J)){or(CVAR in UseList[I])}) do
            begin
               Inc(CVAR);
               If ((LocalTable[CVar].RPath=DeviceList[I])and(Trim(ServID)=Trim(LocalTable[CVAR].ServerID)))
               then UseList[I]:=UseList[I]+[CVAR];
            end;
           If (COPY(DeviceList[I],1,3)='LPT')
           then
            begin
               If (Trim(ServID)=Trim(LocalPrint[DeviceList[I][4]].ServerID))
               then UseList[I]:=UseList[I]+[DeviceList[I][4]];
               For LChar:='1' to '3' do
               if ((LocalPrint[LChar].RPath=DeviceList[I])and(Trim(ServID)=Trim(LocalPrint[LChar].ServerID)))
               then UseList[I]:=UseList[I]+[LChar];
            end;
        end;
    end;
   If not Loggedin
   then
    begin
       Writeln('Not Logged to ',ServID);
       For I:=1 to MaxDevice do
        begin
           Writeln(DeviceList[I-1]);
        end;
    end
   else
    begin
       MainScreen:=True;
       Move(ColorScreen,ScreenSave,4000);
       TextColor(Yellow);
       TextBackground(Cyan);
       CenteredWindow(31,23);
       MainScreen:=False;
       CenterWrite(ServID,1);
       CenterWrite('Devices ',2);
       GotoXY(1,3);
       For I:=1 to Gwidth do Write('');
       SetPointer(3,4,15,19);
       DisplayList;
       Cursor:=1;
       Inchar:=#0;
       Repeat
          TCursor:=Cursor;
          PointAt(Cursor);
          IVideo;
          ResetColors;
          TextColor(LocalColor);
          If (Uselist[Cursor-1]<>[])
          then
           begin
              First:=True;
              For UseLetter:='1' to 'Z' do if not (UseLetter in ['4'..'@'])
              then
               begin
                  If (UseLetter in UseList[Cursor-1])
                  then
                   begin
                      If not First then Write(',');
                      Write(UseLetter);
                      First:=False;
                   end;
               end;
              Write('=');
           end;
          ResetColors;
          Write(DeviceList[Cursor-1]);
          Inchar:=Upcase(Readkey);
          If Inchar=#0
          then
           begin
              Inchar:=Readkey;
              Case Inchar of
{Up}          'H' : If TCursor>1 then Dec(TCursor) else TCursor:=MaxDevice;
{Down}        'P' : If TCursor<MaxDevice then Inc(TCursor) else TCursor:=1;
{Left}        'K' : If TCursor-PMaxRow>0 then Dec(TCursor,PMaxRow);
{Right}       'M' : If TCursor+PMaxRow<=MaxDevice then Inc(TCursor,PMaxRow);
{DELETE}      'S' : If Uselist[Cursor-1]<>[]
                    then
                     begin
                        For UseLetter:='1' to 'Z' do if (UseLetter in UseList[Cursor-1])
                        then
                         begin
                            If Not ((Copy(DeviceList[Cursor-1],1,3)='LPT')or(Length(DeviceList[Cursor-1])=1))
                            then RetCode:=UnUse(UseLetter)
                            else RetCode:=UnMount(UseLetter);
                            If (UseLetter in ['A'..'Z'])
                            then
                             begin
                                LocalTable[UseLetter].ServerID:='';
                                LocalTable[UseLetter].RPath:='';
                             end
                            else
                             begin
                                LocalPrint[UseLetter].ServerID:='';
                                LocalPrint[UseLetter].RPath:='';
                             end;
                            UseList[Cursor-1]:=UseList[Cursor-1]-[UseLetter];
                         end;
                        NVideo;
                        ResetColors;
                        DisplayList;
                        RetCode:=0;
                     end;
              end;
             Inchar:=#0;
           end
          else
           begin
              Case Inchar of
              'A'..'Z' : Begin
                            If Not ((Copy(DeviceList[Cursor-1],1,3)='LPT')or(Length(DeviceList[Cursor-1])=1))
                            then
                             Repeat
                                RetCode:=NetUse(ServID,Inchar,DeviceList[Cursor-1],'');
                                If (RetCode=0)
                                then
                                 begin
                                    UseList[Cursor-1]:=UseList[Cursor-1]+[Inchar];
                                    LocalTable[Inchar].RPath:=DeviceList[Cursor-1];
                                    LocalTable[Inchar].ServerID:=ServID;
                                 end
                                else
                                 begin
                                    Beep;
                                    Move(ColorScreen,HelpSave,4000);
                                    TextBackground(Red);
                                    TextColor(White);
                                    CenteredWindow(31,7);
                                    If (RetCode=85) then AlreadyAttached
                                    else DriveUnavailable;
                                    NVideo;
                                    ResetColors;
                                    Move(HelpSave,ColorScreen,4000);
                                    Window(GX1,GY1,GX2,GY2);
                                    DisplayList;
                                    GotoXY(1,1);
                                 end;
                             Until (RetCode=0)
                            else if (Length(DeviceList[Cursor-1])=1)
                            then
                             Repeat
                                If Listed(Inchar) then RetCode:=85
                                else RetCode:=Mount(ServID,Inchar,DeviceList[Cursor-1][1]);
                                If (RetCode=0)
                                then
                                 begin
                                    UseList[Cursor-1]:=UseList[Cursor-1]+[Inchar];
                                    LocalTable[Inchar].RPath:=DeviceList[Cursor-1];
                                    LocalTable[Inchar].ServerID:=ServID;
                                 end
                                else
                                 begin
                                    Beep;
                                    Move(ColorScreen,HelpSave,4000);
                                    TextBackground(Red);
                                    TextColor(White);
                                    CenteredWindow(31,7);
                                    If (RetCode=85) then AlreadyAttached
                                    else DriveUnavailable;
                                    NVideo;
                                    ResetColors;
                                    Move(HelpSave,ColorScreen,4000);
                                    Window(GX1,GY1,GX2,GY2);
                                    DisplayList;
                                 end;
                             Until (RetCode=0);
                            If TCursor<MaxDevice then Inc(TCursor);
                         End;
              '1'..'3' : If (Copy(DeviceList[Cursor-1],1,3)='LPT')
                         then
                          begin
                             RetCode:=Mount(ServID,Inchar,DeviceList[Cursor-1][4]);
                             If (RetCode=0)
                             then
                              begin
                                 UseList[Cursor-1]:=UseList[Cursor-1]+[Inchar];
                                 LocalPrint[Inchar].RPath:=DeviceList[Cursor-1];
                                 LocalPrint[Inchar].ServerID:=ServID;
                              end
                             else Beep;
                            If TCursor<MaxDevice then Inc(TCursor);
                          end;
                #27 : Begin
                         sound(1000);
                         Delay(15);
                         Nosound;
                      end;
               else Beep;
              end;
           end;
          PointAt(Cursor);
          NVideo;
          ResetColors;
          TextColor(LocalColor);
          If (Uselist[Cursor-1]<>[])
          then
           begin
              First:=True;
              For UseLetter:='1' to 'Z' do
               begin
                  If (UseLetter in UseList[Cursor-1])
                  then
                   begin
                      If not First then Write(',');
                      Write(UseLetter);
                      First:=False;
                   end;
               end;
              Write('=');
           end;
          ResetColors;
          Write(DeviceList[Cursor-1]);
          Cursor:=TCursor;
       Until (Inchar=#27);
       Move(ScreenSave,ColorScreen,4000);
       Window(1,1,80,25);
   end;
  GotoXY(1,HoldY);
End;

End.