library Printer;
{
This DLL will stream a file to the OV form and print
the form for each increment of form lines.
}
uses wintypes, winprocs, strings;

type

  { These are the two callback functions for OV }

  ExecuteString = function(Exe_String, Other_String: PChar; W1, W2:word): PChar;
  Put_Value = function(Field, Value: Pchar): PChar;


{
------------------------------------------------------------------
StoreForms
----------
ObjectVision Registration:


@REGISTER("@StoreForms", "InwCCCI", "LinkName, FileName,
            Field, Lines", "PRINTER.DLL", "STOREFORMS", 1)

Example Call:

@StoreForms("link", "c:\autoexec.bat", "field1", 3)
Parameter 1 - Link Name
Parameter 2 - File Name
Parameter 3 - Field to load the text into
Parameter 4 - Number of lines to read in per form



StoreForms -
  Stores a text file into the link database for each increment of
  the last parameter.  So using this call StoreForms will
  read in 3 lines of the textfile "c:\autoexec.bat" and then
  call store("link") in "ObjectVision". Then it will loop through
  the same sequence until it runs into the end of the text file.

------------------------------------------------------------------
PrintForms
----------
ObjectVision Registration:

@REGISTER("@PrintForms", "InwCCCI", "FormName, FileName,
           Field, Lines", "PRINTER.DLL", "PRINTFORMS", 1)

Example Call:

@PrintForms("CallPrntForm", "c:\autoexec.bat", "Text",18)
Parameter 1 - Form Name
Parameter 2 - File Name to Load and Print
Parameter 3 - Field to load the text into
Parameter 4 - Number of lines to read in per form

PrintForms -
  Reads a specified number of lines of a text file into a ObjectVision
  field and then calls the ObjectVision PrintForm routine.  Using this
  example call, the call will read 18 lines into the field text and then
  executes a PrintForm("CallPrntForm") for each 18 lines it reaches the
  end of the text file.


------------------------------------------------------------------

}

function StoreForms(Exec_Proc:ExecuteString; PutValue: Put_Value; LinkName,
                    FileName, FieldName: PChar; Lines: integer): Integer; export;
var
  f: File of Char;
  LineCount: Integer;
  BufCount: Integer;
  TempString, TempString1 : array[0..30] of char;
  Buffer: array[0..1024] of char;
  ch: Char;

begin
  {$F-}
  assign(f, FileName);
  reset(f);
  {$F+}
  if ioresult<>0 then
  begin
    MessageBox(GetFocus, FileName, 'File Not Found', MB_Ok);
    exit;
  end;
  LineCount := 0;
  BufCount := 0;
  repeat
    while (LineCount < Lines) and (BufCount < 1024) do
    begin
      if not(eof(f)) then
      begin
        read(f, Buffer[BufCount]);
        if Buffer[BufCount] = #13 then inc(LineCount);
        inc(BufCount);
      end
      else
        linecount := lines;
    end;
    if buffer[bufcount-1] = #13 then
      read(f, ch);
    LineCount := 0;
    Buffer[BufCount] := #0;

    strcopy(TempString, '@Store("');
    strcat(TempString, LinkName);
    strcat(TempString, '")');

    strcopy(TempString1, '@Clear("');
    strcat(TempString1, LinkName);
    strcat(TempString1, '")');

    Exec_Proc(tempstring1, '', 0, 0);
    PutValue(FieldName, Buffer);
    Exec_Proc(TempString,'', 0, 0);
    BufCount := 0;
  until eof(f);
  close(f);
end;

function PrintForms(Exec_Proc:ExecuteString; PutValue: Put_Value; FormName,
                    FileName, FieldName: PChar; Lines: integer): Integer; export;
var
  f: File of Char;
  LineCount: Integer;
  BufCount: Integer;
  TempString : array[0..30] of char;
  Buffer: array[0..1024] of char;
  ch: Char;
begin
  {$F-}
  assign(f, FileName);
  reset(f);
  {$F+}
  if ioresult<>0 then
  begin
    MessageBox(GetFocus, FileName, 'File Not Found', MB_Ok);
    exit;
  end;
  LineCount := 0;
  BufCount := 0;
  repeat
    while (LineCount < Lines) and (BufCount < 1024) do
    begin
      if not(eof(f)) then
      begin
        read(f, Buffer[BufCount]);
        if Buffer[BufCount] = #13 then inc(LineCount);
        inc(BufCount);
      end
      else
        linecount := lines;
    end;
    if buffer[bufcount-1] = #13 then
      read(f, ch);
    LineCount := 0;
    Buffer[BufCount] := #0;
    PutValue(FieldName, ' ');
    PutValue(FieldName, Buffer);
    strcopy(TempString, '@PrintForm("');
    strcat(TempString, FormName);
    strcat(TempString, '")');
    Exec_Proc(TempString,'', 0, 0);
    BufCount := 0;
  until eof(f);
  close(f);
end;

exports StoreForms index 1;
exports PrintForms index 2;
begin
end.