*
* FUNCTION vRadio.PRG
* Author Chris Miller - Perpetual Data Systems
* Date 10/19/94
*
* The function will allow multiple radio button sets to function as
* one button set. I wrote this UDF for a muti-screen set that required
* a large number of radio buttons in a limited amount of space. There
* where too many selections required to fit on the screen (horizontally
* or vertically) in one button set.
*
*
* Assumptions	-	The fields in the table for the radio button sets
*					were defined in the following manner:
*								rb_set1 N 1
*								rb_set2 N 1
*								rb_set3 N 1
*								etc..
*					This was done to allow the function to check which
*					radio button set is currently selected.
*
*
*
* Parameters:
*
*	m.pnButtVal -	This is the value of the radio button selected.
*
*	m.pcVarName	-	This is the variable name. i.e. VARREAD()
*
*	m.pcField	-	This is a character string of the field name.
*					used with m.lnInc to check which button set is
*					currently selected.
*
*	m.pnNumRows	-	This is the number of radio button sets to be included
*					in the function.

PARAMETERS m.pnButtVal, m.pcVarName, m.pcField, m.pnNumRows

* Variables
*
*  m.lnInc		-	Used as incremental in FOR..ENDFOR loop. Also used
*					with m.pcField to check which button set is currently
*					selected.
*
*  m.lcRowVal	-	Character string of the field name and button set number.
*					checked against m.pcVarName to assertain whether the
*					the FOR...ENDFOR loop is checking the button set currently
*					selected by the user.
*



PRIVATE ;
	m.lnInc, ;
	m.lcRowVal, ;
	m.pnButtVal, ;
	m.pcVarName, ;
	m.pcfield, ;
	m.pnNumRows


* Has any radio button been selected.
IF NOT EMPTY(m.pnButtVal)

	* Start check of table field for multiple button sets.
	FOR m.lnInc = 1 TO m.pnNumRows
	
		* Store "fieldname" and button set number to character string.
		* to get table field names.
		m.lcRowVal = m.pcField + ALLTRIM(STR(m.lnInc))

		* Check to see if loop is on the last button set selected.
		IF m.lcRowVal <> m.pcVarName
			
			* If not, Turn button off
			REPLACE &lcRowVal WITH 0

		ELSE
			
			* If so, store value of the button selected.
			REPLACE &pcVarName WITH m.pnButtVal

		ENDIF

	ENDFOR

	* Refresh current window.
	SHOW GETS WINDOW (WONTOP())

ENDIF

RETURN



