***************************************************************************
*
* Procedure file: SPRTOSCX.PRG
*         System: SPRtoSCX
*        Version: 2.0
*         Author: Ken R. Levy
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* SPRTOSCX - Update .SCX database from .SPR file.
*
* Description:
* This program is a utility that updates an .SCX database from a modified
* .SPR or .PRG file that was automatically generated using GENSCRN.
* Only the WHEN, VALID, ERROR, MESSAGE, ACTIVATE, and DEACTIVATE expression
* or procedure GET and READ clause snippets are updated in the .SCX database.
* Any other changes made to the .SPR file are ignored.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
FUNCTION sprtoscx
PARAMETERS sprfile,autogenscx,scxfile
PRIVATE sprfile,autogenscx,scxfile,errfile,updcount,pjxfile
PRIVATE i,find_str,at_line,at_pos,at_pos2,min_pos,max_pos
PRIVATE memline,memline2,clauses,snptcode,snptcode2
PRIVATE fieldname,fieldeval,snptname,snpttype,lastselect
PRIVATE dos_pos,win_pos,mac_pos,unix_pos,cr_lf,null
PRIVATE cplatform_,winontop,c_genscrnx,c_project

_FOX25=(SUBSTR(VERSION(),AT('2.',VERSION()),3)>='2.5')
_FOX25REV=IIF(_FOX25,SUBSTR(VERSION(),AT('2.',VERSION())+3,1),'')
IF .NOT._FOX25
  _DOS=.T.
  _WINDOWS=.F.
  _MAC=.F.
  _UNIX=.F.
ENDIF
DO CASE
  CASE _WINDOWS
    m.cplatform_='WINDOWS'
  CASE _MAC
    m.cplatform_='MAC'
  CASE _UNIX
    m.cplatform_='UNIX'
  OTHERWISE
    m.cplatform_='DOS'
ENDCASE
m.cplatform_=PADR(m.cplatform_,8)
m.c_genscrnx='*--GENSCRNX'
m.c_project='*--Project'
m.updcount=0
m.pjxfile=''
IF TYPE('m.sprfile')=='L'.OR.EMPTY(m.sprfile)
  m.winontop=UPPER(WONTOP())
  IF RIGHT(m.winontop,4)=='.SPR'.OR.RIGHT(m.winontop,4)=='.PRG'
    IF TYPE('m.sprfile')=='L'
      m.autogenscx=m.sprfile
    ELSE
      m.autogenscx=.T.
    ENDIF
    CLEAR TYPEAHEAD
    KEYBOARD "{Ctrl+W}{Ctrl+F2}="+PROGRAM()+"('"+m.winontop+;
             IIF(m.autogenscx,"',.T.","'")+"){ENTER}" PLAIN
    RETURN m.updcount
  ENDIF
  RETURN m.updcount
ENDIF
m.errfile=UPPER(trimext(m.sprfile))+'.ERR'
IF TYPE('m.scxfile')#'C'
  m.scxfile=trimext(m.sprfile)
ENDIF
IF .NOT.'.'$m.sprfile
  m.sprfile=m.sprfile+'.SPR'
ENDIF
IF .NOT.FILE(m.sprfile)
  =dispmsg("File '"+m.sprfile+"' not found")
  RETURN m.updcount
ENDIF
IF .NOT.'.'$m.scxfile
  m.scxfile=m.scxfile+'.SCX'
ENDIF
m.scxfile=UPPER(m.scxfile)
IF .NOT.FILE(m.scxfile)
  =dispmsg("File '"+m.scxfile+"' not found")
  RETURN m.updcount
ENDIF
SET ESCAPE ON
CLEAR WINDOWS
DO WHILE WEXIST(m.scxfile).OR.WEXIST(m.errfile)
  RELEASE WINDOW (m.scxfile)
ENDDO
ACTIVATE SCREEN
=dispmsg('Scanning File: '+m.sprfile+' ...')
m.cr_lf=CHR(13)+CHR(10)
m.null=CHR(0)
m.lastselect=SELECT()
m.lastmemow=SET('MEMOWIDTH')
SET MEMOWIDTH TO 254
IF USED('SPRDATA')
  SELECT SPRDATA
  USE
ENDIF
CREATE CURSOR SPRDATA (SPR M, SCNLAYOUT M)
INSERT BLANK
APPEND MEMO SPR FROM (m.sprfile) OVERWRITE
IF .NOT.'This program was automatically generated by GENSCRN.'$SPR
  DO cleanup
  =dispmsg("File '"+m.sprfile+"' was not automatically generated by GENSCRN")
  RETURN m.updcount
ENDIF
m.dos_pos=ATC('/MS-DOS Screen Layout',SPR)
m.win_pos=ATC('/WINDOWS Screen Layout',SPR)
m.mac_pos=ATC('/MAC Screen Layout',SPR)
m.unix_pos=ATC('/UNIX Screen Layout',SPR)
DO CASE
  CASE _DOS
    m.min_pos=MAX(m.dos_pos,1)
  CASE _WINDOWS
    m.min_pos=MAX(m.win_pos,1)
  CASE _MAC
    m.min_pos=MAX(m.mac_pos,1)
  OTHERWISE
    m.min_pos=MAX(m.unix_pos,1)
ENDCASE
m.max_pos=LEN(SPR)+1
m.dos_pos=IIF(m.dos_pos>0,m.dos_pos,m.max_pos)
m.win_pos=IIF(m.win_pos>0,m.win_pos,m.max_pos)
m.mac_pos=IIF(m.mac_pos>0,m.mac_pos,m.max_pos)
m.unix_pos=IIF(m.unix_pos>0,m.unix_pos,m.max_pos)
IF BETWEEN(m.dos_pos,m.min_pos+1,m.max_pos)
  m.max_pos=m.dos_pos
ENDIF
IF BETWEEN(m.win_pos,m.min_pos+1,m.max_pos)
  m.max_pos=m.win_pos
ENDIF
IF BETWEEN(m.mac_pos,m.min_pos+1,m.max_pos)
  m.max_pos=m.mac_pos
ENDIF
IF BETWEEN(m.unix_pos,m.min_pos+1,m.max_pos)
  m.max_pos=m.unix_pos
ENDIF
REPLACE SCNLAYOUT WITH SUBSTR(SPR,m.min_pos,m.max_pos-m.min_pos+1)
IF USED('SCXBASE')
  SELECT SCXBASE
  USE
ELSE
  SELECT 0
ENDIF
USE (m.scxfile) ALIAS SCXBASE AGAIN
LOCATE
IF EOF()
  DO cleanup
  =dispmsg("File '"+m.scxfile+"' contains no ["+ALLTRIM(m.cplatform_)+;
           "] platform records")
  RETURN m.updcount
ENDIF
SCAN ALL
  IF TYPE('PLATFORM')=='C'.AND..NOT.PLATFORM==m.cplatform_
    LOOP
  ENDIF
  DO CASE
    CASE OBJTYPE=1
      IF ATC('#REGION 2',SPRDATA.SPR)>0
        DO cleanup
        =dispmsg("File '"+m.sprfile+"' was generated from screen set")
        RETURN m.updcount
      ENDIF
      IF .NOT.wordsearch('*:BAS',.T.,.T.)==m.null
        DO cleanup
        =dispmsg("File '"+m.scxfile+"' references FOXSCX in Setup snippet")
        RETURN m.updcount
      ENDIF
    CASE OBJTYPE<11.OR.EMPTY(NAME).OR.(OBJTYPE=15.AND.OBJCODE=0).OR.;
         .NOT.wordsearch('*:BASOBJ')==m.null
      LOOP
  ENDCASE
  IF OBJTYPE=1
    m.find_str=m.cr_lf+'READ'
    m.at_pos=AT(m.find_str,SPRDATA.SPR)
  ELSE
    m.fieldname=MLINE(NAME,1)
    m.find_str=' GET '+m.fieldname+' ;'
    m.at_pos=AT(m.find_str,SPRDATA.SCNLAYOUT)
  ENDIF
  IF m.at_pos=0
    IF OBJTYPE=1
      m.find_str=m.cr_lf+CHR(9)+'READ'
      m.at_pos=AT(m.find_str,SPRDATA.SPR)
    ELSE
      m.find_str=' EDIT '+m.fieldname+' ;'
      m.at_pos=AT(m.find_str,SPRDATA.SCNLAYOUT)
    ENDIF
    IF m.at_pos=0
      LOOP
    ENDIF
  ENDIF
  m.at_pos=m.at_pos+LEN(m.find_str)+2
  IF OBJTYPE=1
    m.clauses=SUBSTR(SPRDATA.SPR,m.at_pos,2048)
  ELSE
    m.clauses=SUBSTR(SPRDATA.SCNLAYOUT,m.at_pos,2048)
  ENDIF
  m.snptcode=''
  DO WHILE .T.
    m.at_pos2=AT(m.cr_lf,m.clauses)
    IF m.at_pos<2
      EXIT
    ENDIF
    m.snptcode=m.snptcode+LEFT(m.clauses,m.at_pos2+1)
    IF .NOT.SUBSTR(m.clauses,m.at_pos2-1,1)==';'
      EXIT
    ENDIF
    m.clauses=SUBSTR(m.clauses,m.at_pos2+2)
  ENDDO
  m.clauses=m.snptcode
  m.snptcode=''
  m.snptname=''
  DO WHILE .T.
    IF OBJTYPE=1
      DO CASE
        CASE EMPTY(m.snptname)
          m.snptname='WHEN'
          m.snpttype='WHENTYPE'
        CASE m.snptname=='WHEN'
          m.snptname='VALID'
          m.snpttype='VALIDTYPE'
        CASE m.snptname=='VALID'
          m.snptname='ACTIVATE'
          m.snpttype='ACTIVTYPE'
        CASE m.snptname=='ACTIVATE'
          m.snptname='DEACTIVATE'
          m.snpttype='DEACTTYPE'
        OTHERWISE
         EXIT
      ENDCASE
    ELSE
      DO CASE
        CASE EMPTY(m.snptname)
          m.snptname='WHEN'
          m.snpttype='WHENTYPE'
        CASE m.snptname=='WHEN'
          m.snptname='VALID'
          m.snpttype='VALIDTYPE'
        CASE m.snptname=='VALID'
          m.snptname='ERROR'
          m.snpttype='ERRORTYPE'
        CASE m.snptname=='ERROR'
          m.snptname='MESSAGE'
          m.snpttype='MESSTYPE'
        OTHERWISE
         EXIT
      ENDCASE
    ENDIF
    m.fieldeval=EVALUATE(m.snptname)
    IF EMPTY(m.fieldeval).OR.('{{'$m.fieldeval.AND.'}}'$m.fieldeval).OR.;
       .NOT.wordsearch('#INSE',m.snptname,.T.)==m.null.OR.;
       .NOT.wordsearch('#:INSERT',m.snptname,.T.)==m.null
      LOOP
    ENDIF
    m.find_str=CHR(9)+m.snptname+' '
    m.at_pos=AT(m.find_str,m.clauses)
    IF m.at_pos=0
      LOOP
    ENDIF
    m.at_pos=m.at_pos+LEN(m.find_str)
    m.snptcode=SUBSTR(m.clauses,m.at_pos)
    m.at_pos2=AT(m.cr_lf,m.snptcode)
    IF m.at_pos2>0
      m.snptcode=LEFT(m.snptcode,m.at_pos2-1)
    ENDIF
    IF EVALUATE(m.snpttype)=0
      m.snptcode=ALLTRIM(m.snptcode)
      IF RIGHT(m.snptcode,1)==';'
        m.snptcode=ALLTRIM(LEFT(m.snptcode,LEN(m.snptcode)-1))
      ENDIF
      IF ALLTRIM(m.fieldeval)==m.snptcode
        LOOP
      ENDIF
      m.updcount=m.updcount+1
      REPLACE (m.snptname) WITH m.snptcode
      =updallplat()
      LOOP
    ENDIF
    m.snptcode=STRTRAN(ALLTRIM(LEFT(m.snptcode,LEN(m.snptcode)-2)),'()','')
    m.find_str=m.cr_lf+'FUNCTION '+m.snptcode+' '
    m.at_pos=AT(m.find_str,SPRDATA.SPR)
    IF m.at_pos=0
      LOOP
    ENDIF
    m.at_pos=m.at_pos+LEN(m.find_str)+2
    m.snptcode=SUBSTR(SPRDATA.SPR,m.at_pos)
    m.find_str=m.cr_lf+'#REGION '
    m.at_pos=AT(m.find_str,m.snptcode)
    IF m.at_pos>0
      m.snptcode=SUBSTR(m.snptcode,m.at_pos+LEN(m.find_str))
      m.at_pos=AT(m.cr_lf,m.snptcode)
      IF m.at_pos>0
        m.snptcode=SUBSTR(m.snptcode,m.at_pos+2)
      ENDIF
    ENDIF
    m.find_str=m.cr_lf+'*       *'
    m.at_pos=AT(m.find_str,m.snptcode)
    IF m.at_pos=0
      m.find_str=m.cr_lf+'*       '
      m.at_pos=AT(m.find_str,m.snptcode)
    ENDIF
    IF m.at_pos>0
      m.snptcode=LEFT(m.snptcode,m.at_pos-1)
    ENDIF
    m.snptcode2=''
    FOR m.i = 1 TO MEMLINES(m.fieldeval)
      m.memline=MLINE(m.fieldeval,m.i)
      m.memline2=ALLTRIM(STRTRAN(m.memline,CHR(9),' '))
      IF EMPTY(m.memline2).OR.LEFT(m.memline2,1)=='*'.OR.;
         LEFT(m.memline2,1)=='#'.OR.;
         LEFT(m.memline2,2)==('&'+'&').OR.;
         UPPER(LEFT(m.memline2,4))=='NOTE'
        m.snptcode2=m.snptcode2+m.memline+m.cr_lf
        IF .NOT.LEFT(m.memline2,1)=='#'
          LOOP
        ENDIF
      ENDIF
      EXIT
    ENDFOR
    m.snptcode=m.snptcode2+m.snptcode
    m.snptcode2=m.fieldeval
    DO WHILE LEFT(m.snptcode,2)==m.cr_lf
      m.snptcode=SUBSTR(m.snptcode,3)
    ENDDO
    DO WHILE RIGHT(m.snptcode,2)==m.cr_lf
      m.snptcode=LEFT(m.snptcode,LEN(m.snptcode)-2)
    ENDDO
    DO WHILE LEFT(m.snptcode2,2)==m.cr_lf
      m.snptcode2=SUBSTR(m.snptcode2,3)
    ENDDO
    DO WHILE RIGHT(m.snptcode2,2)==m.cr_lf
      m.snptcode2=LEFT(m.snptcode2,LEN(m.snptcode2)-2)
    ENDDO
    IF m.snptcode==m.snptcode2
      LOOP
    ENDIF
    IF .NOT.EMPTY(m.snptcode)
      m.snptcode=m.snptcode+m.cr_lf
    ENDIF
    m.updcount=m.updcount+1
    REPLACE (m.snptname) WITH m.snptcode
    =updallplat()
  ENDDO
ENDSCAN
IF m.autogenscx
  SELECT SPRDATA
  m.at_line=ATLINE(m.c_project,SPR)
  IF m.at_line>0.AND.m.c_genscrnx$SPR
    m.pjxfile=MLINE(SPR,m.at_line)
    m.at_pos=AT(m.c_project,m.pjxfile)
    IF m.at_pos>0
      m.pjxfile=ALLTRIM(SUBSTR(m.pjxfile,m.at_pos+LEN(m.c_project)))
      m.autogenscx=.F.
      m.pjxfile=UPPER(FULLPATH(m.pjxfile))
      IF .NOT.FILE(m.pjxfile)
        m.pjxfile=''
      ENDIF
    ELSE
      m.pjxfile=''
    ENDIF
  ENDIF
ENDIF
DO cleanup
IF m.updcount=0
  =dispmsg('No snippets updated: '+m.scxfile)
  RETURN m.updcount
ENDIF
IF m.autogenscx
  =dispmsg('')
  MODIFY SCREEN (m.scxfile) NOWAIT
  CLEAR TYPEAHEAD
  KEYBOARD "{Alt-P}N{ENTER}{ENTER}{Ctrl+W}" PLAIN
  RETURN m.updcount
ENDIF
IF .NOT.EMPTY(m.pjxfile)
  =dispmsg('')
  MODIFY PROJECT (m.pjxfile) NOWAIT
  CLEAR TYPEAHEAD
  IF TYPE('_DOS')#'L'.OR._DOS.OR._UNIX
    KEYBOARD "{Alt-O}BR{Ctrl+W}" PLAIN
  ELSE
    KEYBOARD "{TAB}BR{Ctrl+W}" PLAIN
  ENDIF
  RETURN m.updcount
ENDIF
=dispmsg(ALLTRIM(STR(m.updcount,9))+' snippet'+IIF(m.updcount=1,'','s')+;
         ' updated: '+m.scxfile)
RETURN m.updcount

* END sprtoscx



PROCEDURE cleanup

IF USED('SCXBASE')
  USE IN SCXBASE
ENDIF
IF USED('SPRDATA')
  USE IN SPRDATA
ENDIF
SELECT (m.lastselect)
SET MEMOWIDTH TO (m.lastmemow)

* END cleanup



FUNCTION updallplat
PRIVATE m.uniqueid,m.r

m.uniqueid=IIF(TYPE('UNIQUEID')=='C',UNIQUEID,'')
IF EMPTY(m.uniqueid)
  RETURN .F.
ENDIF
m.r=RECNO()
REPLACE ALL (m.snptname) WITH m.snptcode;
        FOR UNIQUEID=m.uniqueid.AND.RECNO()#m.r.AND.;
            EVALUATE(m.snptname)==m.fieldeval
GOTO m.r
RETURN .T.

* END updallplat



FUNCTION wordsearch
PARAMETERS find_str,searchfld,ignoreword,returnmline
PRIVATE var_type,memodata,memline,str_data,lastmline,at_mline,at_mline2,lf_pos
PRIVATE null,cr,lf

m.null=CHR(0)
m.cr=CHR(13)
m.lf=CHR(10)
IF PARAMETERS()<=1
  m.searchfld=(OBJTYPE=1)
ENDIF
IF TYPE('m.returnmline')=='N'
  m.returnmline=.T.
ENDIF
m.var_type=TYPE('m.searchfld')
DO CASE
  CASE m.var_type=='L'
    IF m.searchfld
      IF EMPTY(SETUPCODE)
        RETURN IIF(m.returnmline,0,m.null)
      ENDIF
      m.memodata=SETUPCODE
      m.searchfld='SETUPCODE'
    ELSE
      IF EMPTY(COMMENT)
        RETURN IIF(m.returnmline,0,m.null)
      ENDIF
      m.memodata=COMMENT
      m.searchfld='COMMENT'
    ENDIF
  CASE m.var_type=='C'
    m.memodata=EVALUATE(m.searchfld)
    IF EMPTY(m.searchfld)
      RETURN IIF(m.returnmline,0,m.null)
    ENDIF
  OTHERWISE
    RETURN IIF(m.returnmline,0,m.null)
ENDCASE
m.lastmline=_MLINE
m.at_mline=0
m.lf_pos=0
m.memodata=m.lf+m.memodata
_MLINE=ATC(m.lf+m.find_str,m.memodata)
IF _MLINE=0
  m.memodata=m.cr+SUBSTR(m.memodata,2)
  _MLINE=ATC(m.cr+m.find_str,m.memodata)
  IF _MLINE=0
    _MLINE=m.lastmline
    RETURN IIF(m.returnmline,0,m.null)
  ENDIF
ENDIF
DO WHILE _MLINE<LEN(m.memodata)
  m.at_mline=_MLINE
  m.memline=ALLTRIM(MLINE(m.memodata,1,_MLINE))
  m.lf_pos=AT(m.lf,SUBSTR(m.memodata,m.at_mline+1,LEN(m.memline)))
  IF m.lf_pos>0
    m.memline=ALLTRIM(LEFT(m.memline,m.lf_pos-1))
  ENDIF
  m.str_data=SUBSTR(m.memline,LEN(m.find_str)+1,1)
  IF ATC(m.find_str,m.memline)#1.OR.(.NOT.m.ignoreword.AND.;
     .NOT.EMPTY(m.str_data).AND..NOT.m.str_data==''))
    m.memodata=m.lf+SUBSTR(m.memodata,_MLINE)
    _MLINE=ATC(m.lf+m.find_str,m.memodata)
    IF _MLINE=0
      m.memodata=m.cr+SUBSTR(m.memodata,2)
      _MLINE=ATC(m.cr+m.find_str,m.memodata)
      IF _MLINE=0
        EXIT
      ENDIF
    ENDIF
    LOOP
  ENDIF
  m.at_mline2=_MLINE
  _MLINE=m.lastmline
  m.str_data=ALLTRIM(SUBSTR(m.memline,LEN(m.find_str)+1))
  IF .NOT.m.returnmline
    RETURN m.str_data
  ENDIF
  m.returnmline=m.at_mline2-m.at_mline+1-IIF(m.lf_pos>0,1,0)
  RETURN m.at_mline
ENDDO
_MLINE=m.lastmline
RETURN IIF(m.returnmline,0,m.null)

* END wordsearch



FUNCTION trimext
PARAMETERS filename,plattype
PRIVATE at_pos

m.at_pos=AT('.',m.filename)
IF m.at_pos>0
  m.filename=LEFT(m.filename,m.at_pos-1)
ENDIF
IF m.plattype
  m.filename=IIF(_DOS.OR._UNIX,UPPER(m.filename),LOWER(m.filename))
ENDIF
RETURN ALLTRIM(m.filename)

* END trimext



FUNCTION trimpath
PARAMETERS filename,trim_ext,plattype
PRIVATE at_pos

IF EMPTY(m.filename)
  RETURN ''
ENDIF
m.at_pos=AT(':',m.filename)
IF m.at_pos>0
  m.filename=SUBSTR(m.filename,m.at_pos+1)
ENDIF
IF m.trim_ext
  m.filename=trimext(m.filename)
ENDIF
IF m.plattype
  m.filename=IIF(_DOS.OR._UNIX,UPPER(m.filename),LOWER(m.filename))
ENDIF
m.filename=ALLTRIM(SUBSTR(m.filename,AT('\',m.filename,;
           MAX(OCCURS('\',m.filename),1))+1))
DO WHILE LEFT(m.filename,1)=='.'
  m.filename=ALLTRIM(SUBSTR(m.filename,2))
ENDDO
DO WHILE RIGHT(m.filename,1)=='.'
  m.filename=ALLTRIM(LEFT(m.filename,LEN(m.filename)-1))
ENDDO
RETURN m.filename

* END trimpath



FUNCTION dispmsg
PARAMETERS m.msg
PRIVATE m.msg

WAIT CLEAR
IF EMPTY(m.msg)
  RETURN .F.
ENDIF
WAIT m.msg WINDOW NOWAIT
RETURN .T.

* END dispmsg
