FUNCTION FLEN
*(Written by Bob Grommes)

* Return the foxel display length of a string in terms of the foxel size
* of the current window, regardless of the font the string is to be
* displayed in.

* Example:

* Determine foxel length of string in Arial 12 pt italic in terms of the
* foxel size of the current window.
* ? FLEN('Hello, world!','Arial',12,'I')

PARAMETERS cString,cStrFont,nStrSize,cStrStyle

IF PARAMETERS() = 0 OR cString == ''
  RETURN 0
ENDIF

IF _WINDOWS OR _MAC
  DO CASE
    CASE PARAMETERS() < 2
      * If no font specified, assume current window's font
      cStrFont = WFONT(1)
      nStrSize = WFONT(2)
      cStrStyle = WFONT(3)
    CASE PARAMETERS() < 3
      * If no size specified, assume 10
      nStrSize = 10
    CASE PARAMETERS() < 4
      * If no style specified, assume normal
      cStrStyle = 'N'
  ENDCASE

  RETURN TXTWIDTH(cString,cStrFont,nStrSize,cStrStyle) ;
       * (FONTMETRIC(6,cStrFont,nStrSize,cStrStyle) / FONTMETRIC(6))
ELSE
  * Running under DOS or UNIX
  RETURN LEN(cString)
ENDIF
