*  Program...........: GENTEMP.PRG
*  Author............: Stephen A. Sawyer
*  Project...........: Utilities Library
*  Created...........: 06/10/94  17:13:23
*  Copyright.........: (c) KarCal Company, Inc., 1994
*) Description.......: Generates a temporary filename
*)                   : This has limited use with the
*)                   : introduction of cursors, but
*)                   : there are still some times when
*)                   : when you want a "scratch" table
*)                   : or a "scratch" file for SET ALTERNATE
*)                   : or whatever.
*)                   : Places the temporary file wherever
*)                   : you have your TMPFILES= set in your
*)                   : CONFIG.FP/FPW.  
*  Calling Samples...: 
*  Parameter List....: 
*  Major change list.: 

PRIVATE jcTmpFile,jcTmpPath
IF _WINDOWS
	jcTmpPath=SYS(2023) + "\"
ELSE
	* FoxPro/DOS through version 2.6 has an acknoledged
	* cross-platform inconsistency in the SYS(2023) 
	* function, in that it will only return the *drive* 
	* under DOS, but both the *drive* and *path* under
	* FP/Windows.  We have to create a cursor, find
	* out where that cursor is located, and then use
	* that directory for our temporary file name.
	
	lcCurrArea=ALIAS()
	create cursor x_scrtch (null C(1))
	jcTmpPath=JUSTPATH(DBF("x_scrtch")) + "\"
	USE
	IF ! EMPTY(lcCurrArea)
		SELECT &lcCurrArea
	ENDIF
ENDIF
jcTmpFile = jcTmpPath + SYS(3) + ".TMP"
RETURN jcTmpFile

*: EOF: GENTEMP.PRG
