* Program....: SMAPI.PRG -- SAPI & MAPI Wrapper Functions
* Version....: 1.0
* Author.....: Ryan Katri & Randy Wallin
* Date.......: January 3, 1994     Last Modified: 02/22/94 @ 09:42 am
* Notice.....: Copyright (c) 1994 COB System Designs, Inc., All Rights Reserved.
* QFRestore..: 491,23
* Compiler...: FoxPro 2.5
* Abstract...:
*
*   These are wrapper routines for SAPI & MAPI.  You will need the
*   Workgroup Extensions for FoxPro from Microsoft for these to work.
*
*   These are only routines for _SENDING_ messages thru MS Mail
*   and for _SETTING_ appointments and tasks in Schedule+.
*   We have not had the need to read mail or view schedules thru
*   FoxPro yet; hence, have not taken the time to add such
*   functionality.  Hopefully these functions will give you insight
*   on how to do this.
*
*   Additional Features:
*      - Set alarm times
*      - Attach files
*      - Send messages to multiple users
*      - Return receipt support
*      - Easily set project duration
*
*   Additional Limitations:
*      - I see no way to set tentative appointments thru FOXMAPI
*      - No Meeting support
*      - No automatic support for private appointments & tasks,
*        but should be easy to add (simply add 1 to nFlags)
*
* Changes....:
*

*
* Set TEST to .F. and include SMAPI.PRG in your own projects to
* use these wrapper functions.
*
#define TEST  .T.

#IF TEST
PRIVATE hSched, hSession, nRecipCnt, nErr
PRIVATE aFiles, lReceipt, cMsgSubj, cMessage

*
* MAPI DEMO
* ---------
*

* Create the MAPI cursors
=MAPIInit()

* Get a MAPI handle, which will be greater than 0 if successful
hSession = MAPILogon()

IF hSession > 0

   nRecipCnt = 0
   nErr = MPAddress(hSession, 0, "Mail", 2, "", @nRecipCnt, "MapiRecip", 0, 0)

   IF nErr = 0
      m.cMsgSubj = "Message Subject"
      m.cMessage = "This is our message body!"
      m.lReceipt = .T.     && Return receipt requested?
      DIMENSION aFiles[2]
      aFiles[1] = "file1.txt"
      aFiles[2] = "file2.txt"


      * Create an array of names from the cursor which was filled in
      * by our call to MPAddress()
      SELECT Name FROM MapiRecip INTO ARRAY aSendTo

      * Call our function to send the message:
      *   hSession = our MAPI session handle
      *   aSendTo  = array of names to send to
      *   cMsgSubj = message subject
      *   cMessage = message body
      *   aFiles   = array of files to attach; if you have only
      *              one file, you can pass it as a single character string
      *   lReceipt = return receipt requested?
      IF MAPISendMsg(hSession, @aSendTo, cMsgSubj, cMessage, @aFiles, lReceipt)
         WAIT WINDOW "Mail successfully sent!" + CHR(13) + "Press any key. . ."
      ENDIF &&* MAPISendMsg(hSession, @aSendTo, cMsgSubj, cMessage, aFiles, lReceipt)

   ENDIF &&* nErr = 0
   =MAPILogoff(hSession)
ELSE
   WAIT WINDOW "Unable to logon to mail." + CHR(13) + "Press any key. . ."
ENDIF &&* hSession > 0


*
* SAPI DEMO
* ---------
*

* You could call SAPIInit here, just like we did for MAPI, but the
* cursors are automatically initialized anyway in the calls
* to SAPINewAppt() and SAPINewTask()


* Get a SAPI handle, which will be greater than 0 if successful
hSched = SAPIBegin()

IF hSched > 0

   *
   * Create 2 new project items under the name TEST PROJECT
   *

   * Item 1 task due in 2 days, with duration being 2 days,
   * priority 5, and reminder set
   =SAPINewTask(hSched, "Test Project", "Item 1 -- Day before completion", DATE() + 2, "0002 D", "5", .T.)

   * Item 2 task in 21 days, duration 2 weeks, priority 9, no alarm
   =SAPINewTask(hSched, "Test Project", "Item 2 -- Completion", DATE() + 21, "0002 W", "9")


   *
   * Create a couple new appointments
   *

   * 8-10am appt tomorrow, with alarm set 30 minutes beforehand (7:30am)
   =SAPINewAppt(hSched, "Dentist: 8am", DATE()+1, "08:00", DATE()+1, "10:00", DATE()+1, "07:30")

   * Payday at 6pm on Mar 1st, no alarm
   =SAPINewAppt(hSched, "Payday! Mar 1st 6pm", {03/01/94}, "18:00")

   WAIT WINDOW "Schedule items created!" + CHR(13) + "Press any key. . ."


   =SAPIEnd(hSched)
ELSE
   WAIT WINDOW "Unable to login to Schedule+." + CHR(13) + "Press any key. . ."
ENDIF &&* hSched > 0


RETURN
#ENDIF




* Cursor alias names
#define CUR_MESG   "MapiMesg"
#define CUR_FILE   "MapiFile"
#define CUR_RECIP  "MapiRecip"

#define CUR_APPT   "SapiAppt"
#define CUR_USER   "SapiUser"
#define CUR_ASSOC  "SapiAssoc"
#define CUR_ATTD   "SapiAttd"
#define CUR_RECIP  "MapiRecip"
#define CUR_TASK   "SapiTask"

* MAPI FLAGS - Note: not all are used in these libraries
#define MP_LOGON_UI               1
#define MP_NEW_SESSION            2
#define MP_DIALOG                 8
#define MP_UNREAD_ONLY            32
#define MP_ENVELOPE_ONLY          64
#define MP_PEEK                   128
#define MP_GUARANTEE_FIFO         256
#define MP_BODY_AS_FILE           512
#define MP_AB_NOMODIFY            1024
#define MP_SUPPRESS_ATTACH        2048
#define MP_FORCE_DOWNLOAD         4096

#define MP_OLE                    1
#define MP_OLE_STATIC             2

#define MP_ORIG                   0
#define MP_TO                     1
#define MP_CC                     2
#define MP_BCC                    3

#define MP_UNREAD                 1
#define MP_RECEIPT_REQUESTED      2
#define MP_SENT                   4

* Return/error codes from MAPI functions
#define SUCCESS_SUCCESS           0
#define MP_USER_ABORT             1
#define MP_E_FAILURE              2
#define MP_E_LOGIN_FAILURE        3
#define MP_E_DISK_FULL            4
#define MP_E_INSUFFICIENT_MEMORY  5
#define MP_E_ACCESS_DENIED        6
#define MP_E_TM_SESSIONS          8
#define MP_E_TM_FILES             9
#define MP_E_TM_RECIPIENTS        10
#define MP_E_ATT_NOT_FOUND        11
#define MP_E_ATT_OPEN_FAILURE     12
#define MP_E_ATT_WRITE_FAILURE    13
#define MP_E_UNKNOWN_RECIPIENT    14
#define MP_E_BAD_RECIPTYPE        15
#define MP_E_NO_MESSAGES          16
#define MP_E_INV_MESSAGE          17
#define MP_E_TEXT_TOO_LARGE       18
#define MP_E_INV_SESSION          19
#define MP_E_TYPE_NOT_SUPPORTED   20
#define MP_E_AMB_RECIPIENT        21
#define MP_E_MSG_IN_USE           22
#define MP_E_NETWORK_FAILURE      23
#define MP_E_INV_EDITFIELDS       24
#define MP_E_INV_RECIPS           25
#define MP_E_NOT_SUPPORTED        26

#define		SP_E_INV_SENT_FOR			10000
#define		SP_E_NOT_INSTALLED		10005
#define		SP_E_NO_ITEMS				10010
#define		SP_E_NO_SCHEDULE			10015
#define		SP_E_NO_PRIVILEGE			10020
#define		SP_E_ADDRESS_FORMAT		10025
#define		SP_E_USER					10030
#define		SP_E_ITEM					10035
#define		SP_E_TYPE					10040
#define		SP_E_FLAGS					10045
#define		SP_E_ASSOC					10050
#define		SP_E_ORGANIZER				10055
#define		SP_E_ORG_ID					10060
#define		SP_E_ATTENDEES				10065
#define		SP_E_TIME					10070
#define		SP_E_PRIORITY				10075
#define		SP_E_MONTH					10080
#define		SP_E_RESTRICTION			10085
#define		SP_E_ALARM_RING_IN_PAST	10090
#define		SP_E_NOT_ONLINE			10095
#define		SUCCESS_NO_SCHEDULE		10100


* Return/error messages from MAPI functions
#define ZZ_SUCCESS_SUCCESS        'Success'
#define ZZ_USER_ABORT             'User Aborted'
#define ZZ_E_FAILURE              'Mail Failure'
#define ZZ_E_LOGIN_FAILURE        'Login Failure'
#define ZZ_E_DISK_FULL            'Disk Is Full'
#define ZZ_E_INSUFFICIENT_MEMORY  'Insufficient Memory'
#define ZZ_E_ACCESS_DENIED        'Access Denied'
#define ZZ_E_TM_SESSIONS          'Too Many Sessions'
#define ZZ_E_TM_FILES             'Too Many Files'
#define ZZ_E_TM_RECIPIENTS        'Too Many Recipients'
#define ZZ_E_ATT_NOT_FOUND        'Attachment Not Found'
#define ZZ_E_ATT_OPEN_FAILURE     'Attachment Open Failure'
#define ZZ_E_ATT_WRITE_FAILURE    'Attachment Write Failure'
#define ZZ_E_UNKNOWN_RECIPIENT    'Unknown Recipient'
#define ZZ_E_BAD_RECIPTYPE        'Bad Recipient'
#define ZZ_E_NO_MESSAGES          'No Messges'
#define ZZ_E_INV_MESSAGE          'Invalid Message'
#define ZZ_E_TEXT_TOO_LARGE       'Text Too Large'
#define ZZ_E_INV_SESSION          'Invalid Session'
#define ZZ_E_TYPE_NOT_SUPPORTED   'Type Not Supported'
#define ZZ_E_AMB_RECIPIENT        'Ambiguous Recipient'
#define ZZ_E_MSG_IN_USE           'Message In Use'
#define ZZ_E_NETWORK_FAILURE      'Network Failure'
#define ZZ_E_INV_EDITFIELDS       'Invaid Edit Fields'
#define ZZ_E_INV_RECIPS           'Invalid Recipients'
#define ZZ_E_NOT_SUPPORTED        'Not Supported'

* Schedule+ FLAGS
#define SP_NO_REQUEST_SENT        0
#define SP_NO_RESPONSE            1
#define SP_POSITIVE_RESPONSE      2
#define SP_NEGATIVE_RESPONSE      3
#define SP_AMBIGUOUS_RESPONSE     4
#define SP_RESPONSE_REQUESTED     65536

#define SP_PRIVATE                1
#define SP_TENTATIVE              4
#define SP_PRV_PROJECT            2
#define SP_BOSS_WANTS_COPY        1
#define SP_DEFAULT_ALARM          4096
#define SP_MOD_FLAGS              65536
#define SP_MOD_ASSOC              131072
#define SP_MOD_ATTENDEES          262144
#define SP_MOD_TEXT               524288
#define SP_MOD_TIMES              4194304
#define SP_MOD_PROJECT_NAME       8388608
#define SP_MOD_PRIORITY           16777216
#define SP_MOD_ALL                33488896
#define SP_SUPPRESS_RECIPIENTS    4096


**
* Function....: MAPILogon
* Abstract....:
*   Logs on to the mail system
*
* Returns.....:
*   Mail session channel, if successful.  0 otherwise
*
* Parameters..: None
**
FUNCTION MAPILogon
PRIVATE hSession, nRetVal

hSession = 0
IF .NOT. "FOXMAPI"$SET("LIBRARY")
   SET LIBRARY TO FOXMAPI ADDITIVE
ENDIF &&* .NOT. "FOXMAPI"$SET("LIBRARY")

nRetVal = MPLogon(0, "", "", MP_LOGON_UI + MP_NEW_SESSION, 0, @hSession)
RETURN IIF(MAPIError(m.nRetVal),m.hSession,0)

*EOF MAPILogon


**
* Function....: MAPILogoff
* Abstract....:
*   Logs off passed session handle
*
* Returns.....: TRUE if successful
*
* Parameters..:
*   hSession = Mail handle to log off
**
FUNCTION MAPILogoff
PARAMETERS hSession
PRIVATE nRetVal

* Close the cursors
=MAPIClose()

IF EMPTY(hSession)
   hSession = 0
ENDIF &&* EMPTY(hSession)

nRetVal = MPLogoff(hSession, 0, 0, 0)

RETURN MAPIError(m.nRetVal)
*EOF MAPILogoff


**
* Function....: MAPIInit
* Abstract....:
*    Create the MapiMesg, MapiRecip, and MapiFile cursors
*    If they already exist, create new ones because we
*    don't want to use the old data!
*
* Returns.....: TRUE
*
* Parameters..: None
**
FUNCTION MAPIInit
PRIVATE nSelect

nSelect = SELECT()

IF .NOT. "FOXMAPI"$SET("LIBRARY")
   SET LIBRARY TO FOXMAPI ADDITIVE
ENDIF &&* .NOT. "FOXMAPI"$SET("LIBRARY")

=MAPIClose()

=MPCursor("MapiMesg", CUR_MESG)
=MPCursor("MapiFile", CUR_FILE)
=MPCursor("MapiRecip", CUR_RECIP)

SELECT (nSelect)

RETURN .T.
*EOF MAPIInit


**
* Function....: MAPIClose
* Abstract....:
*   Closes all open MAPI cursors
*
* Returns.....: TRUE
*
* Parameters..: None
**
FUNCTION MAPIClose

IF USED(CUR_MESG)
   USE IN (CUR_MESG)
ENDIF
IF USED(CUR_FILE)
   USE IN (CUR_FILE)
ENDIF
IF USED(CUR_RECIP)
   USE IN (CUR_RECIP)
ENDIF


RETURN .T.
*EOF MAPIClose



**
* Function....: MAPISendMsg
* Abstract....:
*   Send a MAPI mail message
*
* Returns.....: TRUE if successfully sent, FALSE otherwise
*
* Parameters..:
*   hSession = Mail session handle (or 0)
*   aRecips  = Array of recipient names
*              If sending only to 1 person, pass as a string
*   cSubject = Subject of message
*   cMessage = Text of message
*   aFiles   = Array of file attachments
*              If sending only 1 file, pass as a string
*   lReceipt = TRUE to request a receipt, FALSE otherwise
*
* Notes.......:
**
FUNCTION MAPISendMsg
PARAMETERS hSession, aRecips, cSubject, cMessage, aFiles, lReceipt
EXTERNAL ARRAY aRecips, aFiles

PRIVATE i, aRecipInfo, nSelect, nNumFiles
PRIVATE nRetVal, nFlags


nSelect = SELECT()

* Initialize & reset the cursors
=MAPIInit()

* Allow single strings to be passed in place of arrays
IF TYPE("aRecips[1]") = "U"
   =MPResolve(0, 0, aRecips, 0, 0, CUR_RECIP)
ELSE
   * Add recipient names from array to cursor
   =MPCursor("MapiRecip", "Resolve")
   SELECT Resolve
   FOR i = 1 TO ALEN(aRecips)
      IF MPResolve(0, 0, ALLTRIM(aRecips[i]), 0, 0, "Resolve") = 0
         SCATTER MEMO TO aRecipInfo
         INSERT INTO (CUR_RECIP) FROM ARRAY aRecipInfo
      ENDIF &&* MPResolve(0, 0, aRecips[i], 0, 0, "Resolve") = 0
   ENDFOR &&* i = 1 TO ALEN(aRecips)
   USE IN Resolve
ENDIF &&* TYPE("aRecips") = "C"

IF RECCOUNT(CUR_RECIP) = 0
   =AlertMsg(ZZ_E_UNKNOWN_RECIPIENT, "Mail Error")
   RETURN .F.
ENDIF &&* RECCOUNT(CUR_RECIP) = 0


* Insert the filenames to attach into the cursor, and track how
* many valid filenames were added to the cursor
nNumFiles = 0
IF TYPE("aFiles[1]") = "U"
   IF FILE(aFiles)
      INSERT INTO (CUR_FILE) VALUES (0, 0, nNumFiles, aFiles, JustFile(aFiles), "")
      nNumFiles = 1
   ENDIF &&* FILE(aFiles)
ELSE
   * Add file attachments from array to cursor
   FOR i = 1 TO ALEN(aFiles)
      IF FILE(aFiles[i])
         INSERT INTO (CUR_FILE) VALUES (0, 0, nNumFiles, aFiles[i], JustFile(aFiles[i]), "")
         nNumFiles = nNumFiles + 1
      ENDIF &&* FILE(aFiles[i])
   ENDFOR &&* i = 1 TO ALEN(aFiles)
ENDIF &&* TYPE("aFiles") = "C"


IF lReceipt
   nFlags = MP_RECEIPT_REQUESTED
ELSE
   nFlags = 0
ENDIF &&* lReceipt

* Update the message cursor
INSERT INTO (CUR_MESG) VALUES (0, cSubject, ;
  SPACE(nNumFiles) + CHR(13) + cMessage, "IPM.", GetDate(), ;
  "", nFlags, RECCOUNT(CUR_RECIP), nNumFiles)

nFlags = MP_LOGON_UI
nRetVal = MPSendMail(0, 0, CUR_MESG, CUR_RECIP, CUR_FILE, nFlags, 0);

SELECT (nSelect)

RETURN MAPIError(nRetVal)
*EOF MAPISendMsg


**
* Function....: JustFile
* Called by...: Global
*
* Abstract....:
*   Given a full path name & file, returns just the
*   filename portion.  Alternative to opening the
*   entire FOXTOOLS library just to use the JUSTFNAME
*   function.
*
* Returns.....:
*   Filename
*
* Parameters..:
*   cFullFile = full filename
*
* Notes.......:
**
FUNCTION JustFile
PARAMETERS cFullFile
PRIVATE cName
cName = SUBSTR(cFullFile, RAT("\", cFullFile) + 1)
IF AT(":", cName) > 0
   cName = SUBSTR(cName, RAT(":", cFullFile) + 1)
ENDIF &&* AT(":", cName) > 0
RETURN cName
*EOF JustFile


**
* Function....: SAPIBegin
* Abstract....:
*   Starts a Schedule+ session
*
* Parameters..:
*   hSession = MAPI session handle (defaults to 0)
*
* Returns.....:
*   Schedule+ session handle if successful; 0 otherwise
**
FUNCTION SAPIBegin
PARAMETERS hSession
PRIVATE nRetVal, hSPSession

IF EMPTY(hSession)
   hSession = 0
ENDIF &&* EMPTY(hSession)

IF .NOT. "FOXMAPI"$SET("LIBRARY")
   SET LIBRARY TO FOXMAPI
ENDIF &&* .NOT. "FOXMAPI"$SET("LIBRARY")

hSPSession = 0
nRetVal = SPBegin(hSession, 0, 0, 0, @hSPSession)

IF nRetVal = SP_E_NO_SCHEDULE
   RUN /N7 SCHDPLUS.EXE
   nRetVal = SPBegin(hSession, 0, 0, 0, @hSPSession)
ENDIF

RETURN IIF(MAPIError(m.nRetVal), hSPSession, 0)

*EOF SAPIBegin


**
* Function....: SAPIEnd
* Abstract....:
*   Ends a Schedule+ session
*
* Returns.....: Error code
*
* Parameters..:
*   hSPSession = Schedule+ handle to end
**
FUNCTION SAPIEnd
PARAMETERS hSPSession
PRIVATE nRetVal

IF EMPTY(hSPSession)
   hSPSession = 0
ENDIF &&* EMPTY(hSPSession)


* Close the cursors
nRetVal = SPEnd(hSPSession, 0, 0, 0)

RETURN MAPIError(m.nRetVal)
*EOF SAPIEnd



**
* Function....: SAPINewAppt
* Abstract....:
*   Adds a new appointment to users schedule
*
* Returns.....: TRUE if appointment successfully set
*
* Parameters..:
*   hSPSession = Session handle
*   cText      = Text for appointment
*   dDateStart = Appointment start date
*   cTimeStart = Appointment start time (ie "18:00" = 6pm)
*   dDateEnd   = Appointment end date
*   cTimeEnd   = Appointment end time
*   dAlarmDate = Alarm date \ Leave these two blank for
*   cAlarmTime = Alarm time / no alarm setting
*   cType      = Type of appointment; leave blank for "SimpleAppt"
*
* Notes.......:
**
FUNCTION SAPINewAppt
PARAMETERS hSPSession, cText, dDateStart, cTimeStart, dDateEnd, cTimeEnd, dAlarmDate, cAlarmTime, cType

PRIVATE nSelect, nRetVal, nFlags, nAssocCnt, lRemind

nSelect = SELECT()

IF EMPTY(hSPSession)
   hSPSession = 0
ENDIF &&* EMPTY(hSPSession)

IF EMPTY(cType)
   cType = "SimpleAppt"
ENDIF &&* EMPTY(cType)

IF EMPTY(dDateStart)
   dDateStart = DATE()
ENDIF &&* EMPTY(dDateStart)

IF EMPTY(dDateEnd) .OR. dDateEnd < dDateStart
   dDateEnd = dDateStart
ENDIF &&* EMPTY(dDateEnd) .OR. dDateEnd < dDateStart

IF EMPTY(cTimeStart)
   cTimeStart = TIME()
ENDIF &&* EMPTY(cTimeStart)

IF EMPTY(cTimeEnd)
   cTimeEnd = cTimeStart
ENDIF &&* EMPTY(cTimeEnd)

lRemind = .NOT. EMPTY(dAlarmDate) .OR. .NOT. EMPTY(cAlarmTime)
IF EMPTY(dAlarmDate)
   dAlarmDate = dDateStart
ENDIF &&* EMPTY(dAlarmDate)
IF EMPTY(cAlarmTime)
   cAlarmTime = cTimeStart
ENDIF &&* EMPTY(cAlarmTime)

* Initialize & reset the cursors
=SAPIInit("APPT,ASSOC,RECIP,ATTD")

* Set to 1 for a private appointment -- should probably set
* this up as a parameter
nFlags = 0


nAssocCnt = 0
IF lRemind
   INSERT INTO (CUR_ASSOC) VALUES (0, "Alarm", 0, "", 0, GetDate(dAlarmDate, cAlarmTime))
   nAssocCnt = nAssocCnt + 1
ENDIF &&* lRemind


INSERT INTO (CUR_APPT) VALUES (0, cType, nFlags, nAssocCnt, "", 0, cText, ;
  "", "", GetDate(dDateStart, cTimeStart), GetDate(dDateEnd, cTimeEnd))


INSERT INTO (CUR_ATTD) VALUES (0, "Individual", 0)

item = ""
nRetVal = SPSaveAppt(hSPSession, 0, CUR_RECIP, CUR_APPT, CUR_ASSOC, CUR_ATTD, ;
  "", 0, 0, @item)

SELECT (nSelect)

RETURN MAPIError(nRetVal)
*EOF SAPINewAppt


**
* Function....: SAPINewTask
* Abstract....:
*   Adds a new task to users schedule
*
* Returns.....: TRUE if successful, FALSE otherwise
*
* Parameters..:
*   hSPSession = Session handle
*   cProjName  = Project name to put task under
*   cText      = Text for the task
*   dDueDate   = Task due date
*   cDuration  = How soon task is active before due date, in the
*                form: NNNN U, where NNNN is the number of units
*                and U is either D for days, W for weeks, or M for
*                months.  Make sure units is padded to 4 characters!
*   cPriority  = Task priority ("0" - "9")
*   lRemind    = TRUE (.T.) to set alarm for task
*   cType      = Type of task; leave blank for "Simple Task"
*
* Notes.......:
**
FUNCTION SAPINewTask
PARAMETERS hSPSession, cProjName, cText, dDueDate, cDuration, cPriority, lRemind, cType

PRIVATE nSelect, nRetVal, nFlags, cRecur, cBody, cOrgID
PRIVATE nAttendCnt, nAssocCnt, item

nSelect = SELECT()

IF EMPTY(hSPSession)
   hSPSession = 0
ENDIF &&* EMPTY(hSPSession)

IF EMPTY(cType)
   cType = "SimpleTask"
ENDIF &&* EMPTY(cType)

IF EMPTY(dDueDate)
   dDueDate = DATE()
ENDIF &&* EMPTY(dDueDate)

IF EMPTY(cDuration)
   cDuration = ""
ENDIF &&* EMPTY(cDuration)

IF EMPTY(cPriority)
   cPriority = "9"
ENDIF &&* EMPTY(cPriority)

IF EMPTY(cProjName)
   cProjName = ""
ENDIF &&* EMPTY(cProjName)

IF EMPTY(cPriority)
   cPriority = "9"
ENDIF &&* EMPTY(cPriority)

* Initialize & create the cursors we need
=SAPIInit("TASK,ASSOC,RECIP")

nFlags = 4
nAssocCnt = 0
cBody = ""
cOrgID = ""
nAttendCnt = 0
cRecur = ""

IF lRemind
   INSERT INTO (CUR_ASSOC) VALUES (0, "Alarm", 0, "", 0, GetDate(dDueDate, ""))
   nAssocCnt = nAssocCnt + 1
ENDIF &&* lRemind

INSERT INTO (CUR_TASK) VALUES (0, cType, nFlags, nAssocCnt, cOrgID, ;
  nAttendCnt, cText, cBody, cRecur, LEFT(GetDate(dDueDate), 10)+" 00:00", cDuration, cProjName, ;
  cPriority)

item = ""
nRetVal=SPSaveTask(hSPSession, 0, CUR_RECIP, CUR_TASK, CUR_ASSOC, "", "", 0, 0, @item)


SELECT (nSelect)

RETURN MAPIError(nRetVal)
*EOF SAPINewTask


**
* Function....: SAPIClose
* Abstract....:
*   Closes all open SAPI cursors
*
* Returns.....: TRUE
*
* Parameters..: None
**
FUNCTION SAPIClose

IF USED(CUR_APPT)
   USE IN (CUR_APPT)
ENDIF &&* USED(CUR_APPT)
IF USED(CUR_USER)
   USE IN (CUR_USER)
ENDIF &&* USED(CUR_USER)
IF USED(CUR_ASSOC)
   USE IN (CUR_ASSOC)
ENDIF &&* USED(CUR_ASSOC)
IF USED(CUR_ATTD)
   USE IN (CUR_ATTD)
ENDIF &&* USED(CUR_ATTD)
IF USED(CUR_RECIP)
   USE IN (CUR_RECIP)
ENDIF &&* USED(CUR_RECIP)
IF USED(CUR_TASK)
   USE IN (CUR_TASK)
ENDIF &&* USED(CUR_TASK)


RETURN .T.
*EOF SAPIClose




**
* Function....: SAPIInit
* Abstract....:
*   Create the SAPI cursors
*   If they already exist, create new ones because we
*   don't want to use the old data!
*
* Parameters..:
*   cOpen = Which cursors to open (APPT, ASSOC, ATTD, RECIP, TASK)
**
FUNCTION SAPIInit
PARAMETERS cOpen
PRIVATE nSelect

nSelect = SELECT()

IF .NOT. "FOXMAPI"$SET("LIBRARY")
   SET LIBRARY TO FOXMAPI
ENDIF &&* .NOT. "FOXMAPI"$SET("LIBRARY")

=SAPIClose()


IF EMPTY(cOpen)
   cOpen = "APPT,ASSOC,ATTD,RECIP,TASK"
ENDIF &&* EMPTY(cOpen)
cOpen = UPPER(cOpen)

IF "APPT"$cOpen
   =MPCursor("SPlusAppt", CUR_APPT)
ENDIF &&* "APPT"$cOpen
IF "USER"$cOpen
   =MPCursor("SPlusUser", CUR_USER)
ENDIF &&* "USER"$cOpen
IF "ASSOC"$cOpen
   =MPCursor("SPlusAssoc", CUR_ASSOC)
ENDIF &&* "ASSOC"$cOpen
IF "ATTD"$cOpen
   =MPCursor("SPlusAttd", CUR_ATTD)
ENDIF &&* "ATTD"$cOpen
IF "RECIP"$cOpen
   =MPCursor("MapiRecip", CUR_RECIP)
ENDIF &&* "RECIP"$cOpen
IF "TASK"$cOpen
   =MPCursor("SPlusTask", CUR_TASK)
ENDIF &&* "TASK"$cOpen

SELECT (nSelect)

RETURN
*EOF SAPIInit



**
* Function....: MAPIError
* Abstract....:
*   This function handles return/error codes and displays
*   an error message where appropriate.
*
* Returns.....: TRUE if successful, FALSE otherwise
*
* Parameters..:
*   nErrorNum = error number to report
*
* Notes.......: if you wish to do your own error handling
*               after a function returns, put the following
*               statement at the top of this function:
*
*               RETURN (nErrorNum)
*
**
FUNCTION MAPIError
PARAMETER nErrorNum

PRIVATE lSuccess

lSuccess = .F.
* handle return codes from MAPI functions
DO CASE
   CASE nErrorNum = SUCCESS_SUCCESS
      lSuccess = .T.
   CASE nErrorNum = MP_USER_ABORT
      * =AlertMsg(ZZ_USER_ABORT, "Mail Error")
   CASE nErrorNum = MP_E_FAILURE
      =AlertMsg(ZZ_E_FAILURE, "Mail Error")
   CASE nErrorNum = MP_E_LOGIN_FAILURE
      =AlertMsg(ZZ_E_LOGIN_FAILURE, "Mail Error")
   CASE nErrorNum = MP_E_DISK_FULL
      =AlertMsg(ZZ_E_DISK_FULL, "Mail Error")
   CASE nErrorNum = MP_E_INSUFFICIENT_MEMORY
      =AlertMsg(ZZ_E_INSUFFICIENT_MEMORY, "Mail Error")
   CASE nErrorNum = MP_E_ACCESS_DENIED
      =AlertMsg(ZZ_E_ACCESS_DENIED, "Mail Error")
   CASE nErrorNum = MP_E_TM_SESSIONS
      =AlertMsg(ZZ_E_TM_SESSIONS, "Mail Error")
   CASE nErrorNum = MP_E_TM_FILES
      =AlertMsg(ZZ_E_TM_FILES, "Mail Error")
   CASE nErrorNum = MP_E_TM_RECIPIENTS
      =AlertMsg(ZZ_E_TM_RECIPIENTS, "Mail Error")
   CASE nErrorNum = MP_E_ATT_NOT_FOUND
      =AlertMsg(ZZ_E_ATT_NOT_FOUND, "Mail Error")
   CASE nErrorNum = MP_E_ATT_OPEN_FAILURE
      =AlertMsg(ZZ_E_ATT_OPEN_FAILURE, "Mail Error")
   CASE nErrorNum = MP_E_ATT_WRITE_FAILURE
      =AlertMsg(ZZ_E_ATT_WRITE_FAILURE, "Mail Error")
   CASE nErrorNum = MP_E_UNKNOWN_RECIPIENT
      =AlertMsg(ZZ_E_UNKNOWN_RECIPIENT, "Mail Error")
   CASE nErrorNum = MP_E_BAD_RECIPTYPE
      =AlertMsg(ZZ_E_BAD_RECIPTYPE, "Mail Error")
   CASE nErrorNum = MP_E_NO_MESSAGES
      =AlertMsg(ZZ_E_NO_MESSAGES, "Mail Error")
   CASE nErrorNum = MP_E_INV_MESSAGE
      =AlertMsg(ZZ_E_INV_MESSAGE, "Mail Error")
   CASE nErrorNum = MP_E_TEXT_TOO_LARGE
      =AlertMsg(ZZ_E_TEXT_TOO_LARGE, "Mail Error")
   CASE nErrorNum = MP_E_INV_SESSION
      =AlertMsg(ZZ_E_INV_SESSION, "Mail Error")
   CASE nErrorNum = MP_E_TYPE_NOT_SUPPORTED
      =AlertMsg(ZZ_E_TYPE_NOT_SUPPORTED, "Mail Error")
   CASE nErrorNum = MP_E_AMB_RECIPIENT
      =AlertMsg(ZZ_E_AMB_RECIPIENT, "Mail Error")
   CASE nErrorNum = MP_E_MSG_IN_USE
      =AlertMsg(ZZ_E_MSG_IN_US, "Mail Error")
   CASE nErrorNum = MP_E_NETWORK_FAILURE
      =AlertMsg(ZZ_E_NETWORK_FAILURE, "Mail Error")
   CASE nErrorNum = MP_E_INV_EDITFIELDS
      =AlertMsg(ZZ_E_INV_EDITFIELDS, "Mail Error")
   CASE nErrorNum = MP_E_INV_RECIPS
      =AlertMsg(ZZ_E_INV_RECIPS, "Mail Error")
   CASE nErrorNum = MP_E_NOT_SUPPORTED
      =AlertMsg(ZZ_E_NOT_SUPPORTED, "Mail Error")
ENDCASE

RETURN lSuccess
*EOF MAPIError


**
* Function....: AlertMsg
* Abstract....:
**
FUNCTION AlertMsg
PARAMETER cMsg, cTitle

* Message Box Definitions
#define MB_OK           0
#define MB_ICONEXCL     48
#DEFINE MB_TITLE        "Warning"

IF TYPE("cTitle") <> "C"
   cTitle = MB_TITLE
ENDIF &&* EMPTY(cTitle)

* Checks to see if Foxtools is available to use MSGBOX function,
* else WAIT WINDOW is used.
IF "FOXTOOLS.FLL" $ SET("LIBRARY")
   =MsgBox(cMsg, cTitle, MB_OK + MB_ICONEXCL)
ELSE
   WAIT WINDOW cMsg
ENDIF &&* "FOXTOOLS.FLL" $ SET("LIBRARY")

RETURN
*EOF AlertMsg

**
* Function....: GetDate
* Abstract....:
*   Date/Time stamp used for DateReceived field of
*   mapiMesg cursor.
*
* Returns.....:
*   Date/Time stamp
**
FUNCTION GetDate
PARAMETERS dDate, cTime

PRIVATE getdate,olddate,oldcentury,oldhours

IF EMPTY(dDate)
   dDate = DATE()
ENDIF &&* EMPTY(dDate)

IF EMPTY(cTime)
   cTime = TIME()
ENDIF &&* EMPTY(cTime)

olddate=SET('date')
oldcentury=SET('century')
oldhours=SET('HOURS')
SET DATE TO ymd
SET CENTURY ON
SET HOURS TO 24
getdate=DTOC(dDate)+' '+LEFT(cTime,5)
SET DATE TO &olddate
SET CENTURY &oldcentury
SET HOURS TO &oldhours

RETURN getdate

