*******************************************************************************
*                                                                             *
*                          ON_DATE (on date=? do...)                          *
*                                                                             *
*                              Jayson R. Minard                               *
*                                                                             *
*******************************************************************************


*******************************************************************************
* when called, this program will only execute a specific command if a
* specified filedate is the same as the sytem date.  This is useful
* for programs that update files daily.
*******************************************************************************

#INCLUDE STRING.HDR
#INCLUDE DATE.HDR
#INCLUDE IO.HDR
#INCLUDE FILEIO.HDR
#INCLUDE SYSTEM.HDR

PROCEDURE Force_Main
  PARAMETERS CONST CHAR( 128 ) cmd_line

  VARDEF
    CHAR( 128 ) cmd_param
    CHAR( 80 )  cmd_file
    CHAR( 128 ) cmd_run
    INT         loc
  ENDDEF


  *- grab command line parameter
  cmd_param = TRIM( UPPER( cmd_line ) )
  loc = AT( ",", cmd_param )

  *- set screen output through DOS so that it can be redirected
  SCRN_DOS()

  *- title
  ?
  ? "ON DATE = "+DTOC( TODAY() )+" DO..."
  ? "------------------------"
  ?

  IF loc = 0
    ? "  !ERROR:  invalid command line parameters"
    ?
    ? "    usage:   ON_DATE <filename>, <run command>"
    ?
    QUIT 1
  ENDIF

  *- grab filename to check date
  cmd_file = TRIM( LEFT( cmd_param, loc - 1 ) )

  *- grab command to execute
  cmd_run  = TRIM( SUBSTR( cmd_param, loc + 1, ( LEN( cmd_param ) - loc ) + 1 ) )

  ? "  file:     "+cmd_file
  ? "  command:  "+cmd_run

  *- locate file
  IF .NOT. FIND_FIRST( cmd_file, &find_anyfile )
    ? "  !ERROR:  file not found"
    ?
    QUIT 1
  ENDIF

  ?
  *- check date
  IF FIND_FDATE() = TODAY()
    ? "  !running command..."
    ?
    *- run command
    RUN cmd_run
  ELSE
    ? "  !filedate is not marked as today's date..."
  ENDIF

  ?

ENDPRO