*******************************************************************************
*                                                                             *
*                                DBF examples                                 *
*                                                                             *
*                              Jayson R. Minard                               *
*                                                                             *
*******************************************************************************


*- We need the following to prototype the DBF functions such as A_EOF()
#INCLUDE DATABASE.HDR

*- The following is needed for EXIST() function
#INCLUDE SYSTEM.HDR

*- The following is for UPPER() and other string functions
#INCLUDE STRING.HDR

*- The following is for GET_KEY() function
#INCLUDE IO.HDR

DBFDEF test_dbf
  CHAR( 10 ) field1
  INT( 4 )   field2
  LONG( 5 )  field3
  DBL( 8:2 ) field4
  LOGICAL    field5
  DATE       field6
  MEMO       field7
ENDDEF

*- Notice that the database alias 'test_dbf' is required in the right column
INDEXDEF
  CHAR( 10 )   i_field1     UPPER( test_dbf->field1 )
  CHAR( 9 )    i_field2_3   I_STR( test_dbf->field2 ) +;
                            STR( test_dbf->field3, 5, 0 )
  DATE         i_field6     test_dbf->field6
ENDDEF

PROCEDURE FORCE_MAIN
  CLEAR

  *****************************************************************************
  *            SECTION 1:  opening of database with error checking            *
  *****************************************************************************

  *- if the database doesn't exist, then create it...
  IF .NOT. EXIST( "test.dbf" )
    BUILD "test.dbf" FROM ALIAS test_dbf

    *- we might as well clean up the indexes since they will be invalid now...
    IF EXIST( "test1.fdx" )
      ERASE "test1.fdx"
    ENDIF

    IF EXIST( "test2.fdx" )
      ERASE "test2.fdx"
    ENDIF

    IF EXIST( "test3.fdx" )
      ERASE "test3.fdx"
    ENDIF

  ENDIF

  *- now open database since it should exist
  OPEN "test.dbf" ALIAS test_dbf

  *- assign a filename to each index:
  SET ALIAS i_field1   TO "test1.fdx"
  SET ALIAS i_field2_3 TO "test2.fdx"
  SET ALIAS i_field6   TO "test3.fdx"

  *- if our indexes don't exist then create them.  Notice the use of the
  *  alias override '!test_dbf' to signify which database is being indexed.

  IF .NOT. EXIST( "test1.fdx" )
    !test_dbf INDEX i_field1
  ENDIF

  IF .NOT. EXIST( "test2.fdx" )
    !test_dbf INDEX i_field2_3
  ENDIF

  IF .NOT. EXIST( "test3.fdx" )
    !test_dbf INDEX i_field6
  ENDIF

  *- now open indexes since they should now exist
  !test_dbf SET INDEX TO i_field1, i_field2_3, i_field6

  *****************************************************************************
  *                      SECTION 2:  scanning a database                      *
  *****************************************************************************


  IF ( A_RECCOUNT( test_dbf ) > 0 )

    !test_dbf SET ORDER TO 1
    !test_dbf GOTO TOP

    *- forward
    DO WHILE .NOT. A_EOF( test_dbf )
      ? test_dbf->field1
      !test_dbf SKIP
    ENDDO

    !test_dbf SET ORDER TO 3

    ?

    !test_dbf GOTO BOTTOM

    *- backward by a different index
    DO WHILE .NOT. A_BOF( test_dbf )
      ? test_dbf->field1
      !test_dbf SKIP -1
    ENDDO

    GET_KEY()

  ENDIF

  *****************************************************************************
  *              SECTION 3:  adding records with record locking               *
  *****************************************************************************

  !test_dbf SET ORDER TO 1
  !test_dbf APPEND BLANK

  !test_dbf REPLACE test_dbf->field1 WITH "Maddog"

  IF .NOT. A_RLOCK( test_dbf )
    ? "unable to lock new record..."
    QUIT 1
  ENDIF

  *- edit new record ONLY
  !test_dbf EDIT RECORD A_RECNO( test_dbf )

  *- now edit new record and allow edit of other records
  *  NOTE:  the WHILE clause is needed to start at the current record
  !test_dbf EDIT WHILE .T.

  UNLOCK
  CLEAR

  *****************************************************************************
  *                    SECTION 4:  searching for a record                     *
  *****************************************************************************

  *- NOTE:  our index is on the UPPERcase value of FIELD1.  So therefore
  *         we need to make sure that we search in uppercase.

  !test_dbf SEEK "JAYSON"
  IF FOUND()
    ? "record 'JAYSON' found, press any key..."
    GET_KEY()

    IF .NOT. A_RLOCK( test_dbf )
      ? "Unable to lock record..."
      QUIT 1
    ENDIF

    !test_dbf EDIT RECORD A_RECNO( test_dbf )
  ENDIF

  *****************************************************************************
  *                            SECTION 5:  closing                            *
  *****************************************************************************

  *- to close a database:
  CLOSE test_dbf

  *- or
  CLOSE ALL

  CLEAR
  QUIT 0
ENDPRO