*******************************************************************************
*                                                                             *
*                          AT() and string examples                           *
*                                                                             *
*                              Jayson R. Minard                               *
*                                                                             *
*******************************************************************************

*- We need the following header file for the AT() and other string functions.
#INCLUDE STRING.HDR

*- see if a string is empty or not...
FUNCTION LOGICAL EMPTY
  PARAMETERS CONST CHAR STR

  IF LEN( TRIM( STR ) ) = 0
    RETURN .T.
  ELSE
    RETURN .F.
  ENDIF

ENDPRO

*- returns .F. if the parameter is invalid
FUNCTION LOGICAL Process_Parameter
  PARAMETERS VALUE CHAR( 128 ) a_param

  ? "  "+a_param

  RETURN .T.
ENDPRO


PROCEDURE Force_MAIN
  PARAMETERS CONST CHAR( 128 ) dos_cmd_line

  *- 128 is the maximum you should ever use for the length.

  VARDEF
    CHAR( 128 )   cmd_line,;
                  temp_str
    UINT          marker1,;
                  marker2
    CHAR( 1 )     delimiter
  ENDDEF


  *- you should always immediately copy the command line since the DTA may
  *  be erased when doing some I/O operations
  cmd_line = TRIM( UPPER( dos_cmd_line ) )

  IF EMPTY( cmd_line )
    ? "Please specify command line parameters using a / or a -."
    ? "   ex.    AT /M -T /m -s -a2"
    ?
    ? "The parameters do not matter since this is just an example!"
    ?
    QUIT 1
  ENDIF


  *- find all command line parameters and remove them from command string
  *  since there may be something left that we need.
  ? "PARAMETERS:  "

  *- since we have multiple delimiters, we will use
  delimiter = "/"

  DO WHILE delimiter <> "*"
    marker1 = AT( delimiter, cmd_line )
    DO WHILE marker1 <> 0
    *- now find end of parameter

      temp_str = SUBSTR( cmd_line, marker1, ( LEN( cmd_line ) - marker1 ) + 1 )
      marker2 = AT( " ", temp_str )

      IF marker2 = 0
        marker2 = LEN( temp_str )
      ENDIF

      marker2 = marker2 - 1

      temp_str = TRIM( SUBSTR( cmd_line, marker1, marker2 ) )

      *- process the parameter
      IF .NOT. Process_Parameter( temp_str )
        ? "INVALID PARAMETER:  "+temp_str
      ENDIF

      *- now remove parameter from the command line string
      cmd_line = LEFT( cmd_line, marker1 - 1 ) +;
                 SUBSTR( cmd_line, marker1 + marker2, 128 )

      marker1 = AT( delimiter, cmd_line )
    ENDDO

    *- find other delimiters
    IF delimiter = "/"
      delimiter = "-"
    ELSE
      IF delimiter = "-"
        delimiter = "*"
      ENDIF

    ENDIF

  ENDDO

  cmd_line = TRIM( cmd_line )

  ?
  ? "Left over from the command line is:"
  ? "  "+cmd_line
  ?

  QUIT 0

ENDPRO