*******************************************************************************
*                                                                             *
*                                  JayCount                                   *
*                                                                             *
*                          (c) 1991 Jayson R. Minard                          *
*                                                                             *
*                          Program/text line counter                          *
*                                                                             *
*******************************************************************************

*******************************************************************************
*                                Header files                                 *
*******************************************************************************

#INCLUDE FILEIO.HDR
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE STRING.HDR
#INCLUDE MATH.HDR
#INCLUDE COLORS.HDR

VARDEF EXTERN
  BYTE __color_std
ENDDEF

*******************************************************************************
*                             FUNCTION FixPath()                              *
*******************************************************************************

FUNCTION CHAR Fixpath
  PARAMETERS VALUE CHAR filespec

  *****!!!! NOTE:  this is designed for fixing PATHS and not full filenames.
  *                ex.  FILE.EXE will be changed to C:\FILE.EXE\ since this
  *                     function will assume it is a path

  VARDEF
    CHAR   final_spec based filespec
    CHAR   other_spec
  ENDDEF

  final_spec = TRIM( final_spec )

  IF LEN( final_spec ) = 0
    final_spec = CHR( CURDRIVE() + 'A' ) + ":" + CURDIR( 0 )
  ELSE
    IF LEFT( final_spec, 2 ) = ".\"
      final_spec = Fixpath( "" ) + SUBSTR( final_spec, 3, LEN( final_spec )-2 )
    ELSE
      IF LEFT( final_spec, 3 )="..\"
        other_spec = TRIM( Fixpath( "" ) )
        DO WHILE LEFT( final_spec, 3 ) = "..\"
          final_spec = TRIM( SUBSTR( final_spec, 4, LEN( final_spec )-3 ) )
          IF LEN( other_spec )>2
            IF RIGHT( other_spec, 1 ) = "\"
              other_spec = LEFT( other_spec, LEN( other_spec )-1 )
            ENDIF

            IF RAT( "\", other_spec )>0
              other_spec = LEFT( other_spec, RAT( "\", other_spec )-1 )
            ENDIF

          ENDIF

        ENDDO

        IF RIGHT( other_spec, 1 ) <> "\"
          other_spec = other_spec + "\"
          final_spec = other_spec + final_spec
        ENDIF

      ENDIF

    ENDIF

  ENDIF

  IF .NOT. ( SUBSTR( final_spec, 2, 1 ) = ":" )
    IF SUBSTR( final_spec, 1, 1 ) = "\"
      final_spec = CHR( CURDRIVE() + 'A' ) + ":" + final_spec
    ELSE
      final_spec = CHR( CURDRIVE() + 'A' ) + ":\" + final_spec
    ENDIF

  ELSE
    IF LEN( final_spec ) = 2
      final_spec = final_spec + "\"
    ENDIF

  ENDIF

  IF .NOT. ( SUBSTR( final_spec, LEN( final_spec ), 1 ) = "\" )
    final_spec = final_spec + "\"
  ENDIF

  final_spec = TRIM( final_spec )

  RETURN final_spec
ENDPRO                                 && FUNCTION CHAR FixPath

*******************************************************************************
*                            FUNCTION Line_Count()                            *
*******************************************************************************

FUNCTION ULONG Line_Count
  PARAMETERS CONST CHAR( 128 ) one_file,;
             VALUE LOGICAL blanks,;
             VALUE LOGICAL comments

  VARDEF
    FILE       in_file
    ULONG      temp
    CHAR       one_line
  ENDDEF

  temp = 0

  IF .NOT. F_OPEN( in_file, one_file, &f_read )
    ?? "...  CANNOT OPEN FILE"
    RETURN temp
  ENDIF

  DO WHILE .NOT. F_EOF( in_file )
    F_GETLN( in_file, one_line )
    DO CASE
      CASE ( LEN( TRIM( one_line ) ) = 0 ) .AND. .NOT. blanks
      CASE ( LEFT( TRIM( one_line ), 1 ) = "*" ) .AND. .NOT. comments
      CASE ( LEFT( TRIM( one_line ), 1 ) = ";" ) .AND. .NOT. comments
      CASE ( UPPER( LEFT( TRIM( one_line ), 4 ) ) = "REM " ) .AND. .NOT. comments
      OTHERWISE
        temp = temp + 1
    ENDCASE

  ENDDO

  F_CLOSE( in_file )
  RETURN temp
ENDPRO

*******************************************************************************
*-----------------------------------------------------------------------------*
*                                 FORCE_MAIN                                  *
*-----------------------------------------------------------------------------*
*******************************************************************************

PROCEDURE Force_Main
  PARAMETERS CONST CHAR( 128 ) command_line

  VARDEF
    CHAR( 128 ) one_file
    CHAR( 128 ) one_path
    CHAR        cmd_line
    LOGICAL     blanks
    LOGICAL     comments
    ULONG       temp
    ULONG       lines
    UINT        files
  ENDDEF

  temp = 0
  lines = 0
  files = 0

  *- go through DOS so this can be redirected

  SCRN_DIRECT()
  __color_std = &black_light_cyan

  ? "JayCount - Program line counter (c) 1991 Jayson R. Minard"
  __color_std = &black_cyan
  ? "------------------------------------------------------------------------------"
  __color_std = &black_white
  ?
  SCRN_DOS()
  cmd_line = UPPER( TRIM( command_line ) )

  *- Check for /B parameter (eliminate BLANK LINE count)

  IF AT( "/B", cmd_line )>0
    blanks = .F.
    cmd_line = LEFT( cmd_line, AT( "/B", cmd_line )-1 ) +;
               SUBSTR( cmd_line, AT( "/B", cmd_line )+2, LEN( cmd_line ) )
  ELSE
    blanks = .T.
  ENDIF

  *- Check for /C parameter (eliminate comment count)

  IF AT( "/C", cmd_line )>0
    comments = .F.
    cmd_line = LEFT( cmd_line, AT( "/C", cmd_line )-1 ) +;
               SUBSTR( cmd_line, AT( "/C", cmd_line )+2, LEN( cmd_line ) )
  ELSE
    comments = .T.
  ENDIF

  *- if no parameters present, or no filenames, show HELP

  IF ( LEN( cmd_line ) = 0 ) .OR. ( AT( "/H", cmd_line )>0 ) .OR.;
           ( AT( "/?", cmd_line )>0 )
    ? "     Usage:    JCOUNT [options] filespec [filespec [filespec [...]]]"
    ?
    ? "     Options: "
    ? "         /H    help"
    ? "         /?    help"
    ? "         /B    DON'T count blank lines"
    ? "         /C    DON'T count comments {* ; REM}"
    ?
    ? "     Examples: "
    ? "         JCOUNT /B *.PRG J??AZ.BAT "
    ? "         JCOUNT TEST.PRG"
    ? "         JCOUNT TEST          { .PRG assumed }"
    ?
    QUIT 0
  ENDIF

  *- add extra space on command line so that we can search for a space
  *  and parse the string based upon a series of words seperated by spaces.

  cmd_line = cmd_line + " "
  DO WHILE AT( " ", cmd_line )>0

    *- grab first word

    one_file = TRIM( LEFT( cmd_line, AT( " ", cmd_line ) ) )

    *- remove first word from command line

    cmd_line = LTRIM( RIGHT( cmd_line, LEN( cmd_line ) - AT( " ", cmd_line ) ) )

    *- does this filespec even exist?

    IF AT( ".", one_file ) = 0
      one_file = TRIM( one_file ) + ".PRG"
    ENDIF

    IF .NOT. FIND_FIRST( one_file, 0x20 )
      ? "  Filespec:  "+one_file
      ?? "...  NOT FOUND"
      LOOP
    ENDIF

    *- if it is a wild-card, display the spec.

    IF ( AT( "*", one_file )>0 ) .OR. ( AT( "?", one_file )>0 )
      ? "  Filespec:  "+one_file
    ENDIF

    *- if it contains a path, grab it so that we can add it back to the
    *  name returned from FIND_FSTR() later

    IF RAT( "\", one_file )>0
      one_path = FixPath( LEFT( one_file, RAT( "\", one_file ) ) )
    ELSE
      one_path = FixPath( "" )
    ENDIF

    REPEAT

      one_file = one_path+TRIM( FIND_FSTR() )
      ? "    Filename:  "+one_file
      files = files + 1

      *- count the lines

      temp = Line_Count( one_file, blanks, comments )

      *- if temp is 0 then there was an error or an empty file

      IF temp > 0
        ?? "...  "+TRIM( STR( temp, 8, 0 ) )+" lines"
      ENDIF

      *- keep the total

      lines = lines + temp

    UNTIL .NOT. FIND_NEXT()

    ?

  ENDDO

  *- show the total

  ? "  TOTAL Lines:  "+TRIM( STR( lines, 8, 0 ) )
  ? "  TOTAL Files:  "+TRIM( STR( files, 8, 0 ) )
  ?
  QUIT 0

ENDPRO