*******************************************************************************
*                                                                             *
*                             BITTEST() examples                              *
*                                                                             *
*                              Jayson R. Minard                               *
*                                                                             *
*******************************************************************************

*- The following header is required for BITTEST()
#INCLUDE MATH.HDR

*- The following is for FILL()
#INCLUDE STRING.HDR

*- The following is for GET_KEY() to pause at the end of the demo
#INCLUDE IO.HDR

*******************************************************************************
* The following procedure takes the coordinates of a box and expands them
* to include the shadow for the FILL command.  FILL does not add extra
* spaces to incorporate the shadow, it must be done manually.
*
*  ex.  A box that will contain one line of text is a 3 space tall box.
*       yet the programmer must make it 4 to include the shadow on the
*       bottom.
*
* This procedure adjusts the coordinates depending on which side the actual
* shadow is on.  This is calculated using BITTEST on the 'shadow_value'
* parameter.
*
* The parameters of this procedure are the same as FILL
*******************************************************************************

PROCEDURE BoxFill
  PARAMETERS VALUE INT upper_row,;
             VALUE INT upper_col,;
             VALUE INT lower_row,;
             VALUE INT lower_col,;
             CONST CHAR border,;
             CONST CHAR fill_chars,;
             VALUE INT border_color,;
             VALUE INT fill_color,;
             VALUE INT shadow_value

  *- top bit
  IF BITTEST( shadow_value, 0 )
    upper_row = upper_row - 1
  ENDIF

  *- right bit
  IF BITTEST( shadow_value, 1 )
    lower_col = lower_col + 1
  ENDIF

  *- bottom bit
  IF BITTEST( shadow_value, 2 )
    lower_row = lower_row + 1
  ENDIF

  *- left bit
  IF BITTEST( shadow_value, 3 )
    upper_col = upper_col - 1
  ENDIF

  FILL( upper_row, upper_col, lower_row, lower_col,;
        border, fill_chars, border_color, fill_color, shadow_value )

ENDPRO

PROCEDURE FORCE_MAIN

  CLEAR

  * draw background so that shadow can be seen
  FILL( 0, 0, 24, 79, "", "", 15, 15, 0 )

  * draw boxes

  *- right and bottom shadow
  BoxFill( 1, 2, 3, 40, &single_box, " ", 11, 11, 6 )

  *- left and bottom
  BoxFill( 7, 2, 9, 40, &double_box, " ", 11, 11, 12 )

  GET_KEY()
  CLEAR

ENDPRO