*-------------------------------------------------------------------------------
*-- Program.....: SELECT.PRG
*-- Programmer..: Lena Tjandra (Ashton-Tate)
*-- Date........: 06/03/1992
*-- Notes.......: Taken from Technotes (Ashton-Tate) TN9103. This procedure is
*--               is a modified version of the popup routine in the article
*--               "Betcha Can't Pick Just One" by Lena Tjandra. It requires that
*--               the database file used has a logical field that is used 
*--               specifically for this procedure. When the popup appears on
*--               the screen, a list of whatever field you want is shown,
*--               and you can choose from the list multiple records. These
*--               then have the logical field set to .T. You can then do what
*--               is needed with the selected items. It is a good idea to
*--               turn the flag off when done. 
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: Ken Mayer, 07/24/1991 -- to dUFLP the routines, and add
*--               some more functionality. This version was hard-coded.
*--               There is a line early on that turns off the SELECT field
*--               for all records -- if you do not wish this routine to do
*--               this, comment the line out.
*--               06/03/1992 -- Ken Mayer -- modified to allow parameters
*--               rather than hard-coding (black-box). I based a lot of this
*--               on Martin Leon's DIYPOPUP routine (PICKLIST.PRG).
*-- Usage.......: do select with <cFields>,<nULRow>,<nULCol>,<nBRRow>,<nBRCol>,;
*--                              <cNormColor>,<cFieldColor>,<cBorder>
*-- Example.....: USE <dbf> ORDER <field>
*--               do select with "chr(179)+LastName + chr(179)+FirstName",;
*--                          6,15,15,60,"rg+/gb","w+/b","DOUBLE"
*--                 *-- above command should display popup, allow you to select
*--                 *-- the records you need ... when done do SOMETHING with 'em.
*--               REPORT FORM <form> FOR <logicalfield>
*-- Returns.....: Changes the SELECT field of each record to .T. when
*--               the user presses <Enter>.
*-- Parameters..: cFields     = Fields to be displayed in picklist
*--               nULRow      = Row coordinates for upper left corner
*--               nULCol      = Column coordinates for same
*--               nBRRow      = Row coordinates for bottom right corner
*--               nBRCol      = Column coordinates for same
*--               cNormColor  = Foreground/Background of normal text (the
*--                              text not currently selected)
*--               cFieldColor = Foreground/Background of highlighted fields
*--               cBorder     = NONE,SINGLE,DOUBLE (defaults to single if sent
*--                               as a nul string)
*-------------------------------------------------------------------------------

	parameters cFields,nULRow,nULCol,nBRRow,nBRCol,cNormColor,cFieldColor,;
	           cBorder

	*-- Environment
	cCursor = set("CURSOR")
	cEscape = set("ESCAPE")
	cTalk   = set("TALK")
	set cursor off
	set escape off
	set talk off
	
	*-- save colors
	cMessages  = colorof("MESS")
	cBox       = colorof("BOX")
	cHighlight = colorof("HIGH")
	
	*-- if colors were provided, set to colors passed on ...
	if len(cNormColor) > 0
		set color of messages to &cNormColor
		set color of box      to &cNormColor
	endif
	if len(cFieldColor) > 0
		set color of highlight to &cFieldColor
	endif
	
	*-- save the screen so we can return it ...
	save screen to sSelect
	
	*-- display a message -- useful if database is large ...
	@23,26 say "... Setting up picklist ..." color &cNormColor
	
	*-- Border
	cBorderSet = set("BORDER")
	if len(Trim(cBorder)) = 0
		cBorder = "NONE"
	endif
	set border to &cBorder
	
	*-----------------------------------------------------------------------
	*-- clear out the SELECT field ...
	*-- If you do not wish this to occur, you should comment this line out.
	*-----------------------------------------------------------------------
	replace all SELECT with .F.
	
	*-- define a couple of keystrokes
	nEscape = 27
	cdown   = chr(24)
	
	*-- define the popup
	Define popup pPop1 from nULRow,nULCol to nBRRow, nBRCol;
		message ;
"<Enter> = select/deselect, <F10> Selects all, <F9> Deselects all, <Esc> = Done"
	nBarCount = 1
	
	*-- define the bars of the popup, including the SELECT field
	go top
	scan
		define bar nBarCount of pPop1 prompt iif(SELECT,chr(16)," ")+&cFields
		nBarCount = nBarCount + 1
	endscan
	
	*-- define popup action
	on selection popup pPop1 do Pselect
	
	*-- define hotkey <F10> for selecting ALL options
	on key label f10 do sel_all with .t.
	
	*-- define hotkey <F9> for DEselecting all options
	on key label f9 do sel_all with .f.
	
	*-- clear out message
	restore screen from sSelect
	
	*-- shadow this puppy ... -- add two to width, and one to height
	@nULRow+1,nULCol+2 fill to nBRRow+1,nBRCol+2 color n+/n
	
	*-- activate popup
	do while lastkey() # nEscape
		show popup pPop1
		activate popup pPop1
	enddo
	
	*-- restore environment
	set color of messages  to &cMessages
	set color of box       to &cBox
	set color of highlight to &cHighlight
	set cursor &cCursor
	set escape &cEscape
	set talk &cTalk
	set border to &cBorderSet
	restore screen from sSelect
	release screen sSelect
	
RETURN
*-- end of procedure SELECT

*-------------------------------------------------------------------------------

PROCEDURE pSelect
*-- procedure to handle selection ...

	*-- redefine bar based on selection/de-selection
	define bar bar() of pPop1 ;
		prompt iif(left(prompt(),1) = chr(16),;
			" "+substr(prompt(),2,len(prompt())-1),;
			chr(16)+substr(prompt(),2,len(prompt())-1))
	
	*-- change the selected field to .t. if option has been selected, or .f.
	*-- if option has been deselected
	
	go top
	skip bar() - 1
	replace select with iif(select,.f.,.t.)
	
	*-- move highlight in popup down to the next option
	KEYBOARD cdown
	
RETURN
*-- EoP: pSelect

*--------------------------------------------------------------------------

PROCEDURE Sel_All
*-- procedure to handle selection/de-selection of ALL items in list ...

	parameter lkey
	
	*-- change all values in the select field ...
	replace all select with lkey
	
	nBarCount = 1
	
	*-- redefine the bars of the popup ...
	scan
		define bar nBarCount of pPop1 prompt iif(select,chr(16)," ")+&cFields
		nBarCount = nBarCount + 1
	endscan
	
	deactivate popup

RETURN
*-- EoP: Sel_All

FUNCTION ColorOf
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (JPARSONS)
*-- Date........: 01/11/1992
*-- Notes.......: This function will return the color of a specified area
*--               (as built in to dBASE). 
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: (06/03/1992 - Took out ALLTRIM()
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: ColorOf("<cArea>")
*-- Example.....: ?ColorOf("Messages")
*-- Returns.....: Color (foreground/background)
*-- Parameters..: cArea = Area you wish to return the color of from list:
*--               BOX/BOXES        = Boxes
*--               BORDER/PERIMETER = Border color
*--               NORMAL           = Normal screen/text
*--               HIGHLIGHT        = Highlights
*--               MESSAGE          = Messages
*--               TITLE            = Titles
*--               INFORMATION      = Information
*--               FIELDS           = Fields
*-------------------------------------------------------------------------------

	parameters cArea
	
	private cAttrib, cWanted, nPos
	
	cAttrib = set("ATTRIBUTES")
	cWanted = upper(ltrim(trim(cArea)))
	
	if cWanted = "BOX"
		nPos = 6
	else
		nPos = at(left(cWanted,4),;
			"    NORM HIGH PERI MESS TITL BOXE INFO FIEL BORD") / 5
		if nPos = 9
			nPos = 3    && "Border" = "Perimeter"
		endif
	endif
	
	do case
		case nPos = 0
			cAttrib = ""  && return null string for error
		case nPos < 4
			cAttrib = left(cAttrib,at("&",cAttrib) - 2)
		otherwise
			cAttrib = substr(cAttrib,at("&",cAttrib) + 3)
			nPos = nPos - 3
	endcase
	do while nPos > 1
		cAttrib = substr(cAttrib,at(",",cAttrib) + 1)
		nPos = nPos - 1
	enddo
	
RETURN left(cAttrib,at(",",cAttrib+",")-1)
*-- EoF: ColorOf()

*-------------------------------------------------------------------------------
*-- End of Program: SELECT.PRG
*-------------------------------------------------------------------------------
