FUNCTION Recompile
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (Jparsons)
*--             : Adapted from Compall.prg and Compall2.prg, by James Thomas.
*-- Date........: 04/13/1992
*-- Notes.......: Recompiles all dBASE source-code files.  Takes three
*--             : optional parameters:
*--             :    Directory to recompile.  Default is current directory.
*--             :    Skeleton to recompile.  Default is all of .PRG, .LBG,
*--             :       .FRG, .PRS, .FMT, .QBE and .UPD files.  If a skeleton
*--             :       is provided that matches files that are not dBASE
*--             :       source-code files, compiler errors will occur and,
*--             :       in the absence of external error handling, see below,
*--             :       suspend processing.
*--             :    "Runtime" or any characters starting with "R" or "r" to
*--             :        direct the compilation be with the "RUNTIME" option.
*--             : Does not recompile a file if a file of the same root name,
*--             : an .??O extension and a later timestamp resides in the
*--             : directory.
*--             : Renames compilations of FMT, FRG, LBG and QBO files to ??O.
*--             : Returns .T. if successful, or .F.
*--             :
*--             : Listing of compilation errors requires SET ALTERNATE TO,
*--             : and trapping such errors as passing the name of a file
*--             : that does not contain dBASE source code to the COMPILE
*--             : command requires an ON ERROR trap.  These are omitted here
*--             : due to lack of ways to prevent the function from changing
*--             : these settings externally.  Lines needed to have any
*--             : compilation errors print to the alternate file are included
*--             : as comments.
*--             :
*-- Written for.: dBASE IV Version 1.5.
*--             : Adaptation to a prior release may require changing the
*--             : way parameters are handled, and also rewriting the lines
*--             : that use fdate() and ftime() to read timestamps.
*-- Rev. History: Original function written 4/7/1992
*--             : Additional environment settings added 4/13/1992
*-- Calls       : Makestru()  && accompanying modified version is required
*-- Called by...: Any
*-- Usage.......: Recompile ( [<cDir>] [,<cSkel> [,"R"]] )
*-- Example.....: ? Recompile ( "\dBASE\Myprogs", "*.??G" )
*-- Parameters..: cDir, a DOS directory name ( and path if needed )
*--             : cSkel, skeleton using wildcards for files to compile
*--             : cRun, "R" or "r" if compilation is for Runtime
*-- Side effects: Creates compiled .??O files, overwriting any of the same
*--             : root names that may exist.
*-------------------------------------------------------------------------------
PARAMETERS cDirectry, cSkeleton, cRun
PRIVATE cCons, cAlias, cAlt, cDir, cSafety, cTempfile,;
    cSrcfile, cObjfile, cString1, cString2, cRunopt

* preserve environment
cCons = set( "CONSOLE" )
SET CONSOLE OFF
cAlias = alias()
cAlt = set( "ALTERNATE" )
SET ALTERNATE OFF
cDir = set( "DIRECTORY" )
IF type( "cDirectry" ) = "C" .AND. "" # cDirectry
  SET DIRECTORY TO &cDirectry
ENDIF
cSafety = set( "SAFETY" )
SET SAFETY OFF
SELECT select()

* make temporary structure file and fill in the DOS DIR listing structure
cTempfile = Makestru()
USE ( cTempfile )
APPEND BLANK
REPLACE FIELD_NAME WITH "FILENAME", FIELD_TYPE WITH "C", FIELD_LEN WITH 9, ;
        FIELD_DEC WITH 0, FIELD_IDX WITH "N"
APPEND BLANK
REPLACE FIELD_NAME WITH "EXT", FIELD_TYPE WITH "C", FIELD_LEN WITH 4, ;
        FIELD_DEC WITH 0, FIELD_IDX WITH "N"
APPEND BLANK
REPLACE FIELD_NAME WITH "FLENGTH", FIELD_TYPE WITH "C", FIELD_LEN WITH 10, ;
        FIELD_DEC WITH 0, FIELD_IDX WITH "N"
APPEND BLANK
REPLACE FIELD_NAME WITH "TIMESTAMP", FIELD_TYPE WITH "C", FIELD_LEN WITH 16, ;
        FIELD_DEC WITH 0, FIELD_IDX WITH "N"

* make .dbf for source file names, reset and return if error occurs
cSrcfile = cTempfile
DO WHILE file ( cSrcfile + ".DBF" )
  cSrcfile  = "TMP" + ltrim( str( rand() * 100000, 5 ) )
ENDDO
CREATE ( cSrcfile ) FROM ( cTempfile )
IF "" = alias()
  ERASE ( cTempfile +".DBF" )
  SET DIRECTORY TO &cDir
  SET ALTERNATE &cAlt
  IF "" # cAlias
    SELECT ( cAlias )
  ENDIF
  SET CONSOLE &cCons
  RETURN .F.
ENDIF

* and for object file names
SELECT select()
USE ( cTempfile )
GO 1
REPLACE FIELD_IDX WITH "Y"
cObjfile = cSrcfile
DO WHILE file ( cObjfile + ".DBF"  )
  cObjfile  = "TMP" + ltrim( str( rand() * 100000, 5 ) )
ENDDO
CREATE ( cObjfile ) FROM ( cTempfile )
IF "" = alias()
  ERASE ( cTempfile + ".DBF" )
  SELECT ( cSrcfile )
  USE
  ERASE ( cSrcfile + ".DBF" )
  SET DIRECTORY TO &cDir
  SET ALTERNATE &cAlt
  IF "" # cAlias
    SELECT  ( cAlias )
  ENDIF
  SET CONSOLE &cCons
  RETURN .F.
ENDIF

* reuse name of cTempfile as SDF; DIR names of source files to it and append
cString1 = cTempfile + ".DBF"
RUN dir *.* > &cString1
SELECT ( cSrcfile )
APPEND FROM ( cString1 ) TYPE SDF

* delete directory entries not for source files of desired name or type
IF type("cSkeleton") = "C" .AND. "" # cSkeleton
  DELETE ALL FOR .NOT. like( upper( cSkeleton ), trim( Filename ) +"." ;
        + trim( Ext ) )
ELSE
  DELETE ALL FOR .NOT. Ext $ "PRG LBG FRG PRS FMT QBE UPD "
ENDIF
PACK

* reuse again for .??O files
RUN dir *.??o > &cString1
SELECT ( cObjfile )
APPEND FROM ( cString1 ) TYPE SDF
DELETE ALL FOR left( Filename, 1 ) = " " .OR. right( Ext, 2 ) # "O "
PACK
ERASE ( cString1 )

* assemble Runtime option
cRunopt = iif( type( "cRun" ) = "C" .AND. "" # cRun ;
        .AND. left( cRun, 1 ) $ "Rr", " RUNTIME", "" )

* now compile all the files that need it
SELECT ( cSrcfile )
SCAN
  cString1 = trim( Filename ) + "." + trim( Ext )
*   Is there an object file of this name?
  IF  Seek( Filename, ( cObjfile ) )
    SELECT ( cObjfile )
    cString2 = trim( Filename ) + "." + trim( Ext )
    cString2 = dtos( fdate( cString2 ) ) + ftime( cString2 )
    SELECT ( cSrcfile )
*   then check timestamps and skip it if already compiled
    IF dtos( fdate( cString1 ) ) + ftime( cString1 ) < cString2
      LOOP
    ENDIF
  ENDIF
*   compile it otherwise, listing errors if enabled
  cString2 = cString1 + cRunopt
* SET ALTERNATE ON
* ? "Compiling " + cString2
  COMPILE &cString2
* ?
* SET ALTERNATE OFF
*   and rename object files that should not be .DBOs
  IF Ext $ "FMT FRG LBG QBE "
    cString2 = stuff( cString1, len( cString1 ), 1, "O" )
    IF file( cString2 )
      ERASE ( cString2 )
    ENDIF
    cString1 = trim( Filename ) + ".DBO"
    RENAME ( cString1 ) TO ( cString2 )
  ENDIF
ENDSCAN

*  Clean up
USE
ERASE ( cSrcfile + ".DBF" )
SELECT ( cObjfile )
USE
ERASE ( cObjfile + ".DBF" )
ERASE ( cObjfile + ".MDX" )
SET SAFETY &cSafety
SET DIRECTORY TO &cDir
SET ALTERNATE &cAlt
IF "" # cAlias
  SELECT ( cAlias )
ENDIF
SET CONSOLE &cCons
RETURN .T.
*-- Eof() Recompile

FUNCTION Makestru
*-------------------------------------------------------------------------------
*-- Programmer..: Martin Leon (Hman), formerly sysop of A-T BBS
*--             : Revised by Jay Parsons, (Jparsons).
*-- Date........: 04/10/1992
*-- Notes.......: Makes an empty dBASE STRUCTURE EXTENDED file and returns
*--             : its root name
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: Original function published 6-12-1991.
*--             : Changed to take no parameter, return filename, 4-7-1992.
*--             : Code added to preserve catalog status and name, 4-10-1992.
*-- Calls       : None
*-- Called by...: Any
*-- Usage.......: Makestru()
*-- Example.....: Tempfile = Makestru()
*-- Returns.....: Name of file created
*-- Parameters..: None
*-------------------------------------------------------------------------------
PRIVATE cCatfile, cCatstat, cTitle, cAlias, cConsole, cStruname, cNewcat

* Preserve work area and environment
cCatfile = catalog()
cCatstat = set("CATALOG")
cTitle = set("TITLE")
SET TITLE OFF                   && Otherwise we get ugly question box
cAlias = Alias()
SELECT select()

* Create needed files
cStruname = "TMP" + ltrim( str( rand( -1 ) * 100000, 5 ) )
DO WHILE FILE( cStruname +".DBF" )
  cStruname  = "TMP" + ltrim( str( rand() * 100000, 5 ) )
ENDDO
cNewcat = cStruname + ".CAT"
DO WHILE FILE( cNewcat )
  cNewcat  = "TMP" + ltrim( str( rand() * 100000, 5 ) ) + ".CAT"
ENDDO

* Create .dbf by the SET CATALOG command, copy structure and kill it
SET CATALOG TO ( cNewcat)
SET CATALOG TO
USE ( cNewcat) NOSAVE
COPY STRUCTURE EXTENDED TO ( cStruname )

* remove the records relating to the catalog from the structure file
USE ( cStruname) EXCLUSIVE
ZAP
USE

IF "" # cAlias
  SELECT ( cAlias )
ENDIF
SET TITLE &cTitle
IF "" # cCatfile
  SET CATALOG TO ( cCatfile )
ELSE
  SET CATALOG TO
ENDIF
SET CATALOG &cCatstat
RETURN cStruname
*-- Eof() Makestru

FUNCTION Stampval
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (Jparsons)
*-- Date........: 04/07/1992
*-- Notes.......: Passed a 16-character string in the form of the rightmost
*--             : 16 characters returned by the DOS DIR command for a file,
*--             : returns a number that will compare properly in date/time
*--             : order with the numbers returned by this function for other
*--             : files.
*-- Written for.: dBASE III+ and dBASE IV Versions below 1.5
*-- Rev. History: None
*-- Calls       : None
*-- Called by...: Any
*-- Usage.......: Stampval(<cTimestamp>)
*-- Example.....: IF Stampval("02-22-92  10:54a") > Stampval("04-05-92   5:54p")
*-- Returns.....: Numeric corresponding to time stamp of file
*-- Parameters..: cStamp, a DIR timestamp
*-------------------------------------------------------------------------------
PARAMETERS cStamp
RETURN 1440 * ( 12 * val( left(cStamp,2)) + val(substr(cStamp,4,2)) ;
    + 372*val(substr(cStamp,7,2)) ) + 60 * val(substr(cStamp,11,2)) ;
    + val(substr(Cstamp,14,2)) + iif(right(cStamp,1)="p",720,0)
*--Eof() Stampval
