 prtMemo.prg                                                    F+PRFOX+           T@٩TA                       D  * Procedure - prtMemo.prg
*----------------------------------------------------------
*
*	This procedure read data from a memo field displayed on
* 	a screen and prints it to the printer. It assumes that
*	all the print calls have already taken place.
*
*	Called with - DO prtMemo WITH "xx_memo"
*
*	This routine is only useful when printing out a report 
* 	when not using the report format built into FoxBase+
*
*	It is based on code from XMEMO.prg 
*	by J. Randolph Brown, CompuServe: 71141,3014
*	and uses his two memo XCMDs(XMEMOLEN,XMEMOEXT).
*
*	I am very thankful for him providing these XCMDs.
*
*	This code improves upon his sample code by handling
*	multiple spaces between the last word on a line and
*	a carriage return and multiple carriage returns. It
*	also has a simple word wrap routine so words are not
*	broken.
*
*	I know with FoxPro also here, this may not be useful 
*	much longer, especially if it has the same memo handling
*	routines that FoxPro for windows does. You still have to
*	get the number of lines, but you do not have to be concern
*	with extra spaces, carriage returns, or breaking words.
*
*	Other than the restictions placed on the two XCMDs by
*	J. Randolph Brown, I place no restrictions on the use
*	of this code, except that no one may copyright for the
*	purpose of preventing others from using this code.
*
*	Jim Watson 08 Jan 1994
* 
*----------------------------------------------------------


PARAMETER memofld

PRIVATE    lastele
STORE 0 TO lastele

LOAD XMEMOLEN
LOAD XMEMOEXT

*----------------------------------------------------------
*	Gather information about the size of the memo field and
*	the actual text contained within. Store the text into
*	an array called content
*----------------------------------------------------------

STORE 75 TO chunklen
CALL XMEMOLEN to chunkNum with memofld
maxChunk = INT(VAL(chunkNum)/chunklen) + 1
ptrChunk = (INT(VAL(chunkNum)/75) + 1) * 2 + 20
	
DIMENSION content(maxChunk)
STORE 0 to n
DO WHILE n <> maxChunk
	n = n + 1
	CALL XMEMOEXT to content(n) WITH memofld,n,chunklen
	lastele = n
ENDDO

DIMENSION printstr(ptrChunk)

*----------------------------------------------------------
*	Now process the chunks of information stored in the array
*	content into a second array called printstr. Each element
*	of this array contains one line of text to be printed.
*----------------------------------------------------------

IF VAL(chunkNum) > 0

	done = .F.
	STORE 0 to p, strPosition
	STORE 1 TO n
	STORE "" TO tempStr, memoChar

	DO WHILE .NOT. done
		STORE 1 TO start
		DO WHILE start <= 75
			memoChar = SUBSTR( content(n), strPosition, 1 )

			strPosition = strPosition + 1
			IF n <> lastele
				IF strPosition > chunklen
					n = n + 1
					strPosition = 0
				ENDIF
			ELSE
				IF strPosition > LEN(content(lastele))
					done = .T.
					start = 80
				ENDIF
			ENDIF

			IF ASC(memoChar) = 13 .OR. ASC(memoChar) = 10
				start = 80
			ELSE
				start = start + 1
			ENDIF
				tempStr = tempStr + memoChar
		ENDDO
		p = p + 1

*----------------------------------------------------------
*	Now detemine if some of the text stored in the printstr
*	element needs to be moved to the next printstr element
*	preventing the breaking of a word in half. Also determine
*	if there are multiple spaces and carriage returns that 
*	need to be processed.
*----------------------------------------------------------

		endofStr = LEN(tempStr)
		IF ASC(SUBSTR(tempStr,endofStr,1)) = 13 .OR.;
			ASC(SUBSTR(tempStr,endofStr,1)) = 10 .OR.;
			ASC(SUBSTR(tempStr,endofStr,1)) = 32

			printStr(p) = tempStr
			tempStr = ""
		ELSE
			IF .NOT. done
				blankStr = .F.
				STORE 0 TO moveCnt

				DO WHILE .NOT. blankStr
					memoChar = SUBSTR( tempStr, endofStr -1, 1 )
					IF memoChar == " " .OR. endofStr <= 1
						blankStr = .T.
					ENDIF
					moveCnt = moveCnt + 1
					endofStr = endofStr - 1
				ENDDO

				moveCnt = moveCnt + 1
				IF moveCnt > 1
					printStr(p) = SUBSTR(tempStr,1,endofStr)
					tempStr = SUBSTR(tempStr,endofStr,moveCnt)
					IF SUBSTR(tempStr,1,1) = " "
						tempStr = SUBSTR(tempStr,2,moveCnt-1)
					ENDIF
				ELSE
					printStr(p) = tempStr
					tempStr = ""
				ENDIF
			ELSE
				printStr(p) = tempStr
			ENDIF
		ENDIF

	ENDDO
	ptrChunk = p

*----------------------------------------------------------
*	Now print the memo information. If the end of the printed
*	page is reached, print the footer information, the next
*	page header information and the title of the memo field.
*----------------------------------------------------------

	STORE 0 to n
	DO WHILE n <> ptrChunk
		n = n + 1
		@ PROW()+1,21 SAY printstr(n) FONT "Geneva",9 SIZE 4,80
		IF PROW() >= pgLine
			DO FOOTER WITH PAGENO, .F.
			DO HEADER WITH PAGENO, .T.
			@ PIXELS PROW(1)+28,40 SAY "Comments:";
				STYLE 65536  FONT "Geneva",9 
			@ PIXELS PROW(1) + 5,40 TO PROW(1) + 5,540;
				STYLE 31 COLOR 0,0,0,0,0,0
		ENDIF
	ENDDO
ELSE
	@ PROW()+1,21 SAY "None found in the database." FONT "Geneva",9 SIZE 2,80
ENDIF

RELEASE content
RELEASE printstr
RELEASE MODULE XMEMOLEN
RELEASE MODULE XMEMOEXT

RETURN

* EOF prtMemo.prg          :  
:   n 	6, a 	5 |    prtMemo.prg   F+PRFOX+          F+PRFOX+                        T@         G      }      ñ      I      M      	5      O    _  o        4  5 J l ,XMEMOLEN,XMEMOEXTJKl 
XMEMOLENl t  T xx r E T xx rKE  J l s  T  (
XMEMOEXTl  t    T    
%x r 	T	 J l
  Jl J l 
 	s	 
Jl s KT
 xx   iT  %  %  T  T  % xx  G	T	 T P%x
 

x
 
T PT  T  
 T
 
 
T x G=%xx  i
xx  i
xx  i T 
  
T  %	 
	T J l 	s 
T
 x  i%
  I 	T T  T  T  % T 
 x  iT x   i%x i T x  iT 
  
T  T 
  T 
 J l s  T  7xX_x  PqGeneva	
%xX FOOTERt HEADERt CxX(_	Comments:qGeneva	 @       QxX(lxX%      MxX_None found in the database.PqGeneva	< < 
<XMEMOLEN
<XMEMOEXTBU   MEMOFLD /. LASTELE H: CHUNKLEN EfCHUNKNUM < MAXCHUNK D PTRCHUNK J CONTENT  ?<N XCHUNK `PRINTSTR LDONE NUM HP | x B _STRPOSITIO  TEMPSTR \MEMOCHAR JmSTART `L~`HENDOFSTR O BLANKSTR .MOVECNT RnPGLINE R PAGENO n  R              %   2   >   U  ; m  f                     %   ,  	t  	  	/  	;  	J  	T  	`  
m  
  
R  
s  
  
  
  
  
  
      %  /  9  j#  y&  6  9  I  L  \  
Pj  
j  
  
    !  2  E  ]  y	    )  ,  <  L  .O  9_  Sk  f            &  A  S  ]  e       	    !  .  >  v  =  S  q    =  *@  2C  9F  >                $ 	   2 )              Monaco   HV          )           @  @          h (  @                 J - @@@             @@@            @     J@
  	      p @                :  
:   n     n F+CD   "F+NM   .F+XR   :PREF   F                           	 h                                                                                        