* File.....: process2.prg
* Version..: dBASE IV ver. 1.0 and higher
* Author...: Michael Liczbanski, 1989-1990
*            CompuServe Mail: 71211,266
*            Ashton-Tate Technical Support BBS: Lmike
*            (A-T BBS is accessible through CompuServe Network,
*            enter: ATBBS at 'Host Name' prompt)
*            Placed in public domain - NSA (no strings attached)
*            You may copy, give away and use this program free of charge
*            but may not sell it or include with 'collections' of utilities
*            for which ANY fee is charged.
*
*            Please drop me a note if you like/dislake this little utility.
*            Any feedback will be appreciated.
*
*            This version runs under dBASE IV 1.0 and higher and generates
*            code for either dBASE IV or CLIPPER.
*
* Notes....: This program writes 3 procedures for each .dbf file selected, which:
*            1. initialize memvars for all fields of selected .dbf file(s)
*            Procedures are named INIT + first 4 characters of a .dbf file name
*            2. Store content of fields of a .dbf file to memory variables
*            Procedures are named STOR + first 4 characters of a .dbf file name
*            3. Replace .dbf fields with memory variables
*            Procedures are named REPL + first 4 characters of a .dbf file name
*            4th procedure (common to all files and named DECLMVAR) declares
*            all created memvars PUBLIC.
*            Optional routines:
*            Procedure (OpenFile) writes routine to open required file(s)
*            with associated index TAG of the .mdx file (if TAG is specified.)
*            .dbf file(s) for use with the screen painter can also be created
*            automaticaly: created files have the same structure as processed
*            file(s) but field names are replaced with memvar names created by
*            the program.
*            Created files are named x+ .dbf file name (i.e. if the processed
*            file is named SOME.DBF - new file will be named XSOME.DBF.)
*            Structure of the existing file(s) is NOT AFFECTED.
*
*            Use of ALIAS is optional, but helpful.
*            .dbf file names, or at least their first 4 characters, must
*            be unique, because of the above procedure naming scheme.
*            Procedures created by this program - to be accessible from
*            anywhere - should be placed either in the main module of a program
*            or in the procedure file using SET PROCEDURE TO <procedure name>
*
*            All memvar names start with an x and are written in lower case
*            (i.e. memvar for field BOO will be: xboo)
*            .dbf field names are in upper case
*
*            This program does not create memvars for memo fields!
*
*            You may save file names and all info to a mem file and reuse
*            it (if - for instance - .dbf file structure changes and you
*            need to re-generate the code.)
*
*            Printer driver "Ascii.pr2" must be present in either current
*            or start-up directory. If any other printer driver is used -
*            please delete the first line from the generated code.
*
*                           !!! IMPORTANT !!!
*            Field names in the processed database file SHOULD be no longer then
*            9 characters: should you have a 10 char field name, program
*            will truncate the last charcter (i.e. if field name is
*            MYFIELD123 - memvar will have name xmyfield12.)
*            Also - if you happen to have 2 fields named like:
*            MYCOMMENT1 and MYCOMMENT2 you'll end up with 2 memvars with
*            the same name (xmycomment) and - if you choose to create a
*            .dbf file for use with screen painter - an error ("duplicate
*            field name on field <number> detected") will occur and
*            .dbf file won't be generated
*            Better yet - don't use 10 char field names.
*
*            Please do not remove this notice from the code!!!
*
*-- housekeeping
gc_talk   = SET("TALK")
SET TALK OFF
gc_safety = SET ("SAFETY")
SET SAFE OFF
gc_scoreb = SET("SCOREBOARD")
SET SCOR OFF
gc_printer= _pdriver
gc_bell = SET("BELL")
SET BELL OFF
CLEAR
CLOSE DATA
CLEAR TYPEAHEAD

*-- initialize memvars for main program
STORE SPACE(8) TO z_textf, temptxtf
STORE SPACE(24) TO z_path
STORE 9 TO how_many
*-- set processing flags
code_for = SPACE(7)
write_f   = IIF(Query([Write the file opening routine?]),.T.,.F.)
file_f    = IIF(Query([Write.dbf files for use with screen painter?]),.T.,.F.)
restore_f = IIF(Query([Restore arrays from the memory file]),.T.,.F.)

*-- z_filearr holds names of .dbf files to be processed - here 9 files max.
*-- and ALIAS name for each .dbf
IF restore_f
  fname = SPACE(8)
  @ 2,0 SAY [Enter memory file name (without extension)] GET fname ;
  MESSAGE [Enter name of an existing file - without extension]
  READ
  fname = TRIM(fname) + [.mem]
  @ 2,0
  IF "" = TRIM(fname) .OR. .NOT. FILE(fname)
    restore_f = .F.
  ELSE
    RESTORE FROM &fname ADDI

    *-- length of the restored array(s) elements is lost... when SAVED/RESTORED
    *-- so we need to make the adjustment here
    i = 1
    DO WHILE i <= how_many
      z_filearr[i,1] = IIF(LEN(z_filearr[i,1]) < 12, z_filearr[i,1]+SPACE(12-LEN(z_filearr[i,1])),z_filearr[i,1])
      z_filearr[i,2] = IIF(LEN(z_filearr[i,2]) < 10, z_filearr[i,2]+SPACE(10-LEN(z_filearr[i,2])),z_filearr[i,2])
      z_tagsarr[i] = IIF(LEN(z_tagsarr[i]) < 10, z_tagsarr[i]+SPACE(10-LEN(z_tagsarr[i])),z_tagsarr[i])
      i = i + 1
    ENDDO
  ENDIF
ENDIF
*-- restore_f may change if memory file doesn't exist, so...
*-- initialize arrays here
IF .NOT. restore_f
  PUBLIC ARRAY z_filearr[how_many,2], z_tagsarr[how_many]
  i = 1
  DO WHILE i <= how_many
    z_filearr[i,1] = SPACE(12)
    STORE SPACE(10) TO z_filearr[i,2], z_tagsarr[i]
    i = i + 1
  ENDDO
ENDIF

*-- write code for which dialect?
@ 02,00 SAY [Write code for ] GET code_for PICT "@M dBASE 4,Clipper";
  MESSAGE [Use Space Bar to View Choices - Enter to Select]
READ

*-- processing
DO WHILE .T.
  *-- get output file name and (optional) path
  @ 05,00 SAY [Output file name....:] GET z_textf PICT "@!";
    MESSAGE [Enter file name without extension. Extension will be .prg. Esc to exit]
  @ 06,00 SAY [Path to .dbf file(s):] GET z_path PICT "@!";
    MESSAGE [Leave blank if .dbf files are in current directory. End path with \]
  @ 07,00
  *-- get  .dbf file names, aliases (optional) tag order (optional)
  i = 1
  DO WHILE i <= how_many
    @ ROW()+1,00 SAY [File #]+LTRIM(STR(i))+[ to process:]
    @ ROW(), COL() GET z_filearr[i,1] PICT "@!" ;
    MESSAGE [Enter extension if other then .dbf]
    @ ROW(),COL()+2 SAY [Alias:]
    @ ROW(), COL() GET z_filearr[i,2] PICT "@!" ;
    MESSAGE [Enter Alias for this file - (optional)]
    *-- only if writing file opening routine and not code for Clipper
    IF write_f .AND. code_for <> "Clipper"
      @ ROW(),COL()+2 SAY [Initial TAG:]
      @ ROW(), COL() GET z_tagsarr[i] PICT "@!" ;
      MESSAGE [Enter initial TAG name for this  file (optional)]
    ENDIF
    i = i + 1
  ENDDO
  READ

  *--No entry? Exit!
  IF LASTKEY() = 27 .OR. ""=TRIM(z_textf)
    EXIT
  ENDIF

  *-- temptxtf is an output file name sans path (saved for reference on exit)
  temptxtf = z_textf
  IF AT("\",z_textf) = 0
    z_textf = TRIM(z_path)+LOWER(TRIM(z_textf))+[.prg]
  ELSE
    z_textf = LOWER(TRIM(z_textf))+[.prg]
  ENDIF
  *-- straight ascii output (otherwise 1st line will have booboos)
  _pdriver = "Ascii.pr2"
  SET CONSOLE OFF
  SET PRINTER TO FILE (z_textf)
  SET PRINTER ON
  *-- code generation begins here
  ? [*-- File: ]+z_textf+[. Generated on ]+MDY(DATE())+[ at ]+TIME() AT 0
  ? [*-- Code generated for ]+code_for
  ?

  *-- Part 1: Write open file(s) routine if desired...
  IF write_f
    ? REPL("*",80)
    ? [PROCEDURE Openfile]
    ? [*-- Open required .dbf files]
    ? REPL("*",80)
    ? [CLOSE DATA]

    *-- add .dbf extension if none entered
    kount = 1
    DO WHILE LEN(TRIM(z_filearr[kount,1])) > 0 .AND. kount <= how_many
      IF .NOT. "."$z_filearr[kount,1]
        z_filearr[kount,1] = TRIM(z_filearr[kount,1]) + ".DBF"
      ENDIF
      IF FILE(TRIM(z_path)+z_filearr[kount,1])
        IF code_for = "dBASE 4"
          ? [USE ] + TRIM(LOWER(z_filearr[kount,1]))+ [ IN SELECT()]+;
            IIF("" <> TRIM(z_tagsarr[kount]),[ ORDER TAG ]+TRIM(z_tagsarr[kount]),"")+;
            IIF("" <> TRIM(z_filearr[kount,2]),[ ALIAS ]+z_filearr[kount,2],"")
        ELSE
          ? [SELECT 0]
          ? [USE ] + TRIM(LOWER(z_filearr[kount,1]))+;
            IIF("" <> TRIM(z_filearr[kount,2]),[ ALIAS ]+z_filearr[kount,2],"")
        ENDIF
      ENDIF
      kount = kount + 1
    ENDDO
    ?
    ? [RETURN]
  ENDI
  *-- if write file for use with form designer - create temp. file name
  IF file_f
    my_path = TRIM(z_path)
    target_f = my_path+"OhMyMy.$$$"
  ENDIF

  *-- Part 2: Write declarations for memvars used for each file
  ?
  ? REPL("*",80)
  ? [PROCEDURE Declmvar]
  ? [*-- Declare memory variables as PUBLIC]
  ? REPL("*",80)

  *-- add .dbf extension if none entered
  kount = 1
  DO WHILE LEN(TRIM(z_filearr[kount,1])) > 0  .AND. kount <= how_many
    IF .NOT. "."$z_filearr[kount,1]
      z_filearr[kount,1] = TRIM(z_filearr[kount,1]) + ".DBF"
    ENDIF
    IF FILE(TRIM(z_path)+z_filearr[kount,1])
      USE (TRIM(z_path)+z_filearr[kount,1])
      *-- How many fields are there in the current file?
      fcount  = 1
      DO WHILE "" < FIELD(fcount+1)
        fcount = fcount + 1
      ENDDO
      *-- write declarations
      DO act1

      *-- generate .dbf file for use with screen painter (memvars as fields names)
      IF file_f
        COPY STRU EXTE TO &target_f
        USE &target_f
        REPL ALL field_name WITH "x"+SUBSTR(Field_name,1,9)
        *-- adjust new file name if original name = 8 characters
        new_file = TRIM(z_path)+[x]+;
   IIF(AT(".",z_filearr[kount,1]) > 8, SUBSTR(z_filearr[kount,1],2),z_filearr[kount,1])
        CREATE &new_file FROM &target_f
      ENDIF
    ENDIF
    kount = kount + 1
  ENDDO
  IF FILE(target_f)
    ERASE &target_f
  ENDIF
  ? [RETURN]

  *-- Part 3: write initialize, copy and replace routines
  kount = 1
  DO WHILE LEN(TRIM(z_filearr[kount,1])) > 0  .AND. kount <= how_many
    IF FILE(TRIM(z_path)+z_filearr[kount,1])
      USE (TRIM(z_path)+z_filearr[kount,1])
      *-- How many fields are there in the current file?
      fcount  = 1
      DO WHILE "" < FIELD(fcount+1)
        fcount = fcount + 1
      ENDDO
      DO act2
    ENDIF
    kount = kount + 1
  ENDDO
    ? [*-- EOF: ]+ z_textf
    SET PRIN OFF
    SET PRIN TO
    SET CONS ON
    CLEAR

    *-- save arrays to disk for future reference (if needed)
    IF Query([Save File/Alias/Tag Arrays for future use?])
      fname = SPACE(8)
      @ 2,0 SAY [Enter memory file name:] GET fname PICT "@!" ;
        MESSAGE [Do not enter extension. Extension will be .mem. Leave empty to exit.]
      READ
      IF ""<> TRIM(fname)
        *-- temptxtf is an output file name sans path
        z_textf = temptxtf
        SAVE ALL LIKE z_* TO &fname
      ENDIF
    ENDIF
    EXIT
  ENDDO

*-- exit routine
CLOSE DATA
RELEASE z_filearr, z_tagsarr
CLEAR
_pdriver = gc_printer
SET SAFE &gc_safety
SET SCOR &gc_scoreb
SET TALK &gc_talk
RETURN
*

PROCEDURE Act1
*-- make 'em all PUBLIC

? [*-- Memory variables for file ]+TRIM(z_filearr[kount,1])+;
  IIF(""=TRIM(z_filearr[kount,2]),"",". Alias: "+z_filearr[kount,2])
i = 1
? [PUBLIC ]
DO WHILE i <= fcount
  ?? [x]+TRIM(SUBSTR(LOWER(FIELD(i)),1,9))
  IF i < fcount
    ?? ", "
    IF PCOL() > 70
      ?? ";"
      ? SPACE(3)
    ENDIF
  ENDIF
  i = i + 1
ENDDO
?
RETURN
*
PROCEDURE Act2
?
? REPL("*",80)
? [*-- Initialize, store and replace routines for file ]+TRIM(z_filearr[kount,1])
? REPL("*",80)
?
? [PROCEDURE Init]+LOWER(SUBSTR(z_filearr[kount,1],1,4))
? [*-- Initialize memvars for file ]+TRIM(z_filearr[kount,1])+;
IIF(""=TRIM(z_filearr[kount,2]),"",". Alias: "+z_filearr[kount,2])
?
i = 1
DO WHILE i <= fcount
  temp_field = FIELD(i)
  IF TYPE(FIELD(i)) <> "M"
    ? [x]+TRIM(SUBSTR(LOWER(FIELD(i)),1,9))
    ?? " = " AT 11
    DO CASE
    CASE TYPE(FIELD(i)) = "C"
      ?? [SPACE(]+LTRIM(STR(LEN(&temp_field)))+[)]
    CASE TYPE(FIELD(i)) = "N"
      ?? [0]
    CASE TYPE(FIELD(i)) = "F"
      ?? [FLOAT(0)]
    CASE TYPE(FIELD(i)) = "L"
      ?? [.F.]
    CASE TYPE(FIELD(i)) = "D"
    *-- replace {} with CTOD("  /  /  ") if generating for dbase III  or Clipper
      IF code_for = "dBASE 4"
        ?? [{}]
      ELSE
        ?? [CTOD("  /  /  ")]
      ENDIF
    ENDC
  ENDIF
  i = i + 1
ENDD
? [RETURN]
?
? [PROCEDURE Stor]+LOWER(SUBSTR(z_filearr[kount,1],1,4))
? [*-- Store content of fields in file ]+TRIM(z_filearr[kount,1])+[ to memvars]+;
  IIF(""=TRIM(z_filearr[kount,2]),"",". Alias: "+z_filearr[kount,2])
*-- Code generation for dBASE 4
IF code_for = "dBASE 4"
  IF  "" <> TRIM(z_filearr[kount,2])
    ?
    ? [tmp_alias = ALIAS()]
    ? [SELECT ]+z_filearr[kount,2]
  ENDIF
*-- code generation for Clipper
ELSE
   ?
   ? [last_area = SELECT()]
ENDIF
?
i = 1
DO WHILE i <= fcount
  IF TYPE(FIELD(i)) <> "M"
    ? [x]+TRIM(SUBSTR(LOWER(FIELD(i)),1,9))
    ?? " = " + FIELD(i) AT 11
  ENDIF
  i = i + 1
ENDDO
IF code_for = "dBASE 4"
  IF  "" <> TRIM(z_filearr[kount,2])
    ?
    ? [IF "" <> TRIM(tmp_alias)]
    ? [ SELECT &tmp_alias]
    ? [ENDIF]
  ENDIF
*-- generating code for Clipper
ELSE
  ?
  ? [SELECT(last_area)]
ENDIF
? [RETURN]
?
*
? [PROCEDURE Repl]+LOWER(SUBSTR(z_filearr[kount,1],1,4))
? [*-- Replace fields in file ]+TRIM(z_filearr[kount,1])+[ with memvars]+;
  IIF(""=TRIM(z_filearr[kount,2]),"",". Alias: "+z_filearr[kount,2])

temp_a = IIF( "" <> TRIM(z_filearr[kount,2]),TRIM(z_filearr[kount,2])+[->],"")
IF code_for = "dBASE 4"
  IF  "" <> TRIM(z_filearr[kount,2])
    ?
    ? [tmp_alias = ALIAS()]
    ? [SELECT ]+z_filearr[kount,2]
  ENDIF
*-- code generation for Clipper
ELSE
   ?
   ? [last_area = SELECT()]
ENDIF

?
? [REPLACE ]
i  = 1
DO WHILE i <= fcount
  IF TYPE(FIELD(i)) <> "M"
    ?? temp_a + FIELD(i) + [ WITH x]+TRIM(SUBSTR(LOWER(FIELD(i)),1,9))
    *-- if memo field happens to be the last field in the file...
    IF i < fcount .AND. TYPE(FIELD(i+1)) <> "M"
      ?? ", "
      IF PCOL() > 65
        ?? ";"
        ? SPACE(3)
      ENDIF
    ENDIF
  ENDIF
  i = i + 1
ENDDO

IF code_for = "dBASE 4"
  IF  "" <> TRIM(z_filearr[kount,2])
    ?
    ? [IF "" <> TRIM(tmp_alias)]
    ? [ SELECT &tmp_alias]
    ? [ENDIF]
  ENDIF
*-- generating code for Clipper
ELSE
  ?
  ? [SELECT(last_area)]
ENDIF
? [RETURN]
?
RETURN
**********************************************************************
* Function.....: Query
* Description..: Y/N choice
**********************************************************************
FUNCTION query
PARA querym
PRIV answer
?? CHR(7)
answer = " "
DO WHILE .NOT. answer$"YN"
    answer = " "
    @ 1, 00 SAY querym GET answer PICT "!"
    READ
ENDDO
@ 01,00
RETURN IIF(answer = "Y",.T.,.F.)

*-- EOF: process2.prg
