*-----------------------------------------------------------------------
* Demonstration of the UDF 'ProgLevel()'
*
* This short program demonstrates the use of ProgLevel() by calling it
* with a reference to the array 'ps[]'.  As noted in the formal 
* documentation for ProgLevel(), the output array is optional, since
* the count of program levels is returned regardless. Should you desire
* a listing of programs on the stack, however, supply an array already
* declared with at least one cell. The array is returned with the stack 
* both in full path mode (SYS(16)) and short title mode (PROGRAM()).
*
* Enter DO PRGLEVEL to see the output which should be 
*
*          3
* (path)\PRGLEVEL.FXP                                           PRGLEVEL
* PROCEDURE DO2 (path)\PRGLEVEL.FXP                             DO2
* PROCEDURE DO3 (path)\PRGLEVEL.FXP                             DO3
*
*----------------------------------------------------------------------

clear
set talk off
do do2

procedure do2
do do3
return

procedure do3
udparm = set("udfparms")
set udfparms to reference      && Required for passing array name
declare ps[1]
k = ProgLevel(ps)              && Call procedure with name of array
i = 0
? k                            && Print number of programs
do while i < k                 && Print program stack
	i = i+1
	? ps[i,1]
	?? ps[i,2] at 65
enddo
set udfparms to &udparm        && Reset udfparms to original status
return



FUNCTION ProgLevel
*------------------------------------------------------------------------
*-- Programmer...: Ron Allen
*-- Date.........: 02/11/92
*-- Notes........: Returns a count of procedure and functions on the stack
*                  through the level calling this UDF. Optional return of
*                  all program, procedure and function names to a named
*                  array. The array will be two dimensions and will contain
*                  a column of names only using PROGRAM() and a column of
*                  classified names and paths using SYS(16,n). The array 
*                  named should be already DECLARED with minimum dimensions.
*                  Array should NOT be public. UDFPARMS should be SET TO 
*                  REFERENCE before calling ProgLevel().
*-- Written for..: FoxPro 2.0
*-- Rev. History.: None
*-- Calls........: None
*-- Called by....: Any
*-- Usage........: ProgLevel(<array>)
*-- Example......: nK = ProgLevel(cParray)
*-- Returns......: Number of programs, procedures & functions + optional 
*                  array.
*-- Parameters...: cTrace - Name of previously declared array, NOT public.

*------------------------------------------------------------------------

parameters cTrace
private nI, nJ, lDone
nI = 0
lDone = .f.

* Count the procedure/function levels

do while .not. lDone
	nI = nI + 1
	lDone = iif(program(nI) = program(),.t.,.f.)
enddo

* If user wants a trace, store level names in array.

if parameters() > 0
	nJ = nI
	declare cTrace[nI-1,2]
	do while nJ > 1
		nJ = nJ - 1
		cTrace[nJ,1] = Sys(16,nJ)
		cTrace[nJ,2] = program(nJ)
	enddo
endif

* Return a count of procedures/functions ahead of this udf.

RETURN nI - 1
* Eof - ProgLevel()
