PAGE 55,132

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;Name:	TSCR.ASM							       ;
;Desc:	Scrolls display up or down one line.				       ;
;	This routine is called from dDase with one parameter consisting of a   ;
;	five character string.	The first four characters represent the        ;
;	dimensions of the screen window where each character's associated      ;
;	decimal value is equivalent to a row or column.  The last character    ;
;	is whether you want to scroll up or down.			       ;
;									       ;
;	"0" thru "9" = row or column 0 - 9				       ;
;	"A" thru character# 127 = row or column 10 - 79 		       ;
;									       ;
;	 The order of the string must be in the following order:	       ;
;	   char #1 = upper left row					       ;
;	   char #2 = upper left column					       ;
;	   char #3 = lower right row					       ;
;	   char #4 = lower right column 				       ;
;	   char #5 = scroll up or down ("6" = up  "7" = down)		       ;
;									       ;
;Usage: CALL TSCR WITH "00:X6"						       ;
;		or							       ;
;	CALL TSCR with CHR(48)+CHR(48)+CHR(58)+CHR(88)+CHR(54)		       ;
;									       ;
;	This would define the window dimensions as 0,0 as the upper left corner;
;	and 10,40 as the lower right corner and scroll up one line.	       ;
;									       ;
;**** This routine does not check the validity of the passed parameters! ****  ;
;									       ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

color	  EQU	 70H		   ;BLACK ON WHITE
CODE	 SEGMENT
	 ASSUME CS:CODE

SCROLL	 PROC	FAR		   ;FAR RETURN
	 MOV	SI,BX		   ;PUT PARAMETER STRING IN SI

	 MOV	BL,[SI+4]	   ;GET 5TH CHARACTER
	 SUB	BL,48		   ;CONVERT DECIMAL VALUE
	 MOV	AH,BL		   ;PUT 06H=UP OR 07H=DOWN IN AH

	 MOV	AL,01H		   ;SCROLL 1 LINE
				   ;TO SCROLL MORE, CHANGE THIS VALUE

	 MOV	BL,[SI] 	   ;GET 1ST CHAR
	 SUB	BL,48		   ;CONVERT DECIMAL VALUE
	 MOV	CH,BL		   ;SET UPPER ROW

	 MOV	BL,[SI+1]	   ;GET 2ND CHAR
	 SUB	BL,48		   ;CONVERT DECIMAL VALUE
	 MOV	CL,BL		   ;SET UPPER COL

	 MOV	BL,[SI+2]	   ;GET THIRD CHAR
	 SUB	BL,48		   ;CONVERT DECIMAL VALUE
	 MOV	DH,BL		   ;SET LOWER ROW

	 MOV	BL,[SI+3]	   ;GET 4TH CHAR
	 SUB	BL,48		   ;CONVERT DECIMAL VALUE
	 MOV	DL,BL		   ;SET LOWER COL

	 MOV	BH,color	   ;PUT COLOR VALUE IN BH
	 INT	10H		   ;CALL DOS
	 RET
SCROLL	 ENDP

CODE	 ENDS
	 END
