*  FILE NAME:  CHKPASWD.PRG
*  BY:         TONY SCARPELLI
*  DATE:       04/02/93
*  CALLED BY:  MAIN.MNX
*  DATA FILES: XXXXUSER

*  DESC:  Gets password for system entry.
*         Enter with user table and level for that user.

* MODIFICATIONS:
* 04/26/93  Creating program. TS
* 01/14/94  Changed for more reuseable code.

* =========================================================

PROCEDURE CHKPASWD
PARAMETERS usertable, fillevel

SET TALK OFF
SET STEP OFF
SET CONFIRM ON
SET BELL ON
lcoldproc = SET('PROCEDURE')
SET PROCEDURE TO CODE_LIB
CLEAR

* Publics set for check user
PUBLIC m.user, m.idlevel, m.filtlevel, m.userdept, m.ccntr, m.password
m.user = SPACE(3)
m.idlevel = 0
m.filtlevel = fillevel

m.userdept = 0
m.ccntr = SPACE(8)

* Define password entry window
DEFINE WINDOW wrgetpaswd ;
	FROM INT((SROW()-5)/2),INT((SCOL()-26)/2) ;
	TO INT((SROW()-5)/2)+4,INT((SCOL()-26)/2)+25 ;
	NOFLOAT ;
	NOCLOSE ;
	COLOR SCHEME 1

ACTIVATE WINDOW wrgetpaswd
@ 1,2 SAY "Enter password:"

* Check the password for this user
numtries = 1
DO WHILE .T.
	=GetPassWord()
	if m.user == ""
		numtries = numtries + 1
		IF numtries <= 2
			?? chr(7)
			WAIT "That is the wrong password, please try again!" WINDOW TIMEOUT 3
			LOOP
		ELSE
			IF GETENV("USER") # "ATS"
				?? chr(7)
				WAIT "Sorry, you are not allowed access to this program. Bye, bye!" WINDOW TIMEOUT 3
				QUIT
			ELSE
				?? chr(7)
				WAIT "Sorry, you are not allowed access to this program. Bye, bye!" WINDOW TIMEOUT 3
				DO RESET
			ENDIF
		ENDIF
	else
		exit
	endif
ENDDO

RELEASE WINDOW wrgetpaswd
RELEASE acode, m.idcode, spw, mask, m.lcpassword, m.password
SET BELL OFF
SET EXACT OFF
SET PROCEDURE TO &lcoldproc

RETURN

* ---------------------------------------------------------

FUNCTION GetPassWord
               
PRIVATE m.idcode
m.idcode = SPACE(4)

* Open user data table
IF USED(usertable)
	SELECT &usertable
	SET ORDER TO TAG user
ELSE
	SELECT 0
	USE (LOCFILE((usertable)+".DBF","DBF","Where is " + (usertable) + "?"));
		AGAIN ALIAS (usertable) ;
		ORDER TAG user
ENDIF

SET FILTER TO

* ---------------------------------------------------------

m.idlevel = 0
DO ipw
m.password = space(4)

wait clear

* Enter password
SET COLOR TO N/W
@ 1,18 SAY "    "
@ 1,18 SAY ""
x = 0

* Clear escape for this section
ON ESCAPE
SET ESCAPE ON

DO WHILE x <= 4
   SET COLOR TO W/W
   keypress = INKEY(0,'S')

   DO CASE lastkey()
      CASE LASTKEY() = 19 OR LASTKEY() = 7 ;
        OR LASTKEY() = 8 OR LASTKEY() = 127
         * Check for back space, delete and left arrow
         * key presses and treat them all as destructive
         * backspaces or erasures
         IF x = 0
         	@ 1,18 SAY ""
         	LOOP
         ELSE
         	x = x-1
         	m.password = SUBSTR(ALLTRIM(m.password),1,x)
         	@ 1,18 + x SAY SPACE(1)
         	@ 1,18 + x SAY ""
         	set cursor on
         	LOOP
         ENDIF
      
      CASE LASTKEY() = 27
         * ESC key pressed
         EXIT

      CASE LASTKEY() = 13
         * ENTER key pressed. Entry of password is complete
         EXIT

      OTHERWISE
         * Increment m.password memvar
         m.password = ALLTRIM(m.password) + CHR(keypress)
         @ 1, 18 + x SAY "" COLOR N/W

   ENDCASE lastkey()

   x = x + 1
   if x > 3
   	x = 3
   	?? chr(7)
		@ 1,18 + x SAY ""
   endif

ENDDO

* Reset call to Escape procedure
IF GETENV('USER') <> 'ATS'
	ON ESCAPE DO TRAPWIND
	SET ESCAPE ON
ENDIF

m.password = UPPER(ALLTRIM(m.password))

wait window nowait "Checking password..."
SET COLOR TO
do GetCode

RETURN

* ---------------------------------------------------------

PROCEDURE GetCode
m.idcode = m.password
DO eidcode
acode = m.idcode
m.idcode = SPACE(4)

SET ORDER TO
SET FILTER TO idlevel = m.filtlevel
LOCATE ALL FOR idcode=acode

if not found()
	m.user = ""
else
	m.user = user
	m.idlevel = idlevel
	m.userdept = dept
	m.ccntr = ccntr + '   '
endif

USE

RETURN
