/******************************************************************************
*  LSTSCN.C - List settings in Quicksilver and dbXL SCN files. Dan Kenny 8/88 *
******************************************************************************/
#include <stdio.h>
#include <fcntl.h>
 
   typedef struct {
        char ignore1;                   /* Unknown                     */
        char wname[11];                 /* Window name                 */
        unsigned char bkgrdchr;         /* Background character        */
        char clrtxt;                    /* Text color                  */
        char tcol;                      /* Top column position         */
        char trow;                      /* Top row position            */
        char bcol;                      /* Bottom column position      */
        char brow;                      /* Bottom row position         */
        char clrfrm;                    /* Frame color                 */
        unsigned char frtopl;           /* Frame-top left char         */
        unsigned char frtopr;           /* Frame-top right char        */
        unsigned char frbotl;           /* Frame-bottom left char      */
        unsigned char frbotr;           /* Frame-bottom right unsigned */
        unsigned char frmidt;           /* Frame-middle top char       */
        unsigned char frmidb;           /* Frame-middle bottom char    */
        unsigned char frmidl;           /* Frame-middle left char      */
        unsigned char frmidr;           /* Frame-middle right char     */
        char clrget;                    /* Get color                   */
        char ignore2[5];                /* Unknown                     */
   } SCN_HDR;

   typedef struct {                     
        char txtforegrd;                /* Text foreground color       */
        char txtbackgrd;                /* Text background color       */
        char getforegrd;                /* Get field foreground color  */
        char getbackgrd;                /* Get field background color  */
        char frmforegrd;                /* Frame foreground color      */
        char frmbackgrd;                /* Frame bachground color      */
   } COLOR;

   typedef struct {                     
        char txt;                       /* Text character              */
        char color;                     /* Text character color        */
   } TEXT;                              
                                        
                                        
   SCN_HDR scn;
   COLOR color;
   TEXT text;
   int fhandle,i,j;
   int nrows,ncols;
   char foreground,background;
   char filename[13];
   char *txtblink="*",*getblink="*",*frmblink="*";
 
   char *colors[] = {"N","B","G","BG","R","RB","GR","W","N+",
                     "B+","G+", "BG+","R+","RB+","GR+","W+"};
                
main(int argc,char *argv[])
{
               
   if (argc < 2) {                                   /* Improper syntax */
      printf ("Usage is LSTSCN <SCNfile[.EXT]> \n");
      exit();                                    
   }
      
   strcpy(filename,strupr(argv[1]));
   if (!strstr(filename,"."))           /* Concat .EXT if necessary     */
      strcat(filename,".SCN");

/******************************************************************************
* Open up the SCN file - exit if not found.                                   *
******************************************************************************/
   printf("LSTSCN.C : List .SCN settings      -    Dan Kenny/Omaha, Ne.\n");
   if ((fhandle = open(filename,O_RDONLY | O_BINARY)) == -1) {
      printf ("Can't find scn file: %s\n",filename);
      exit();
   }

/******************************************************************************
* Read settings into structure variables.                                     *
******************************************************************************/
   read (fhandle,&scn,sizeof(scn));
   nrows = scn.brow-scn.trow;
   ncols = scn.bcol-scn.tcol;

/******************************************************************************
* Flag blinking attribute on colors.                                          *
******************************************************************************/
   if (scn.clrtxt < 0) {
      *txtblink = '*';
      scn.clrtxt=scn.clrtxt+128;
   }
   else
      *txtblink = '\0';
   if (scn.clrget < 0) {
      *getblink = '*';
      scn.clrget=scn.clrget+128;
   }
   else
      *getblink = '\0';
   if (scn.clrfrm < 0) {
      *frmblink = '*';
      scn.clrfrm=scn.clrfrm+128;
   }
   else
      *frmblink = '\0';
/******************************************************************************
* Compute foreground/background colors.                                       *
******************************************************************************/
   color.txtforegrd = scn.clrtxt%16;
   color.txtbackgrd = scn.clrtxt/16;
   color.getforegrd = scn.clrget%16;
   color.getbackgrd = scn.clrget/16;
   color.frmforegrd = scn.clrfrm%16;
   color.frmbackgrd = scn.clrfrm/16;
/******************************************************************************
* Print listing.....                                                          *
******************************************************************************/
   printf("-------------------------------------------------------------\n");
   printf("File: %-13s                   Window Name: %-13s\n",
          filename,scn.wname);
   printf("\nSize: %2d, %2d, %2d, %2d",
          scn.trow,scn.tcol,scn.brow,scn.bcol);

   if (scn.bkgrdchr==' ') 
      printf("\n");
   else 
      printf("               Background Char: %c  %d\n",
             scn.bkgrdchr,scn.bkgrdchr);

   printf("\nColor: %s%s/%s, %s%s/%s, %s%s/%s\n",colors[color.txtforegrd],
          txtblink,colors[color.txtbackgrd],colors[color.getforegrd],
          getblink,colors[color.getbackgrd],colors[color.frmforegrd],
          frmblink,colors[color.frmbackgrd]); 

   printf("\nFrame Characters :   %c  %c  %c        %d  %d  %d\n\n",
            scn.frtopl,scn.frmidt,scn.frtopr,scn.frtopl,scn.frmidt,scn.frtopr);
   printf("                     %c     %c        %d       %d\n\n",
            scn.frmidl,scn.frmidr,scn.frmidl,scn.frmidr);
   printf("                     %c  %c  %c        %d  %d  %d\n",
            scn.frbotl,scn.frmidb,scn.frbotr,scn.frbotl,scn.frmidb,scn.frbotr);

   printf("Text Image:\n");

   read (fhandle,&text,sizeof(TEXT));              /* Frame top  */
   printf("\n%c",text.txt);
   for (j=0; j <= ncols; j++){
      read (fhandle,&text,sizeof(TEXT));
      printf("%c",text.txt);
   }
   read (fhandle,&text,sizeof(TEXT));
   printf("%c",text.txt);

   for (i=0; i <= nrows; i++) {                    /* Frame middle and Text */
      read (fhandle,&text,sizeof(TEXT));   
      printf("\n%c",text.txt);
      for (j=0; j <= ncols; j++){
         read (fhandle,&text,sizeof(TEXT));
         printf("%c",text.txt);
      }
      read (fhandle,&text,sizeof(TEXT));
      printf("%c",text.txt);
   }

   read (fhandle,&text,sizeof(TEXT));             /* Frame bottom   */
   printf("\n%c",text.txt);
   for (j=0; j <= ncols; j++){
      read (fhandle,&text,sizeof(TEXT));
      printf("%c",text.txt);
   }
   read (fhandle,&text,sizeof(TEXT));
   printf("%c",text.txt);


   close(fhandle);     

}     
