;       Buffer.asm - give address of a buffer,
;       contained in the program, to dBASE III or IV.

;       Expects a 9-character variable argument.  The
;       contents at the call don't matter.  Returns
;       its own address as a string of the form
;       "XXXX:XXXX".  Returns "E" for "error" if
;       the argument is shorter than 9 bytes.
;       If argument contains more characters than
;       needed for the return, fills balance with
;       spaces.  If no argument is given, just returns.

;       This program must be assembled and linked, then
;       converted to a binary image file by EXE2BIN.
;       It cannot readily be converted to a .COM file.

;------------------------------------------------------

		.model tiny
		code segment
		assume cs:code,ds:code

Buffer          proc far
begin:          jmp short start
db              'Copyright (C) 1990, Jay Parsons'
start:          cmp byte ptr [bx],0  ; any arg?
                jz alldone      ; if not, return
                mov byte ptr [bx],'E' ; assume error
                mov ax,ds
                mov es,ax       ; point es to arg
                mov cx,-1
                mov di,bx       ; and di
                mov al,0
                repne scasb     ; find the null
                not cx
                cmp cx,9        ; got 9 chars?
                ja ok           ; fewer is error
                mov di,bx
                inc di
                jmp short padit

ok:             mov si,bx       ; point si to arg
                mov ax,cs       ; segment is our code
                mov cx,4
                call bintohex           ; seg to hex
		mov byte ptr [si]-1,':' ; add colon
                mov ax,offset begin ; offset too
		mov cx,4 
                call bintohex           ; convert
                mov di,si
                dec di
padit:          mov al,' '      ; a space
pad:            cmp byte ptr es:[di],0  ; full?
                jz alldone      ; then done
                stosb           ; else pad with spaces
		jmp short pad
alldone:        ret

Buffer          endp

;       Bintohex - Translate number in al or ax into
;       ASCII hexadecimal of the number of bytes in cx,
;       store at es/ds:si, adjust si past it and the
;       comma if any.

Bintohex	proc near
                mov dx,ax       ; copy number
                mov bx,cx       ; count
                mov di,si       ; and location
                mov al,'0'      ; fill with zeroes
                rep stosb
                mov cx,bx
                dec di          ; point to last one
		std
binloop:	cmp dx,0
		jz bin3
                mov al,dl       ; get least part
		and al,0Fh		
                add al,30h      ; convert to ASCII
		cmp al,'9'
		jbe bin2
                add al,7        ; correct for letter
bin2:           stosb           ; save it
		shr dx,1
		shr dx,1
		shr dx,1
                shr dx,1        ; shift in next digit
		loop binloop
bin3:		add si,bx
                inc si          ; bump past any comma
		cld
		ret

Bintohex	endp

                db 31849 dup (0)

code	 	ends	
		end

