;       Poke.asm - poke into memory

;       Expects a first character variable argument of
;       the form "XXXX" or "XXXX:XXXX" giving the
;       memory location to poke into, in ASCII hex.
;       If the first form is used, the poke is into the
;       current data segment.

;       Expects a second character variable argument of
;       the bytes to poke, in order.  The ASCIIZ
;       terminating the dBASE argument will not be
;       poked as part of the argument unless it is the
;       first character of the argument.

;       Optionally expects a numeric argument n giving
;       number of times to poke the second argument
;       repetitively.  n is in ASCII decimal. If n is
;       omitted, the second argument is poked once.

;       Expects arguments in dBASE IV format and
;       locations, i.e.:
;               ES:DI points to table of far pointers
;                 to arguments.
;               CX holds number of arguments.

;       This program must be assembled and linked, then
;       converted to a binary image file by EXE2BIN.
;       It cannot readily be converted to a .COM file.

		.model tiny
		code segment
		assume cs:code

poke            proc far
                int 3
                mov dx,ds       ; save our segment
                lds si,es:[di]  ; address argument
		call hextobin		; get address
                cmp byte ptr [si]-1,':' ; more?
		jnz getnum		; jump if not
                mov dx,bx       ; else this is dest.
                push dx
                call hextobin   ; get offset
                push bx
getnum:         mov dx,1        ; assume one rep
                cmp cx,2        ; only two arguments?
                jbe onetime     ; then 1 time only
                lds si,es:[di]+8  ; point to third
                call atob       ; number of reps
                mov dx,bx
onetime:        les di,es:[di]+4 ; point to 2nd
                push di         ; save offset
                push es         ; and segment
                mov al,0
                mov cx,1
                cmp byte ptr [di],al
                jz writeit
                neg cx          ; make cx -1
                repne scasb     ; find the null
                not cx          ; the count thru it
                dec cx          ; adjust to omit it

writeit:        pop ds          ; segment to poke
                pop bx          ; and offset
                pop di          ; offset to poke it
                pop es          ; and segment
writeloop:      mov si,bx       ; offset to si
                push cx         ; number of bytes
                rep movsb       ; poke one set
                pop cx          ; get count back
                dec dx          ; one less rep
                jnz writeloop

alldone:	ret
poke            endp

;       Hextobin - ASCII hex to binary conversion
;       routine.  Converts a number expressed in ASCII
;       hexadecimal at DS:SI to binary value in BX.
;       Does not check for overflow but returns value
;       mod 65,536.  Ignores spaces, treats any other
;       non-digit as terminator.  Cannot handle
;       negative numbers.  Destroys AX,BX.  On return,
;       SI points past terminator.

Hextobin	proc near
		push cx
                mov cl,4        ; shift count
                xor bx,bx       ; initialize result

htob_next:      lodsb           ; get a character
                cmp al,' '      ; space?
                jz htob_next    ; ignore spaces
                sub al,'0'      ; else make it hex
                jb htob_done    ; done if less than 0
                cmp al,9        ; a digit?
                jbe htob_num    ; jump for that
                and al,1Fh      ; capitalize letters
                sub al,7        ; adjust to binary
                cmp al,0ah      ; was it A-F?
                jb htob_done    ; done if not
		cmp al,0fh		
		ja htob_done
		
htob_num:       sal bx,cl       ; old value left 4
                add bl,al       ; add the new
		jmp short htob_next
	
htob_done:	pop cx
		ret
Hextobin	endp

;       Atob - ASCII to binary conversion routine.
;       Converts ASCII digits at DS:SI to binary value
;       in BX.  Does not check for overflow but returns
;       value mod 65,536. Ignores spaces, treats any
;       other non-digit as terminator.  Cannot handle
;       negative numbers.  Destroys AX,BX.  On return,
;       SI points past terminator.

Atob		proc near
                xor bx,bx       ; initialize result

atob_digit:     lodsb           ; get a character
                cmp al,' '      ; space?
                jz atob_digit   ; ignore spaces
                sub al,'0'      ; else make it hex
                jb atob_done    ; done if less than 0
		cmp al,9
                ja atob_done    ; or more than 9

                cbw             ; clear ah
                sal bx,1        ; old number times 2
                add ax,bx       ; old*2 plus new
                sal bx,1        ; old number times 4
                sal bx,1        ; old number times 8
                add bx,ax       ; old*10 plus new
		jmp short atob_digit
	
atob_done:	ret
Atob		endp

code	 	ends	
                end

