*-------------------------------------------------------------------------------
*-- Program...: COLOR.PRG
*-- Programmer: Ken Mayer (CIS: 71043,3232)
*-- Date......: 06/25/1992
*-- Notes.....: These routines are color processing routines that are not
*--             in the main procedure file. See README.TXT for details on how
*--             to use this library file.
*-------------------------------------------------------------------------------

FUNCTION ColorOf
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 01/11/1992
*-- Notes.......: This function will return the color of a specified area
*--               (as built in to dBASE). 
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: None
*-- Calls.......: ALLTRIM()            Function in PROC.PRG
*-- Called by...: Any
*-- Usage.......: ColorOf("<cArea>")
*-- Example.....: ?ColorOf("Messages")
*-- Returns.....: Color (foreground/background)
*-- Parameters..: cArea = Area you wish to return the color of from list:
*--               BOX/BOXES        = Boxes
*--               BORDER/PERIMETER = Border color
*--               NORMAL           = Normal screen/text
*--               HIGHLIGHT        = Highlights
*--               MESSAGE          = Messages
*--               TITLE            = Titles
*--               INFORMATION      = Information
*--               FIELDS           = Fields
*-------------------------------------------------------------------------------

	parameters cArea
	
	private cAttrib, cWanted, nPos
	
	cAttrib = set("ATTRIBUTES")
	cWanted = upper(alltrim(cArea))
	
	if cWanted = "BOX"
		nPos = 6
	else
		nPos = at(left(cWanted,4),;
			"    NORM HIGH PERI MESS TITL BOXE INFO FIEL BORD") / 5
		if nPos = 9
			nPos = 3    && "Border" = "Perimeter"
		endif
	endif
	
	do case
		case nPos = 0
			cAttrib = ""  && return null string for error
		case nPos < 4
			cAttrib = left(cAttrib,at("&",cAttrib) - 2)
		otherwise
			cAttrib = substr(cAttrib,at("&",cAttrib) + 3)
			nPos = nPos - 3
	endcase
	do while nPos > 1
		cAttrib = substr(cAttrib,at(",",cAttrib) + 1)
		nPos = nPos - 1
	enddo
	
RETURN left(cAttrib,at(",",cAttrib+",")-1)
*-- EoF: ColorOf()

FUNCTION Attribyte
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/19/1992
*-- Notes.......: Converts a dBASE color code for an area to the corresponding
*--               attribute byte as it is stored in video RAM.
*--               Does not work for monochrome codes and does not check for
*--               validity of color code given.
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Attribyte(<cCode>)
*-- Example.....: ? Attribyte("BG+/B")
*-- Returns.....: Numeric = Attribute byte value, in example 27 (0001 1011b)
*-- Parameters..: cCode = dBase code for colors of an area
*-------------------------------------------------------------------------------

	parameters cCode
	private nAttr,cHalf,nSlash
	nSlash=at("/",cCode)
	cHalf=trim(ltrim(iif(nSlash=0,"N",substr(cCode,nSlash+1))))
	nAttr=16*(iif("B" $ cHalf,1,0)+iif("G" $ cHalf,2,0);
	  +iif("R" $ cHalf,4,0)+iif("W" $ cHalf,7,0))
	cHalf=trim(ltrim(iif(nSlash=0,cCode,left(cCode,nSlash-1))))
	nAttr=nAttr+iif("B" $ cHalf,1,0)+iif("G" $ cHalf,2,0);
	  +iif("R" $ cHalf,4,0)+iif("W" $ cHalf,7,0)
	nAttr=nAttr+iif("+" $ cCode,8,0)+iif("*" $ cCode,128,0)
	
RETURN iif("X" $ cCode, 0, nAttr)
*-- EoF: Attribyte()

FUNCTION Colorname
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/19/1992
*-- Notes.......: Converts an attribute value for an area to the name of the
*--               corresponding color combination, assuming Iscolor() = .T.
*--               Does not check for validity of argument, integer 0<=arg<256
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Colorname(<nAttr>)
*-- Example.....: ? Colorname(27)
*-- Returns.....: Character = Name of color combination, in example
*--                    "bright cyan on blue"
*-- Parameters..: nAttr = value of attribute byte
*-------------------------------------------------------------------------------

	parameters nAttr
	private nColr,cName
	cName=iif(nAttr>127,"blinking ","")
	nColr=mod(nAttr,16)
	do case
	  case nColr=8
   	 cName=cName+"gray"
	  case nColr=14
   	 cName=cName+"yellow"
	  otherwise
   	 if nColr>7
      	cName=cname+"bright "
	    endif
   	 cName=cName+trim(substr("black  blue   green  cyan   ";
		  +"red    magentabrown  white  ",mod(nColr,8)*7+1,7))
	endcase
	nColr = mod(int(nAttr/16),8)
	cName=cName+" on "+trim(substr("black  blue   green  cyan   ";
	  +"red    magentabrown  white  ",nColr*7+1,7))
	
RETURN cName
*-- EoF: Colorname()

FUNCTION Colorcode
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 03/19/1992
*-- Notes.......: Converts an attribute value for an area to the dBase code for
*--               the corresponding color combination, assuming Iscolor() = .T.
*--               Does not check for validity of argument, integer 0<=arg<256
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Colorcode(<nAttr>)
*-- Example.....: ? Colorcode(27)
*-- Returns.....: Character = Code for color combination, in example "BG+/B"
*-- Parameters..: nAttr = value of attribute byte
*-------------------------------------------------------------------------------

	parameters nAttr
	private cColrs
	cColrs="N B G BGR RBGRW "
	
RETURN trim(substr(cColrs,mod(nAttr,8)*2+1,2));
  +iif(mod(int(nAttr/8),2)>0,"+","");
  +iif(nAttr>127,"*","")+"/";
  +trim(substr(cColrs,mod(int(nAttr/16),8)*2+1,2))
*-- EoF: Colorcode()

PROCEDURE ReColor
*-------------------------------------------------------------------------------
*-- Programmer..: Jay Parsons (CIS: 70160,340)
*-- Date........: 04/23/1992
*-- Notes.......: Restores colors to those held in a string of the form
*--               returned by set("ATTRIBUTE").
*-- Written for.: dBASE IV, Versions 1.0 - 1.5.
*-- Rev. History: None
*-- Calls       : None
*-- Called by...: Any
*-- Usage.......: DO ReColor WITH <cColors>
*-- Example.....: DO Recolor WITH OldColors
*-- Parameters..: cColors, a string in the form returned by set("ATTRIBUTE").
*-- Side effects: Changes the screen colors.
*-------------------------------------------------------------------------------

  parameters cColors
  private cThis, cNext, nAt, cLeft, nX, cAreas
  cAreas = "   NORMHIGHBORDMESSTITLBOX INFOFIEL"
  cLeft = cColors + ", "
  nX = 0
  do while nX < 8
    nX = nX + 1
    cThis = substr( cAreas, 4 * nX, 4 )
    if nX = 3
      nAt = at( "&", cLeft )
      cNext = left( cLeft, nAt - 2 )
      cLeft = substr( cLeft, nAt + 3 )
      SET COLOR TO , , &cNext
    else
      nAt = at( ",", cLeft )
      cNext = left( cLeft, nAt - 1 )
      cLeft = substr( cLeft, nAt + 1 )
      SET COLOR OF &cThis TO &cNext
    endif
  enddo

RETURN
*-- EoP: ReColor

*-------------------------------------------------------------------------------
*-- EoP: COLOR.PRG
*-------------------------------------------------------------------------------
