; Program ...: Keystate.ASM
; Author ....: Jeffrey B. McCrimon
; Date ......: January 27, 1990
; Notes .....: .BIN to be LOADed and CALLed from within dBASE IV
;              to set, toggle, return the state of the Insert,
;              NumLock, or CapsLock keyboard status.
; 
; Syntax ....: st_keyst = "<stat>"
;              * ---If <stat> is a "1", turn ON Keystate
;              * ---If <stat> is a "0", turn OFF Keystate
;
;              * ---If <stat> is a "?", Keystate returns
;              * ---          "1" if <key> is currently "ON"
;              * ---          "0" if <key> is currently "OFF"
;
;              * ---If <stat> is a space, Keystate
;              *              toggles the current keyboard status and
;              * ---          returns "1" if <key> was previously "ON"
;              * ---          returns "0" if <key> was previously "OFF"

;
;              LOAD Keystate
;              CALL Keystate WITH "<key>",st_keyst
;              * ---Where <key> is "I" for Insert
;              * ---               "C" for CapsLock
;              * ---               "N" for NumLock
;
;*************************************************
SPACE   EQU     " "
QMARK   EQU     "?"
ZERO    EQU     "0"
ONE     EQU     "1"
PLUS    EQU     "+"
NUMSTAT EQU     1101111100100000B
INSSTAT EQU     0111111110000000B
CAPSTAT EQU     1011111101000000B
;-------------------------------------------------
ROM     SEGMENT AT 0040H
        ORG 0017H
        KEYSTATE LABEL BYTE
ROM     ENDS
;*************************************************
CODE    SEGMENT BYTE PUBLIC 'CODE'
        ASSUME  CS:CODE

KSTAT   PROC    FAR
        ORG     0

START:
        JMP     SHORT ENTRY             ; Skip over the data area.
;=================================================
        DB      13, "Keystate.BIN by Jeffrey B, McCrimon", 13, 10
        DB      "(c) Copyright Ashton-Tate 1990", 13, 10
        DB      26
K_STATE DB      " "
;=================================================
ENTRY:  
        PUSH    ES
        PUSH    DS                      ; Save dBASE's Data Segment.
        CMP     CX,2                    ; Do we have two parameters?
        JNE     THE_END                 ; No, let's quit.
        LDS     SI,DWORD PTR ES:[DI+4]
        MOV     AX,ROM
        MOV     ES,AX
        XOR     CX,CX                   ; Zero CX register pair.
        MOV     CL,BYTE PTR ES:KEYSTATE ; Save Keyboard Status Word.
        MOV     CH,BYTE PTR [SI]        ; Save key_stat memvar parameter.
GETKEY:
        MOV     AX,NUMSTAT              ; Is <key> NumLock?
        CMP     BYTE PTR [BX],"N"
        JZ      SHORT DO_IT
        MOV     AX,CAPSTAT              ; Is <key> CapsLock?
        CMP     BYTE PTR [BX],"C"
        JZ      SHORT DO_IT
        MOV     AX,INSSTAT              ; Is <key> Insert?
        CMP     BYTE PTR [BX],"I"
        JZ      SHORT DO_IT
        MOV     K_STATE,PLUS            ; No, we have error.
        JMP     SHORT K_EXIT
DO_IT:
        CMP     CH,ONE                  ; Is parameter "1"?
        JZ      SHORT SET_ON            ; Yes, turn ON Keystat.
        CMP     CH,ZERO                 ; Is parameter "0"?
        JZ      SHORT SET_OFF           ; Yes, turn OFF Keystat.
        TEST    CL,AL                   ; Is Keystat OFF?
        JZ      SHORT SET_ON            ; Yes, turn ON Keystat.
        MOV     K_STATE,ONE             ; Keystat is ON.
        CMP     CH,QMARK                ; Is parameter "?"?
        JZ      SHORT K_EXIT            ; Yes, let's get out.
SET_OFF:
        AND     CL,AH                   ; Turn OFF Keystat.
        CMP     CH,ZERO                 ; Was parameter "0"?
        JZ      SHORT K_MAIN            ; Yes, enter main routine.
        MOV     CH,ONE                  ; Keystat was ON.
        JMP     SHORT K_MAIN
SET_ON:
        MOV     K_STATE,ZERO            ; Keystat is OFF.
        CMP     CH,QMARK                ; Is parameter "?"?
        JZ      SHORT K_EXIT            ; Yes, let's get out.
        OR      CL,AL                   ; No, Turn ON Keystat.
        CMP     CH,ONE                  ; Was parameter "1"?
        JZ      SHORT K_MAIN            ; Yes, enter main routine.
        MOV     CH,ZERO                 ; Keystat was OFF.
K_MAIN:
        MOV     BYTE PTR ES:KEYSTATE,CL ; Store new keyboard status.
        MOV     AL,CH                   ; Save keyboard status in memvar.
        MOV     BYTE PTR [SI],AL                
        JMP     SHORT THE_END
K_EXIT:
        MOV     AL,K_STATE
        MOV     BYTE PTR [SI],AL
THE_END:
        POP     DS                      ; Restore dBASE's Data Segment.
        POP     ES
        RET
KSTAT   ENDP
;-------------------------------------------------
CODE    ENDS
        END     START
