;*
;*ͻ
;*        This program is a hereby given to the public domain by            
;*        Randy Wallin.   No warranty is hereby implied or given.           
;*        I use these macros all the time without a single hitch.           
;*        Hopefully you'll be as fortunate, but please be careful           
;*        and back up your important files frequently.                      
;*                                                                          
;*        If you like these macros, please share them with others.          
;*                                                                          
;*        We also sell Quiet Flight Macros (and yes, these are apart        
;*        of that package).  The Quiet Flight Macros have been very         
;*        well received by our users....they are our best advertise-        
;*        ment.                                                             
;*                                                                          
;*        If you have any questions or problems, you can contact me         
;*        at:     Randy Wallin                                              
;*                COB System Designs,Inc.                                   
;*                206 South Hampton Drive                                   
;*                Jupiter, Florida 33458                                    
;*                (407)744-9835                                             
;*                CIS 76137,1260                                            
;*ͼ
;*** 
;*** Macro....: ivpro.m
;*** Author...: Randy Wallin
;*** Date.....: July 6, 1990 Last update: August 6, 1990
;*** Notice...: COB System Designs,Inc. 1990 All rights reserved.
;*** Notes....: ivpro.m is best used in the multi-tasking and
;*** task-switching world of xBase Programming - where you have BRIEF with
;*** version of the prg, make a quick change in the internal editor (FoxPro
;*** or dBaseIV) - and then return to the BRIEF program -- which now looks
;*** nothing like the real thing.
;***
;*** Copy IVPRO.M to your BRIEF macros sub-directory.  If you're not quite
;*** sure where that is, type in SET at the DOS prompt.  Look for a variable
;*** called BPATH - if you don't have a BPATH, I don't think you set up your
;*** BRIEF correctly. 
;***
;***
;*** To add these macros to your system - edit your initials macro - it should
;*** be in your \brief\macros sub-directory.  My initials are RCW - so I would 
;*** edit \brief\macros\rcw.m 
;*** If you're already in the \brief\macros sub-directory, it's easy:
;*** C> b ???.m   (make sure you replace the ??? with your initials)
;***
;*** You should see these lines about mid-screen
;***
;***
;***   (macro RCW <- but your initials
;***    	(
;***      ;**   Put your changes here.   
;***      ;**   Put your cursor on the line below this 1
;***      ;**   insert these lines next 3 lines.
;***         (autoload "ivpro" "kill_restore" "write_it")
;***         (assign_to_key "<Ctrl-k>" "kill_restore")  
;***         (assign_to_key "<Alt-w>" "write_it2")
;***
;***   The first line tells BRIEF where to look for the files when they are 
;***   called.  Basically, if you're lookin for kill_restore or write_it2
;***   load ivpro.m and it's in there.
;***
;***   The next two tell it what to use to call up these macros.
;***   Now, I'm using Ctrl-k and Alt-w -- but you can make them anything you'd
;***   like -- just make sure it's something you know and doesn't conflict with
;***   other macros you have (like dBrief).
;***
;***   Then recompile your initials macro by pressing ALT_F10 or quit to DOS
;***   and type in  CM ???.m (where ???.m is your initials)   
;***
;***   To compile this macro - you can either edit it and press ALT-F10 or
;***   in DOS CM ivpro.m

(macro kill_restore
     (  ;** purpose: to delete then restore the buffer currently loaded.
        ;**          Why?  Because sometimes it's faster to make a quick
        ;**          change in the FoxPro Editor (or dBase IV).   When you
        ;**          are multitasking or task switching (BRIEF loaded in 
        ;**          one window, FoxPro or IV in another)  - the current 
        ;**          version in BRIEF gets out of sync with the one changed 
        ;**          by the internal editor.
        ;**
        ;**          Actually, this macro will work for any type file - not
        ;**          just a PRG.
        ;**
        (int this_buffer   ;** current buffer id
             line_no       ;** line number
             column_no     ;** column number
             next_id       ;** is there another id?
             temp_id)      ;** temporary holding spot

        (string buff_name  ;** buffer's filename
                temp_buffname  ;** you guessed it, a place to store our
                               ;** temp buff name  
                msg_string ;** place to store our message line
                answer ) ;** place to store our answer
        ;** set up name of this buffer
        (inq_names buff_name NULL)                
       
        (if (exist buff_name)
            (  ;** is there a file on disk with same name as the current buffer?
            
               ;** grab the current buffers id
               (= this_buffer (inq_buffer)) 
               ;** sprintf inserts the variable buff_name into the 
               ;** string msg_string
               (sprintf msg_string "Wipe out %s? [Ny] " buff_name)
               ;** ask the key question.
               ;** 
               ;** get_parm always puts the message on the bottom line
               ;** 
               ;** this line is translated as:
               ;** get a parameter
               ;** NULL = this will be input - not sent by another program
               ;** answer = where we will store the answer
               ;** msg_string - our ?
               ;** 1 = length of input
               ;** "N" = default answer - note there's no Picture [Y]
               ;**       so only a Y will get things going.
               ;** 
               ;** dBase would look like this:
               ;** 
               ;** msg_string="Wipe Out this file? [Ny] "
               ;** answer=[N]
               ;** @ 24,00 SAY msg_string GET answer 
               ;** READ
               ;** 
               (if (get_parm NULL answer msg_string  1 "N")
                    ;** if you put your get_parm in an IF statement - you 
                    ;** can press escape and cancel the command.
                     (
                     (if (index "Yy" answer)
                           ( ;** the index function is like the $ in dbase
                             ;** this would be identical to 
                             ;** IF answer $ "Yy"
                             
                           ;** store the row,column info before we wipe this
                           ;** file out
                           (inq_position line_no column_no)
                           
                           ;** next buffer returns the next buffer in the 
                           ;** loop (basically it's like pressing ALT-N, 
                           ;** grabbing the buffer id and pressing ALT-- 
                           ;** back to the previous buffer)
                           (= next_id (next_buffer))
                           
                           ;** we're making sure there was another buffer
                           ;** because BRIEF won't allow you to delete 
                           ;** a single open buffer
                           (if (== next_id this_buffer)
                                 (  ;** if there isn't another buffer open
                                    ;** we're going to create one - to allow
                                    ;** BRIEF to delete this one.
                                    (= temp_id (create_buffer "Hang_On_A_Sec!"  "JustASec"))
                                    ;** after creating it, we get into it!
                                    (set_buffer temp_id)
                                    (attach_buffer temp_id)
                                 )
                           );endif buff_id
                           ;** delete this buffer - 
                           (delete_buffer this_buffer)
                           ;** load the same buffer from disk
                           (edit_file buff_name)
                           (message "Reloaded: %s" (upper buff_name))
                           ;** temp_id will only be greater than 0, if we 
                           ;** needed to create a temporary buffer.
                           
                           (if (> temp_id 0)
                                ;** if it's alive, kill it!
                                 (delete_buffer temp_id)
                           );endif temp_id 0 
                           ;** go to the row and column saved in the previous
                           ;** file
                           (move_abs line_no column_no)
                         )
                     );endif index
                   )
               );endif get_parm
            )
        );** endif (exist buff_name)
     )
);endmacro kill_restore

(macro write_it2
    (
      ;** save current file then delete files with "special" extensions.... 
      ;** .Fxp, .Fox or .Dbo - mainly due to the interactive nature of 
      ;** debugging in Pro OR IV - the development engine works sometimes
      ;** and other times misses it all together.
      ;**
      ;** This macro does make sure that Fox or IV find no newer .FXP or
      ;** .DBO than the prg -- so it forces a recompilation.
      ;**

      ;** If Fox or IV don't find an existing .FOX,.FXP or IV's .DBO then
      ;** it will recompile the prg.
      ;**
      ;** start your engines - initialize variables.

      (string _file_name  ;** varible name for current file (inc. drive\sub)
              _file_ext   ;** the current file extension
              _fxp_name   ;** current buffer with .FXP extension
              _fox_name   ;                       .FOX
              _dbo_name)  ;                       .DBO

      (int    _prev_msg_level) ;** var to save the current message level - to
                               ;** be restored at the end of the process.

		(= _prev_msg_level (inq_msg_level))
		(set_msg_level 0) ;* turn off all messages.

      ;** 
      ;** grab the name of the current file and it's extension
      ;**
      (inq_names _file_name _file_ext )

      ;** tell you what we're doing.
      (message "Checking Status of %s" _file_name)

      ;** check to make sure it's modified before saving.
      (if (inq_modified)
      	(
            (message "Writing %s" _file_name)

            ;** add a "." to the file extension
            (= _file_ext (+ "." _file_ext))

            ;** change _file_name to a drive:\sub-directory\filename (no ext)
            ;** this is equivalent to having 
            ;** filename="C:\CUSTOMER\CLIENT.PRG"
            ;** fileext=".PRG"
            ;** filename=SUBSTR(filename,1,AT(fileext,filename))
            ;** and filename would now = "C:\CUSTOMER\CLIENT."
            (= _file_name  (substr _file_name 1 (index _file_name _file_ext)) )
            ;**
            ;** switch is like a dBase DO CASE
            ;**
            ;** it's different because you evaluate the expression one 
            ;** time.
            ;** here we're saying we're branching based on the _file_ext variable
            ;
            (switch _file_ext
               ".prg"   ;** CASE _file_ext = ".prg"
               (

                (= _fxp_name (+ _file_name "fxp"))
                (= _fox_name (+ _file_name "fox"))
                (= _dbo_name (+ _file_name "dbo"))

                (if (exist _fxp_name)
                     (del _fxp_name)
                 );endif fxp
                (if (exist _fox_name)
                     (del _fox_name)
                 );endif fox
                (if (exist _dbo_name)
                     (del _dbo_name)
                 );endif dbo

               );*.prg

               ".frg"   ;** CASE _file_ext = ".frg" - IV report
               (
                (= _dbo_name (+ _file_name "fro"))
                (if (exist _dbo_name)
                     (del _dbo_name)
                 );endif dbo
               );*.frg

               ".lbg"   ;** CASE _file_ext = ".lbg" - IV label
               (
                (= _dbo_name (+ _file_name "lbo"))
                (if (exist _dbo_name)
                     (del _dbo_name)
                 );endif dbo
               );*.lbg
               ;
               ;* you can add your own extensions to the list -
               ;* since I expect there will be more <big grin>
               ;*
               ;* just follow this syntax:
               ;* ".???" ;* - replace the ".???" with the uncompiled
               ;*        ;*  file extension
               ;* (= _dbo_name (+ _file_name "???")) ;* replace this "???" 
               ;*        ;*  with the compiled extension.
               ;*
               ;* (if (exist _dbo_name)
               ;*     (del _dbo_name)
               ;* )
               ;* and that's all there is to it!
               
            );endswitch  _file_ext
      	)
      );** endif (inq_modified)

      ;** write it and reset the message level
      ;** 
      ;** leaving (write_buffer) outside the inq_modified - will allow
      ;** BRIEF to 1) Save the buffer if it's modified 
      ;**          2) Give you an error message
      ;**          "File has not been modified -- not written."
      ;** 
     	
      (write_buffer)

     (set_msg_level _prev_msg_level)

    )
); endmacro write_it2
