FUNCTION isleap
PARAMETERS p_date
PRIVATE p_date, p_year, febdate, mardate, rvalue

rvalue = .t.                  &&  starting value

DO CASE

  CASE type('p_date') = 'D'   &&  passed as a date
    p_year = ltrim(str(year(p_date)))

  CASE type('p_date') = 'C'   &&  if passed as a character

    IF ctod(p_date) # ctod('  /  /  ')  &&  valid string
      p_year = ltrim(str(year(ctod(p_date))))
    ELSE
      ?? chr(7)
      rvalue = .f.
    ENDIF

  CASE type('p_date') = 'N'   &&  passed as a number
    p_year = ltrim(str(p_date))

  OTHERWISE
    ??  chr(7)
    rvalue = .f.              &&  invalid parameter
ENDCASE

IF rvalue                     &&  we passed the test

  febdate = ctod('02/28/' + p_year)
  mardate = ctod('03/01/' + p_year)

  IF febdate + 1 = mardate    &&  if not leap year
    rvalue = .f.              &&  change return value to F
  ENDIF

ENDIF

RETURN(rvalue)

********
