*
* Copyright (c) Sherri Bruhn Kennamer, 1992-1993.  All rights reserved.
*
* The following program is provided AS IS without any warranty,
* expressed or implied, including but not limited to fitness for
* a particular purpose.  You may use this code freely in your
* applications.
*
* This program is a generic picklist routine which provides
* case-sensitive incremental searching (unless UPPER() is used
* in the tag, in which case your keystrokes are automatically
* upper-cased), multiple record selection, and mouse support.
*
* M.CHOICE is either a numeric memory variable or an array of
* numerics, depending on whether M.MULTI is .F. or .T.
*
* M.MULTI is an <expL> which indicates whether the picklist
* should allow multiple choices.
*
* M.ALIAS is the alias name of the database to be used for the
* picklist.  It is assumed to be in use.  If not provided, the
* database in the current workarea is assumed.
*
* If the database is ordered, incremental searching capabilities
* will automatically be provided.
* 
* M.FIELDLIST is an <expC> containing the fields to be included
* in FIELDS <field list>.  If not provided, a list containing
* all fields is constructed.
*
* M.TITLE is the title to be displayed in the title area of the
* browse window.  If the title does not evaluate to a valid window
* name, the browse window will not be modal.  IOW, clicking on
* another window will close the browse.
*
* February 1, 1993
*
* The following program was distributed to the attendants of the
* 1992 Microsoft FoxPro DevCon on the Sample Code Disk. 
*
* I am not aware of any bugs, although I've heard that performance
* on a 286 is not stellar. <grin> I'm interested in fixing any problems,
* so let me know if you find something. A message in the Browse
* Section on FoxForum would be best.
*
* I have tested this on FoxPro 2.5 DOS and Windows--everything
* seems fine on the DOS side. The Windows side needs a little
* work, however. I'll get to it. <g>
*
* Have fun!
*
* Sherri Kennamer
* 75300,3646
*
* The following statements are an example of how to use PICKLIST.PRG.
*
* USE LOCFILE('customer.dbf','dbf','Locate CUSTOMER.DBF:')
* INDEX ON company TAG company
* SET ORDER TO TAG company
* dimension choices[1]
* choices=0
* DO PICKLIST WITH m.choices, .T., 'customer', 'company, contact, phone', ;
*   'Customer Picklist - F2/Toggle F3/Clear Selections'
* 
PARAMETERS m.choice, m.multi, m.alias, m.fieldlist, m.title
PUSH KEY CLEAR
PRIVATE ALL

IF SET('talk')='ON'
   SET TALK OFF
   m.talk='ON'
ELSE
   m.talk='OFF'
ENDIF

m.error=.T.

DO CASE
CASE !TYPE('choice')='N'
   WAIT WINDOW NOWAIT 'Parameter CHOICE must be <expN>!'
CASE !TYPE('m.multi')='L'
   WAIT WINDOW NOWAIT 'Parameter MULTI must be <expL>!'
CASE m.multi .AND. type('choice[1]')='U'
   WAIT WINDOW NOWAIT 'Parameter CHOICE must be an array!'
CASE EMPTY(m.alias) .AND. EMPTY(ALIAS())
   WAIT WINDOW NOWAIT 'Procedure PICKLIST requires a database!'
CASE !EMPTY(m.alias) .AND. !TYPE('m.alias')='C'
   WAIT WINDOW NOWAIT 'Parameter ALIAS must be <expC>!'
CASE !EMPTY(m.alias) .AND. !USED(m.alias)
   WAIT WINDOW NOWAIT 'Alias '+upper(m.alias)+' not found!'
CASE (EMPTY(m.alias) .AND. EMPTY(ALIAS()));
   .AND. !TYPE('m.alias')='C';
   .AND. !USED(m.alias)
   WAIT WINDOW NOWAIT 'Procedure PICKLIST requires a database!'
CASE !EMPTY(m.fieldlist) .AND. !TYPE('m.fieldlist')='C'
   WAIT WINDOW NOWAIT 'Parameter FIELDLIST must be <expC>!'
CASE !EMPTY(m.title) .AND. !TYPE('m.title')='C'
   WAIT WINDOW NOWAIT 'Parameter TITLE must be <expC>!'
OTHERWISE
   m.error=.F.   
ENDCASE

IF m.error
   IF m.talk='ON'
      SET TALK ON
   ENDIF
   ??CHR(7)
   RETURN
ENDIF

m.select=SELECT()

m.alias=IIF(EMPTY(m.alias),ALIAS(),m.alias)
   
m.bell=SET('bell')
SET BELL OFF
m.compatible=SET('compatible')
SET COMPATIBLE OFF
m.near=SET('near')
SET NEAR ON

IF m.multi
   DIMENSION choice[1]
ENDIF
m.choice=0

* Create a cursor with a single character field of length 1

m.i=0
m.f='Z0'
DO WHILE USED(f)
   m.i=m.i+1
   m.f='Z'+ALLTRIM(STR(m.i))
ENDDO
CREATE CURSOR (m.f) (c C(1))
APPEND BLANK

SELECT (m.alias)

* Make a copy of the BROWSE color scheme (#10) and modify
* colorpair #2 to make the selected field invisible

m.scheme24=SCHEME(24)
SET COLOR OF SCHEME 24 TO SCHEME 10
m.colorpair=SCHEME(24,2)
m.colorpair=SUBSTR(m.colorpair,AT('/',m.colorpair)+1)
m.colorpair=m.colorpair+'/'+m.colorpair
SET COLOR OF SCHEME 24 TO ,&colorpair

* Initialize variables for the search string, and the time the
* last character was typed.

m.seekstring=''
m.seconds=SECONDS()
m.lastmouse=0
m.lastmrow=0
m.lastmcol=0
m.title=IIF(EMPTY(m.title),'',m.title)
m.wname=IIF(EMPTY(m.title),ALIAS(),wname(m.title))
m.wontop=IIF(EMPTY(m.title),ALIAS(),m.title)
m.uppercase=IIF(SYS(21)='0',.F.,'UPPER('$KEY(VAL(SYS(21))))
m.fieldlist=;
   IIF(SYS(21)='0','',"&f..c:h='':v=s(&f..c),")+;
   IIF(m.multi,"m=m():h='',",'')+;
   IIF(EMPTY(m.fieldlist),allfields(),m.fieldlist)+;
   IIF(SYS(21)='0',' NOEDIT',' FREEZE &f..c')

ACTIVATE SCREEN

ON KEY LABEL enter DO toggle WITH .T.
ON KEY LABEL ctrl+enter KEYBOARD '{ctrl+w}'
ON KEY LABEL f3 DO ZAP
ON KEY LABEL leftmouse DO mousedown WITH MROW(), MCOL(),;
   WLROW(m.wontop), WLCOL(m.wontop), WROWS(m.wontop), WCOLS(m.wontop)

BROWSE;
   FIELDS &fieldlist;
   NOAPPEND NODELETE NORGRID;
   COLOR SCHEME 24;
   TITLE m.title

ON KEY

IF m.talk='ON'
   SET TALK ON
ENDIF
IF m.near='OFF'
   SET NEAR OFF
ENDIF
IF m.bell='ON'
   SET BELL ON
ENDIF
IF m.compatible='ON'
   SET COMPATIBLE ON
ENDIF

SET COLOR OF SCHEME 24 TO &scheme24

USE IN (f)

SELECT (m.select)

POP KEY

*!*****************************************************************
*!
*!       Function: ALLFIELDS
*!
*!*****************************************************************
FUNCTION allfields
m.names=''
FOR m.i=1 TO FCOUNT()
   m.names=m.names+','+FIELD(m.i)
ENDFOR
RETURN SUBSTR(m.names,2)

*!*****************************************************************
*!
*!      Procedure: JUMP
*!
*!*****************************************************************
PROCEDURE jump
ON KEY LABEL alt+j
SEEK IIF(m.uppercase,UPPER(m.seekstring),m.seekstring)
m.seconds=SECONDS()

*!*****************************************************************
*!
*!       Function: M
*!
*!*****************************************************************
FUNCTION m
RETURN IIF(!EMPTY(ASCAN(choice,RECNO())),CHR(16),' ')

*!*****************************************************************
*!
*!       Function: MOUSEDOWN
*!
*!*****************************************************************
PROCEDURE MOUSEDOWN
PARAMETERS m.mrow, m.mcol, m.wlrow, m.wlcol, m.wrows, m.wcols

IF BETWEEN(m.mrow,m.wlrow,m.wlrow+m.wrows);
   .AND. BETWEEN(m.mcol,m.wlcol,m.wlcol+m.wcols)
   IF BETWEEN(m.mrow,m.wlrow+3,m.wlrow+m.wrows-2);
      .AND. BETWEEN(m.mcol,m.wlcol+2,m.wlcol+m.wcols-2)
      IF m.lastmouse=0 .OR. SECONDS()-m.lastmouse>_DBLCLICK;
         .OR. m.lastmrow<>m.mrow .OR. m.lastmcol<>m.mcol
         m.lastmouse=SECONDS()
         m.lastmrow=m.mrow
         m.lastmcol=m.mcol
      ELSE
         DO toggle
         m.lastmouse=0
      ENDIF
   ELSE
      && Let the mouse click pass on through
   ENDIF
ELSE
   && Eat the mouse click
   =INKEY(0,'M')
ENDIF

*!*****************************************************************
*!
*!       Function: S
*!
*!*****************************************************************
FUNCTION s
PARAMETERS m.char
REPLACE &f..c WITH ''
IF SECONDS()-m.seconds<=_DBLCLICK
   m.seekstring=m.seekstring+m.char
ELSE
   m.seekstring=m.char
ENDIF
ON KEY LABEL alt+j DO jump
KEYBOARD '{alt+j}'

*!*****************************************************************
*!
*!      Procedure: TOGGLE
*!
*!*****************************************************************
PROCEDURE toggle
PARAMETERS m.advance
IF !m.multi
   m.choice=RECNO()
   KEYBOARD '{ctrl+enter}'
ELSE
   m.subscript=ASCAN(choice,RECNO())
   IF EMPTY(m.subscript)
      IF !EMPTY(choice)
         DIMENSION choice[ALEN(choice)+1]
      ENDIF
      choice[ALEN(choice)]=RECNO()
   ELSE
      IF ALEN(choice,1)=1
         choice=0
      ELSE
         =ADEL(choice,m.subscript)
         DIMENSION choice[ALEN(choice,1)-1]
      ENDIF
   ENDIF
   IF m.advance
      KEYBOARD '{dnarrow}'
   ENDIF
ENDIF

*!*****************************************************************
*!
*!       Function: WNAME
*!
*!*****************************************************************
FUNCTION wname
PARAMETERS m.name
PRIVATE ALL
DO WHILE !EMPTY(m.name)
   m.char=ASC(LEFT(m.name,1))
   IF BETWEEN(m.char,48,57);
      .OR. BETWEEN(m.char,65,90);
      .OR. BETWEEN(m.char,97,122)
      EXIT
   ELSE
      m.name=SUBSTR(m.name,2)
   ENDIF
ENDDO
m.name=IIF(ISDIGIT(m.name),'',LEFT(m.name,10))
FOR m.i=1 TO LEN(m.name)
   m.char=ASC(SUBSTR(m.name,m.i,1))
   IF !BETWEEN(m.char,48,57);
      .AND. !BETWEEN(m.char,65,90);
      .AND. !BETWEEN(m.char,97,122);
      .AND. !m.char=95
      m.name=LEFT(m.name,m.i-1)
      EXIT
   ENDIF
ENDFOR
RETURN m.name

*!*****************************************************************
*!
*!      Procedure: ZAP
*!
*!*****************************************************************
PROCEDURE ZAP
IF m.multi
   DIMENSION choice[1]
   choice=0
   SHOW WINDOW (m.wname) REFRESH
ENDIF

