/* tab stops at 2

		nppc.c - framework for use of NPPC network interface
		
		Allows message passing between Fox applications
		
		(c)1994 John D'Ausilio/ECR Software Corporation - All Rights Reserved
		890 West King St. #206
		Boone, NC 28607
		(704)-265-2907
		
		This file is incomplete in itself; you need to purchase the NPPC
		Library which provides nppcn.lib and nppc.h. Also should work for
		IPX systems by substituting nppcx.lib in link.
		
		Softwarehouse Corp. (source for NPPC) can be reached at 415-949-0203.
		
		Compile with WATCOM 8.5e or better using the included
		NPPC.MAK file.
		
			wmake -f nppc.mak

		No guarantees; if it works for you ... use it. I did spend a few
		days writing it, so if you make any money off it, a small donation 
		would be appreciated.
*/

/*******************************************************************
 defines you may want to change */

#define MSGSPACE 12288		/* space to allocate for message spaces */
#define NUM_HLOCS 64			/* number of hloc pointers to allocate */
#define ASST 16						/* # of spaces in SID mapping table */
#define CONV 8						/* # of simultaneous conversations */
#define DISP 0xFF					/* No sign-on message */

/*******************************************************************
 pragmas to let watcom use msc librarys - leave them alone! */

#pragma aux MS_C "_*"                                  \
            parm caller []                             \
            value struct float struct routine [ax]     \
            modify [ax bx cx dx es];
#pragma aux (MS_C) NA_GETSPACE;
#pragma aux (MS_C) NA_FREESPACE;
#pragma aux (MS_C) NA_TRANSMIT;
#pragma aux (MS_C) NA_DISCONNECT;
#pragma aux (MS_C) NA_RESULT;
#pragma aux (MS_C) NA_RECEIVE;
#pragma aux (MS_C) NA_INITIALIZE;
#pragma aux (MS_C) NA_STATIONS;
#pragma aux (MS_C) NA_TERMINATE;
#pragma aux (MS_C) NA_NETID;
#pragma aux (MS_C) NA_QUEUECOUNT;
#pragma aux (MS_C) NA_SETMSGPARMS;
#pragma aux (MS_C) NA_GETMSGPARMS;

/*******************************************************************
 include files */

#include <stdlib.h>
#include <dos.h>
#include <pro_ext.h>				/* included with MS Fox LCK */
#include "nppc.h"						/* included with NPPC Library */

/******************************************************************
 globals */

static struct mh FAR *hlocs[NUM_HLOCS];	/* array of space pointers 	*/
static char FAR NPPCBuffer[MSGSPACE];		/* message space for NPPC */
static char FAR junk[80];								/* space for debug messages */
static struct mh FAR *hloc;							/* pointer to an hloc */
static int nErr;												/* holds return codes */
static int retval;											/* holds Fox return codes */

/******************************************************************
 global error code defines */

#define NPPC_SMALL_SPACE 			-10
#define NPPC_PARM_ERROR				-11
#define NPPC_NO_HLOC_PTR			-12
#define NPPC_LOAD_ERROR				-13
#define NPPC_STORE_ERROR			-14

/******************************************************************
 local functions */

int gethloc(int index)
/*************************************
 attempts to find a free hlocs slot recursively */
{
	if ((index < NUM_HLOCS) && (hlocs[index] != MK_FP(0xFFFF,0xFFFF)))
		return(gethloc(index + 1));
	if (index >= NUM_HLOCS) return(NPPC_NO_HLOC_PTR);
	return(index);
}

void lna_init(ParamBlk FAR *pblk)
/*************************************
 called on library load */
{
	struct mh FAR *dummy = MK_FP(0xFFFF,0xFFFF);
	int i;
	
	/* init hloc pointer array */
	for(i=0;i<NUM_HLOCS;i++) hlocs[i] = dummy;

#ifdef DEBUG
	/* print start of buffer address */
	sprintf(junk,"Buffer: %lX\n",(long) &hlocs);
	_PutStr(junk);
#endif
}

void lna_deinit(ParamBlk FAR *pblk)
/*************************************
 called on library unload */
{
	/* shut it down */
	retval = NA_TERMINATE();
}

/******************************************************************
 external functions */

void lna_getspace(ParamBlk FAR *pblk)
/*************************************
 get a message space from NPPC
	 parameters : size of message space
	 returns		: hlocs index to this hloc (space pointer), or
	 						:	NPPC_NO_HLOC_PTR if none available, or
	 						:	retval from NPPC
*/
{
	Value val;
	struct mh FAR *hloc;
	unsigned int size;
	int hloc_ptr, maxspace;
	
	/* make sure we got right parms */
	val = pblk->p[0].val;
	if (val.ev_type == 'I')
		;
	else{
		_RetInt(NPPC_PARM_ERROR,10);
		return;
	}

	/* make sure we can get a space for hloc pointer */
	hloc_ptr = gethloc(0);
	if (hloc_ptr < 0){
		_RetInt(hloc_ptr,10);
		return;
	}
	
	/* get the requested size parameter */
	size = (unsigned int) val.ev_long;
	maxspace = 0;

	/* try and get NPPC to give us a space */
#ifdef DEBUG
	sprintf(junk,"size=%d, maxspace=%d\n",size, maxspace);
	_PutStr(junk);
#endif
	retval = NA_GETSPACE(size,&hloc,&maxspace);

#ifdef DEBUG
	sprintf(junk,"retval = %d, maxspace=%d\n",retval, maxspace);
	_PutStr(junk);
#endif

	if (retval == 0){
		/* we got a space of some sort, check to see if right size */
		/* good space, put hloc pointer in storage and return index */
		hlocs[hloc_ptr] = hloc;
		_RetInt(hloc_ptr,10);
	}
	else
		if (retval == 1){
			/* space too small, give it back */
			retval = NA_FREESPACE(hloc);
			_RetInt(NPPC_SMALL_SPACE,10);
		}
		else
			_RetInt(-1*retval,10);

	return;
}

void lna_freespace(ParamBlk FAR *pblk)
/*************************************
 returns a message space to NPPC
	 parameters : hloc index to this space
	 returns		: return value from NPPC 
*/
{
	Value val;
	struct mh FAR *hloc;
	int hloc_ptr;
	
	/* make sure we got right parms */
	val = pblk->p[0].val;
	if (val.ev_type == 'I')
		;
	else{
		_RetInt(NPPC_PARM_ERROR,10);
		return;
	}

	/* get the hloc index to free */
	hloc_ptr = (int) val.ev_long;
	
	/* try and free the space */
	retval = NA_FREESPACE(hlocs[hloc_ptr]);
	if (retval == 0)
		hlocs[hloc_ptr] = MK_FP(0xFFFF,0xFFFF);
	_RetInt(-1*retval,10);

	return;
}

void lna_transmit(ParamBlk FAR *pblk)
/*************************************
 transmit a message
	 parameters : hloc_ptr, index to your message space
	 returns		:	retval from NPPC
*/
{
	Value val0;
	struct mh FAR *hloc;
	int hloc_ptr;

	/* make sure we got right parms */
	val0 = pblk->p[0].val;
	if (val0.ev_type == 'I')
		;
	else{
		_RetInt(NPPC_PARM_ERROR,10);
		return;
	}

	/* get our parameters */
	hloc_ptr = (int) val0.ev_long;
	hloc = hlocs[hloc_ptr];
	if (hloc == MK_FP(0xFFFF,0xFFFF)){
		_RetInt(NPPC_NO_HLOC_PTR,10);
		return;
	}

	
	retval = NA_TRANSMIT(hloc);
#ifdef DEBUG
	sprintf(junk,"retval(transmit): %d\n",retval);
	_PutStr(junk);
#endif
	_RetInt(-1*retval,10);

	/* free up the space pointer */
	if(hloc->fn == 2 || hloc->fn == 4)
		hlocs[hloc_ptr] = MK_FP(0xFFFF,0xFFFF);

	return;

}

void lna_disconnect(ParamBlk FAR *pblk)
/*************************************
 disconnects the connection between SID and LNID
	 parameters : SID to disconnect
	 returns		: return value from NPPC 
*/
{
	Value val;
	int sid;
	
	/* make sure we got right parms */
	val = pblk->p[0].val;
	if (val.ev_type == 'I')
		;
	else{
		_RetInt(NPPC_PARM_ERROR,10);
		return;
	}

	/* get the SID to disconnect*/
	sid = (int) val.ev_long;
	
	/* try and disconnect*/
	retval = NA_DISCONNECT(sid);
	_RetInt(-1*retval,10);

	return;
}

void lna_result(ParamBlk FAR *pblk)
/*************************************
 recovers a message space from a transmit/NoWait call
	 parameters : none
	 returns		: index to message space pointer; or
	 						:	retval from NPPC
*/
{
	struct mh FAR *hloc;
	int hloc_ptr;
	
	/* make sure we can get a space for hloc pointer */
	hloc_ptr = gethloc(0);
	if (hloc_ptr < 0){
		_RetInt(hloc_ptr,10);
		return;
	}
	
	/* Look for a space */
	retval = NA_RESULT(&hloc);
	if (retval == 0){
		hlocs[hloc_ptr] = hloc;
		_RetInt(hloc_ptr,10);
	}
	else
		_RetInt(-1*retval,10);

	return;
}

void lna_receive(ParamBlk FAR *pblk)
/*************************************
 receives a message
	 parameters : @hloc_ptr, variable to hold returned space
	 						: function, 1-3 ;1=Highest Priority, Specific SID
	 														;2=Next, Specific SID/Type
	 														;3=Highest Priority, Any SID
	 						:	SID, number of server (function = 1 or 2 only)
	 						:	Type, Message type to accept (function = 2 only)
	 returns		:	retval from NPPC
*/
{
	Value val0,val1,val2,val3;
	Locator loc;
	unsigned int fn, sid, type;
	long hloc_ptr;
	
	
	sid = type = 0;

	/* make sure we got right parms */
	val1 = pblk->p[1].val;
	switch(pblk->pCount){
		case 4: 
			val3 = pblk->p[3].val;
		case 3: 
			val2 = pblk->p[2].val;
	}
	
	switch(val1.ev_long){

		case 1:	
			if ((pblk->pCount == 3) && 			/* function 1 */
					(val1.ev_type == 'I') &&
					(val2.ev_type == 'I'))
				;
			else{
				_RetInt(NPPC_PARM_ERROR,10);
				return;
			}
			break;

		case 2:	
			if ((pblk->pCount == 4) && 			/* function 2 */
					(val1.ev_type == 'I') &&
					(val2.ev_type == 'I') &&
					(val3.ev_type == 'I'))
				;
			else{
				_RetInt(NPPC_PARM_ERROR,10);
				return;
			}
			break;

		case 3:	
			if ((pblk->pCount == 2) && 			/* function 3 */
					(val1.ev_type == 'I'))
				;
			else{
				_RetInt(NPPC_PARM_ERROR,10);
				return;
			}
			break;
	}

	/* get our parameters */
	fn = (int) val1.ev_long;
	switch(fn){
		case 2: 
			type = (int) val3.ev_long;
		case 1: 
			sid = (int) val2.ev_long;
	}
	
	/* make sure we can get a space for hloc pointer */
	hloc_ptr = gethloc(0);
	if (hloc_ptr < 0){
		_RetInt(hloc_ptr,10);
		return;
	}

#ifdef DEBUG
	sprintf(junk,"Ptr index: %d\n",hloc_ptr);
	_PutStr(junk);
#endif

	hloc = MK_FP(0xFFFF,0xFFFF);

#ifdef DEBUG
	sprintf(junk,"Rx hloc: %lX, %X:%X\n",(long) hloc, FP_SEG(hloc),FP_OFF(hloc));
	_PutStr(junk);
	sprintf(junk,"fn:%d,sid:%d,type:%d\n",fn,sid,type);
	_PutStr(junk);
#endif

	switch(fn){
		case 1:
			retval = NA_RECEIVE(fn, sid, &hloc);
			break;
		case 2:
			retval = NA_RECEIVE(fn, sid, type, &hloc);
			break;
		case 3:
			retval = NA_RECEIVE(fn, &hloc);
			break;
	}

	
	if (retval == 0){
		hlocs[hloc_ptr] = hloc;
		_MemMove(&loc, &pblk->p[0].loc, sizeof(Locator));
    loc.l_sub1 = 0;
    loc.l_sub2 = 0;
    loc.l_subs = 0;
		nErr = _Load(&loc, &val0);
    if (nErr < 0){
			_RetInt(NPPC_LOAD_ERROR,10);
			return;
    }
		val0.ev_type = 'I';
		val0.ev_width = 10;
		_MemMove (&val0.ev_long, &hloc_ptr, 4);
	  nErr = _Store (&loc, &val0);
    if (nErr < 0){
			_RetInt(NPPC_STORE_ERROR,10);
			return;
    }
	
	}
	
	_RetInt(-1*retval,10);

	return;

}

void lna_initialize(ParamBlk FAR *pblk)
/*************************************
 Initialize the NPPC services
	 parameters : SID, user area of SID defines dbf
	 						:	PRI, user area of PRI defines dbf
	 returns		: return value from NPPC 
*/

{
	Value val;
	Locator loc;
	char * idt;
	struct idtbs *tbs;
	struct idtad *tad;
	struct idtps *tps;
	char idtbuffer[200];
	int sidcnt,pricnt,area,stat;
	char junk[80];
	
	/* fix pointers */
	idt = idtbuffer;
	_MemFill(idt,'\0',200);
	tbs = (struct idtbs *) idt;
	
	/* build basic table */
	_StrCpy(tbs->foot,"IND");
	tbs->soff = NPPCBuffer;
	tbs->msgs = MSGSPACE;
	tbs->asst = ASST;
	tbs->conv = CONV;
	tbs->disp = DISP;
	tbs->nets = 0;
	
	/* build sid table */
	tbs++;
	tad = (struct idtad *) tbs;
	
	/* get area number and reset the database */
	
	sidcnt = 0;
	val = pblk->p[0].val;
	area = (int) val.ev_long;
	retval = _DBRewind(area);
	loc.l_type = 'R';
	loc.l_where = area;

	/* go through file and print lines */
	if (_DBRecCount(area) > 0)
		do {
	
			loc.l_offset = 0;
			loc.l_NTI = 1;
			nErr = _Load(&loc, &val);

	    if (nErr < 0){
#ifdef DEBUG
  	  	sprintf(junk,"Error: %d\n",nErr);
    		_PutStr(junk);
#endif
				_RetInt(NPPC_LOAD_ERROR,10);
				return;
  	  }
  	  
			tad->sid = (int) val.ev_real;
			loc.l_offset = 1;
			loc.l_NTI = 1;
			nErr = _Load(&loc, &val);

	    if (nErr < 0){
#ifdef DEBUG
  	  	sprintf(junk,"Error: %d\n",nErr);
    		_PutStr(junk);
#endif
				_RetInt(NPPC_LOAD_ERROR,10);
				return;
  	  }
  	  
			tad->sida = (char) val.ev_real;
		
			/* get next record */

			sidcnt++;
			tad++;
			_DBSkip(area,1L);
			stat = _DBStatus(area);

		}while(!(stat & DB_EOF));       /* until EOF */
	tbs = (struct idtbs *) idt;
	tbs->sidct = sidcnt;


	/* build priority table */
	tps = (struct idtps *) tad;
	
	/* get area number and reset the database */
	

	pricnt = 0;
	val = pblk->p[1].val;
	area = (int) val.ev_long;
	retval = _DBRewind(area);
	loc.l_type = 'R';
	loc.l_where = area;


	/* go through file and print lines */

	if (_DBRecCount(area) > 0)
		do {
			loc.l_offset = 0;
			loc.l_NTI = 1;
			nErr = _Load(&loc, &val);

	    if (nErr < 0){
#ifdef DEBUG
				sprintf(junk,"Error: %d\n",nErr);
				_PutStr(junk);
#endif
				_RetInt(NPPC_LOAD_ERROR,10);
				return;
  	  }
 	  
			tps->sidp = (int) val.ev_real;
			loc.l_offset = 1;
			loc.l_NTI = 1;
			nErr = _Load(&loc, &val);
			
	    if (nErr < 0){
#ifdef DEBUG
  	  	sprintf(junk,"Error: %d\n",nErr);
    		_PutStr(junk);
#endif
				_RetInt(NPPC_LOAD_ERROR,10);
   			return;
  	  }
  	  
			tps->type = (int) val.ev_real;
		
			/* get next record */

			pricnt++;
			tps++;
			_DBSkip(area,1L);
			stat = _DBStatus(area);

		}while(!(stat & DB_EOF));       /* until EOF */
	tbs = (struct idtbs *) idt;
	tbs->prcnt = pricnt;
	
	retval = NA_INITIALIZE(idt);
	_RetInt(retval,10);
}

void lna_stations(ParamBlk FAR *pblk)
/*************************************
 Loads up an integer array with LNID's of stations
	 responding to *ping*
	 parameters : A locator to a dim(15) array initialized to 0
	 returns		: return value from NPPC 
*/
{
	Locator loc;
	Value val;
	int i;
	int stations[16];
	long station;
	
	/* query the network*/
	retval = NA_STATIONS(stations, 16);
	
	/* load up the array */
	for (i=1;i<=stations[0];i++){
    _MemMove (&loc, &(pblk->p[0].loc), sizeof (Locator));  /* copy the loc */
    loc.l_sub1 = i;							/* array element number or zero */
    loc.l_sub2 = 0;
    loc.l_subs = 1;							/* one dimension assumed */
    nErr = _Load (&loc, &val);		/* get the elmt. content */
    if (nErr < 0){
#ifdef DEBUG
    	sprintf(junk,"Error: %d\n",nErr);
    	_PutStr(junk);
#endif
			_RetInt(NPPC_LOAD_ERROR,10);
			return;
    }
		val.ev_type = 'I';
		val.ev_width = 10;
		val.ev_long = 0L;
		station = (long) stations[i];
		_MemMove (&val.ev_long, &station, 4);
	  nErr = _Store (&loc, &val);
    if (nErr < 0){
#ifdef DEBUG
    	sprintf(junk,"Store Error: %d\n",nErr);
    	_PutStr(junk);
#endif
			_RetInt(NPPC_STORE_ERROR,10);
			return;
    }
	}
	_RetInt(-1*retval,10);

}

void lna_hlocs(ParamBlk FAR *pblk)
/*************************************
 Loads up an integer array with contents of HLOC table
	 parameters : A locator to a dim(NUM_HLOCS) array initialized to 0
	 returns		: 0
*/
{
	Locator loc;
	Value val;
	int i;
	
	/* load up the array */
	for (i=0;i<(NUM_HLOCS/2);i++){
		sprintf(junk,"#%d: %lX\t#%d: %lX\n",(i*2),hlocs[(i*2)],i*2+1,hlocs[i*2+1]);
		_PutStr(junk);
	}
	_RetInt(0,10);

}

void lna_terminate(ParamBlk FAR *pblk)
/*************************************
 Shuts down NPPC at this station
	 parameters : none
	 returns		: return value from NPPC 
*/
{
	
	/* shut it down */
	retval = NA_TERMINATE();
	_RetInt(-1*retval,10);

}

void lna_netid(ParamBlk FAR *pblk)
/*************************************
 Loads up an integer array with the network ID
	 parameters : LNID, local ID of node
	 						: NET_ID, A locator to a string length 10
	 returns		: return value from NPPC 
*/
{
	Locator loc;
	Value val;
	int i,lnid;
	char net_id[10];
	long long_id;
	char *str;
	
	val = pblk->p[0].val;
	lnid = val.ev_long;

	/* query the network*/
	retval = NA_NETID(lnid, net_id);
	
	/* load up the message string */
  _MemMove (&loc, &(pblk->p[1].loc), sizeof (Locator));  /* copy the loc */
  loc.l_sub1 = 0;
  loc.l_sub2 = 0;
  loc.l_subs = 0;
  nErr = _Load (&loc, &val);
  if (nErr < 0){
#ifdef DEBUG
    	sprintf(junk,"Error: %d\n",nErr);
    	_PutStr(junk);
#endif
		_RetInt(NPPC_LOAD_ERROR,10);
		return;
  }
	val.ev_length = 10;
	if (! (_SetHandSize (val.ev_handle, val.ev_length)))
		{ _Error (182);                                      /* out of memory */
	}
	str = _HandToPtr (val.ev_handle);
	_HLock(val.ev_handle);
	_MemMove (str, net_id, 10);
	_HUnLock(val.ev_handle);
  nErr = _Store (&loc, &val);
   if (nErr < 0){
#ifdef DEBUG
   	sprintf(junk,"Store Error: %d\n",nErr);
   	_PutStr(junk);
#endif
		_RetInt(NPPC_STORE_ERROR,10);
		return;
   }
	_RetInt(-1*retval,10);

}

void lna_queuecount(ParamBlk FAR *pblk)
/*************************************
 returns the rx or tx queue counts
	 parameters : Function, 1=receive queue size
	 						:						2=transmit (NoWait) queue size
	 returns		: return value from NPPC 
*/
{
	Value val;
	int fn, counts[2];
	
	/* make sure we got right parms */
	val = pblk->p[0].val;
	if (val.ev_type == 'I')
		;
	else{
		_RetInt(NPPC_PARM_ERROR,10);
		return;
	}

	/* get the function */
	fn = (int) val.ev_long;
	
	/* get queuecounts */
	retval = NA_QUEUECOUNT(0xFFFF, &counts);
	if (retval > 0)
		_RetInt(-1*retval,10);
	else
		_RetInt(fn=1 ? counts[0] : counts[1], 10);

	return;
}

void lna_setmsgparms(ParamBlk FAR *pblk)
/*************************************
 Stores network parameters from integer array 
	 parameters : NET_PARMS, A locator to a dim(6) array filled with 
	 						: struct mpl values (in order)
	 returns		: return value from NPPC 
*/
{
	Locator loc;
	Value val;
	int i,lnid,parm;
	struct mpl net_parms;
	
	/* unload the array */
	for (i=1;i<=6;i++){
    _MemMove (&loc, &(pblk->p[1].loc), sizeof (Locator));  /* copy the loc */
    loc.l_sub1 = i;							/* array element number or zero */
    loc.l_sub2 = 0;
    loc.l_subs = 1;							/* one dimension assumed */
    nErr = _Load (&loc, &val);		/* get the elmt. content */
    if (nErr < 0){
#ifdef DEBUG
    	sprintf(junk,"Error: %d\n",nErr);
    	_PutStr(junk);
#endif
			_RetInt(NPPC_LOAD_ERROR,10);
			return;
    }
		switch(i){
			case 1: net_parms.ackwait = val.ev_long;
							break;
			case 2: net_parms.xmitwait = val.ev_long;
							break;
			case 3: net_parms.xmitrty = val.ev_long;
							break;
			case 4: net_parms.sidwait = val.ev_long;
							break;
			case 5: net_parms.sidrty = val.ev_long;
							break;
			case 6: net_parms.srchwait = val.ev_long;
							break;
		}
	}

	/* send to the the network*/
	retval = NA_SETMSGPARMS(&net_parms);
	
	_RetInt(-1*retval,10);

}

void lna_getmsgparms(ParamBlk FAR *pblk)
/*************************************
 Loads up an integer array with the network parameters
	 parameters : NET_PARMS, A locator to a dim(6) array initialized to 0
	 returns		: return value from NPPC 
*/
{
	Locator loc;
	Value val;
	int i,lnid;
	struct mpl net_parms;
	long parm;
	
	/* query the network*/
	retval = NA_GETMSGPARMS(&net_parms);

/****** this is a kludge to fix a problem in the nppc 2.04 code ****/
/*VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV*/

	if(retval == 9){
#ifdef DEBUG
		sprintf(junk,"getparms: %X\n",retval);
		_PutStr(junk);
#endif
		_RetInt(retval,10);
		return;
	}else
		retval = 0;

/*^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^*/
/****** this is a kludge to fix a problem in the nppc 2.04 code ****/
	
	/* load up the array */
	for (i=1;i<=6;i++){
    _MemMove (&loc, &(pblk->p[1].loc), sizeof (Locator));
    loc.l_sub1 = i;
    loc.l_sub2 = 0;
    loc.l_subs = 1;
    nErr = _Load (&loc, &val);
    if (nErr < 0){
#ifdef DEBUG
    	sprintf(junk,"Error: %d\n",nErr);
    	_PutStr(junk);
#endif
			_RetInt(NPPC_LOAD_ERROR,10);
			return;
    }
		val.ev_type = 'I';
		val.ev_width = 10;
		val.ev_long = 0L;
		switch(i){
			case 1: parm = net_parms.ackwait;
#ifdef DEBUG
							sprintf(junk,"Ackwait: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 2: parm = net_parms.xmitwait;
#ifdef DEBUG
							sprintf(junk,"Xmitwait: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 3: parm = net_parms.xmitrty;
#ifdef DEBUG
							sprintf(junk,"Xmitrty: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 4: parm = net_parms.sidwait;
#ifdef DEBUG
							sprintf(junk,"Sidwait: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 5: parm = net_parms.sidrty;
#ifdef DEBUG
							sprintf(junk,"Sidrty: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 6: parm = net_parms.srchwait;
#ifdef DEBUG
							sprintf(junk,"Srchwait: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
		}
		_MemMove (&val.ev_long, &parm, 4);
	  nErr = _Store (&loc, &val);
    if (nErr < 0){
#ifdef DEBUG
    	sprintf(junk,"Store Error: %d\n",nErr);
    	_PutStr(junk);
#endif
			_RetInt(NPPC_STORE_ERROR,10);
			return;
    }
	}
	_RetInt(-1*retval,10);

}

void lna_getmsg(ParamBlk FAR *pblk)
/*************************************
 Gets a message space and loads Fox variables
	 Define a dim(8) array initialized to 0 for the header info
	 parameters : HLOC_IDX, hloc index to this space
	 						:	MSG_HDR, dim(8) array described above
	 						: MSG_BODY, string big enuf for message
	 returns		: 0 if OK
*/
{
	Locator loc;
	Value val;
	int i;
	struct mh FAR *hloc;
	int hloc_ptr;
	char *str;
	long parm;
	
	/* get hloc index */
	val = pblk->p[0].val;
	hloc_ptr = val.ev_long;
	
	/* get hloc pointer */
	hloc = hlocs[hloc_ptr];
	if (hloc == MK_FP(0xFFFF,0xFFFF)){
		_RetInt(NPPC_NO_HLOC_PTR,10);
		return;
	}
#ifdef DEBUG
 	sprintf(junk,"hloc: %lX\n",(long) hloc);
 	_PutStr(junk);
#endif
	
	/* load up the array */
	for (i=1;i<=8;i++){
    _MemMove (&loc, &(pblk->p[1].loc), sizeof (Locator));  /* copy the loc */
    loc.l_sub1 = i;							/* array element number or zero */
    loc.l_sub2 = 0;
    loc.l_subs = 1;							/* one dimension assumed */
    nErr = _Load (&loc, &val);		/* get the elmt. content */
    if (nErr < 0){
#ifdef DEBUG
    	sprintf(junk,"Error: %d\n",nErr);
    	_PutStr(junk);
#endif
			_RetInt(NPPC_LOAD_ERROR,10);
			return;
    }
		val.ev_type = 'I';
		val.ev_width = 10;
		val.ev_long = 0L;
		switch(i){
			case 1: parm = (long) hloc->fn;
#if DEBUG
							sprintf(junk,"fn: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 2: parm = (long) hloc->cc;
#if DEBUG
							sprintf(junk,"cc: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 3: parm = (long) hloc->sid;
#if DEBUG
							sprintf(junk,"sid: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 4: parm = (long) hloc->type;
#if DEBUG
							sprintf(junk,"type: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 5: parm = (long) hloc->lnid;
#if DEBUG
							sprintf(junk,"lnid: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 6: parm = (long) hloc->size;
#if DEBUG
							sprintf(junk,"size: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 7: parm = (long) hloc->ofs;
#if DEBUG
							sprintf(junk,"ofs: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
			case 8: parm = (long) hloc->mxd;
#if DEBUG
							sprintf(junk,"mxd: %ld\n",parm);
							_PutStr(junk);
#endif
							break;
		}
		_MemMove (&val.ev_long, &parm, 4);
	  nErr = _Store (&loc, &val);
    if (nErr < 0){
#ifdef DEBUG
    	sprintf(junk,"Store Error: %d\n",nErr);
    	_PutStr(junk);
#endif
			_RetInt(NPPC_STORE_ERROR,10);
			return;
    }
	}

	/* load up the message string */
  _MemMove (&loc, &(pblk->p[2].loc), sizeof (Locator));  /* copy the loc */
  loc.l_sub1 = 0;							/* array element number or zero */
  loc.l_sub2 = 0;
  loc.l_subs = 0;
  nErr = _Load (&loc, &val);		/* get the elmt. content */
  if (nErr < 0){
#ifdef DEBUG
    	sprintf(junk,"Error: %d\n",nErr);
    	_PutStr(junk);
#endif
		_RetInt(NPPC_LOAD_ERROR,10);
		return;
  }
	val.ev_length = hloc->size;
	if (! (_SetHandSize (val.ev_handle, val.ev_length)))
		{ _Error (182);                                      /* out of memory */
	}
	str = _HandToPtr (val.ev_handle);
	_HLock(val.ev_handle);
	_MemMove (str, ((char *) hloc) + hloc->ofs, hloc->size);
	_HUnLock(val.ev_handle);
  nErr = _Store (&loc, &val);
   if (nErr < 0){
#ifdef DEBUG
   	sprintf(junk,"Store Error: %d\n",nErr);
   	_PutStr(junk);
#endif
		_RetInt(NPPC_STORE_ERROR,10);
		return;
   }
	

	_RetInt(0,10);

}

void lna_setmsg(ParamBlk FAR *pblk)
/*************************************
 Sets a message space and unloads Fox variables
	 Define a dim(6) array initialized to struct mh for the header info
	 Since we never set CC or MXD, leave them out.
	 parameters : HLOC_IDX, hloc index to this space
	 						:	MSG_HDR, dim(6) array described above
	 						: MSG_BODY, string containing message
	 returns		: 0 if OK
*/
{
	Locator loc;
	Value val;
	int i,parm;
	struct mh FAR *hloc;
	int hloc_ptr;
	char *str;
	
	/* get hloc index */
	val = pblk->p[0].val;
	hloc_ptr = val.ev_long;
	
	/* get hloc pointer */
	hloc = hlocs[hloc_ptr];
	if (hloc == MK_FP(0xFFFF,0xFFFF)){
		_RetInt(NPPC_NO_HLOC_PTR,10);
		return;
	}
#ifdef DEBUG
 	sprintf(junk,"hloc: %lX\n",(long) hloc);
 	_PutStr(junk);
#endif
	
	/* load up the array */
	_MemMove (&loc, &(pblk->p[1].loc), sizeof (Locator));  /* copy the loc */
	for (i=1;i<=6;i++){
    loc.l_sub1 = i;							/* array element number or zero */
    loc.l_sub2 = 0;
    loc.l_subs = 1;							/* one dimension assumed */
    nErr = _Load (&loc, &val);		/* get the elmt. content */
    if (nErr < 0){
#ifdef DEBUG
    	sprintf(junk,"Error: %d\n",nErr);
    	_PutStr(junk);
#endif
			_RetInt(NPPC_LOAD_ERROR,10);
			return;
    }
		val.ev_type = 'I';
		val.ev_width = 10;
		val.ev_long = 0L;
		switch(i){
			case 1: hloc->fn = val.ev_real;
#if DEBUG
							sprintf(junk,"fn: %d\n",hloc->fn);
							_PutStr(junk);
#endif
							break;
			case 2: hloc->sid = val.ev_real;
#if DEBUG
							sprintf(junk,"sid: %d\n",hloc->sid);
							_PutStr(junk);
#endif
							break;
			case 3: hloc->type = val.ev_real;
#if DEBUG
							sprintf(junk,"type: %d\n",hloc->type);
							_PutStr(junk);
#endif
							break;
			case 4: hloc->lnid = val.ev_real;
#if DEBUG
							sprintf(junk,"lnid: %d\n",hloc->lnid);
							_PutStr(junk);
#endif
							break;
			case 5: hloc->size = val.ev_real;
#if DEBUG
							sprintf(junk,"size: %d\n",hloc->size);
							_PutStr(junk);
#endif
							break;
			case 6: hloc->ofs = val.ev_real;
#if DEBUG
							sprintf(junk,"ofs: %d\n",hloc->ofs);
							_PutStr(junk);
#endif
							break;
		}
	}

	/* load up the message string */
	val = pblk->p[2].val;
	_HLock(val.ev_handle);
	str = _HandToPtr(val.ev_handle);
	_MemMove ((char *) hloc + 16, str, val.ev_length);
	_HUnLock(val.ev_handle);

	_RetInt(0,10);

}

/* tell linker we are not doing floating point math */
void _fltused()
   {

   }

FoxInfo myFoxInfo[] = {
	{"INIT",				lna_init,					-2,	""},
	{"DEINIT",			lna_deinit,				-3,	""},
	{"GETSPACE",		lna_getspace,			1,	"I"},
	{"FREESPAE",		lna_freespace,		1,	"I"},
	{"TRANSMIT",		lna_transmit,			1,	"I"},
	{"DISCONCT",		lna_disconnect,		1,	"I"},
	{"RESULT",			lna_result,				0,	""},
	{"RECEIVE",			lna_receive,			4,	"R,I,.I,.I"},
	{"INITIALI",		lna_initialize,		2,	"I,I"},
	{"STATIONS",		lna_stations,			1,	"R"},
	{"TERMINAT",		lna_terminate,		0,	""},
	{"NETID",				lna_netid,				2,	"I,R"},
	{"QUEUECNT",		lna_queuecount,		1,	"I"},
	{"SETMSGPM",		lna_setmsgparms,	1,	"R"},
	{"GETMSGPM",		lna_getmsgparms,	1,	"R"},
	{"GETMSG",			lna_getmsg,				3,	"I,R,R"},
	{"SETMSG",			lna_setmsg,				3,	"I,R,C"},
	{"HLOCS",				lna_hlocs,				0,	""}
};

FoxTable _FoxTable = {
	(FoxTable FAR *)0, sizeof(myFoxInfo) / sizeof(FoxInfo), myFoxInfo
};
