* -- PROGRAM NAME: .......... CI_INT.PRG
* -- PROGRAM TITLE: ......... Compound Interest: Interest Rate
* -- AUTHOR: ................ Venkat Penugonde, Irvine Micro Arts, Irvine, CA
* -- DATE FIRST CREATED .............. 05/10/86
* -- DATE MOST RECENTLY MODIFIED .....
*
*  This program calculates interest rate [annual & per period]
*   in a compound interest calculation given the following:
*
*    principal =  Present value or principal
*    fu_value  =  Value at the end of the total time period
*    y_period  =  Number of compounding periods per year
*    t_period  = Total number of compounding periods
*
SET TALK OFF
CLEAR
 principal = 0.00
 fu_value  = 0.00
 t_period  = 0
 y_period  = 0
*
@  2, 17 SAY '            COMPOUND INTEREST'
@  3, 17 SAY '              INTEREST RATE'
@  5, 17 SAY 'PRINCIPAL [enter zero to exit]: . '
@  7, 17 SAY 'FUTURE VALUE .................... '
@  9, 17 SAY 'COMPOUNDING PERIODS PER YEAR: ... '
@ 11, 17 SAY 'NUMBER OF COMPOUNDING PERIODS: .. '
*
DO WHILE .t.
 @ 5, 51 GET principal
 READ
 IF principal <= 0
   EXIT
  ELSE
   @  7, 51 GET fu_value
   @  9, 51 GET y_period
   @ 11, 51 GET t_period
   READ
 ENDIF
 *
 * ----- Compute interest rate
 mvar1 = (1/t_period) * LOG(fu_value/principal)
 mvar2 = EXP(mvar1)
 int_rate = (mvar2 - 1)*100
 ann_rate = int_rate*y_period
 *
 @ 15, 17 SAY 'Interest Rate per Period --> ' + STR(int_rate, 10, 2)
 @ 17, 17 SAY 'Annual Interest Rate -->     ' + STR(ann_rate, 10, 2)
ENDDO WHILE .t.
RETURN
* -- EOF CI_INT