;    Exactime.asm.  Get time accurate to the standard clock limit of
;    1/18 sec and return it to an eleven-char variable passed by dBASE
;    in the form "HH:MM:SS.SS"

;    Programmer : Jay Parsons (Jparsons)
;    Date       : 04/27/92
;    Notes      : Gets the DOS time, not the time from the CMOS clock
;                 if one is installed.  Requires an 11-charcater variable,
;                 not constant, as a parameter.  Returns 24-hour time.
;    Usage      : LOAD Exactime
;                 Thistime = space(11)
;                 CALL Exactime WITH Thistime
;                 ? Thistime
;    Parameters : One variable of 11 chars to hold the time string returned.
;---------------------------------------------------------------------------

                .MODEL tiny

                .CODE

Exactime:       mov ah,2ch              ; DOS time call
                int 21h                 ; DOS services interrupt
                mov al,ch               ; get hours
                call put
                mov al,cl               ; minutes
                call put
                mov al,dh               ; seconds
                call put
                mov al,dl               ; "hundredths"
                call put
                mov [bx - 4],'.'        ; add separators
                mov [bx - 7],':'
                mov [bx - 10],':'
                retf                    ; and done

put:            aam                     ; 10s in ah, rest al
                xchg ah,al              ; put high value lower
                add ax,3030h            ; convert to ASCII digits
                mov [bx],ax             ; store back-words in variable
                add bx,3                ; bump bx by 3
                ret

                end Exactime
