**********************************************************************
* DOS3D driver for GENSCRNX
***************************
*  Version 1.30  -  07/08/94
*
*  written by:  Rick Strahl  -  CIS #:76427,2363
*               West Wind Technologies
*               400 Morton Road
*               Hood River, Oregon 97031
*               ---------------------------------
*               (503) 386-2087
*
*   copyright:  none (Public Domain)
*
*   Special thanks to Randy Pearsen for contributing
*   some valuable fixes and suggestions to this driver and
*   helping me understand GSX drivers better.
*
**********************************************************************
*  This driver implements a drop shadow on any DOS object that includes
*  the *:DOS3D directive in its comment clause. The default driver
*  will create a dropshadow below and to the right of the object
*  by drawing a raised black line on the default color scheme
*  background color underneath an object. By default all *buttons*
*  are set to a specific color pair sequence (see below/you can
*  change it if you like), *unless* a specific color scheme was chosen
*  using the COLOR option in the screen builder or by using the
*  NOBCOLOR clause. Monochrome buttons are left unchanged...
***********************************************************************
*   Usage:
*   ------
*      Setup Snippet:  *:SCXDRV5 DOS3D
*                      *:DOS3D_ALLBUTTONS
*                      *:DOS3D_ALLOBJECTS
*
*    Comment Snippet:  *:DOS3D
*                      *:DOS3D NOBCOLOR    - don't change button color
*                      *:DOS3D OFF         - don't do shadow
***********************************************************************
PRIVATE m.lnvpos,m.lnhpos,m.lnheight,m.lnwidth,;
   m.lnwcols,m.lnwrows,m.llhrztl,m.lnspacing,m.lnx,m.lnbuttons,;
   m.lnrecno,m.llAllButtons

*** Requires Genscrnx 2.0 or above
IF VAL(m.gsxversion) < 2
   = Warning("DOS3D.PRG requires GenScrnX 2.0 or later.")
   *** Drop out of driver
   GOTO BOTTOM
   RETURN
ENDIF

*** Only look at DOS header...
IF objtype#1 OR platform#"DOS"
   *** Drop out of driver
   GOTO BOTTOM
   RETURN
ENDIF

*** Button Type
#DEFINE TEXTTYPE 5
#DEFINE BUTTONTYPE 12
#DEFINE RADIOTYPE 13
#DEFINE CHECKTYPE 14
#DEFINE INVBUTTONTYPE 20

#DEFINE CR CHR(13)

*** Check for All Button Option
IF WordSearch("*:DOS3D_ALLBUTTONS","SETUPCODE") = m.null
   m.llAllbuttons=.F.
ELSE
   m.llAllbuttons=.T.
ENDIF

*** Check for All Object Option
IF WordSearch("*:DOS3D_ALLOBJECTS","SETUPCODE") = m.null
   m.llAllObjects=.F.
ELSE
   m.llAllObjects=.T.
ENDIF

*** Save Window sizes
m.lnwcols=WIDTH
m.lnwrows=HEIGHT

*** Figure out reverse color for the shadow (revcol)
*** and set the default button color pair (TBC) -
*** create vars so it fits in the colorpair 8 byte size
*** Add it to screen's setup code. The variables REVCOL and
*** TBC are named in this fashion so they can fit into the
*** 8 byte SCHEME field of the screen database!
REPLACE setupcode WITH setupcode+CR+;
   '*-: DOS3D 1.11: Setup for shadow background and button colors'+CR+;
   'PRIVATE D3D_SCHEME,revcol,TBC'+CR+;
   'D3D_SCHEME=scheme('+STR(SCHEME,2)+',1)'+CR+;
   'revcol="N/"+SUBSTR(D3D_SCHEME,AT("/",D3D_SCHEME)+1)'+CR+;
   'TBC=IIF("MONO" $ upper(sys(2006)),"","N/B,W+/BG,GR+/W,GR+/W,BG/W,W+/GR,B/W,N+/N,W+/W,BG/W,+") '


*** Stuff ALLOBJECTS or ALLBUTTONS into appropriate objects
IF m.llAllButtons OR m.llAllObjects
   *** Skip header record
   GOTO m.r_scxdata

   SCAN REST FOR ;
         !DELETED() AND;
         (m.llAllButtons AND ;
         ObjType=BUTTONTYPE OR ;
         m.llAllObjects AND ;
         !INLIST(objtype,RADIOTYPE,TEXTTYPE,CHECKTYPE,INVBUTTONTYPE))

      *** Check for existing *:DOS3D
      IF WordSearch("*:DOS3D") = m.null AND ;
            WordSearch("*-:DOS3D") = m.null

         *** Now stuff in the directive
         DO WordStuff WITH "*:DOS3D", .T.
      ENDIF
   ENDSCAN
ENDIF

*** Skip Header Record
GOTO m.r_scxdata

*** Scan for each instance of *:DOS3D objects
SCAN REST FOR ;
      wordsearch("*:DOS3D","COMMENT")#m.null AND ;
      NOT DELETED()

   *** *:DOS3D OFF directive - don't process
   IF wordsearch("*:DOS3D")="OFF"
      LOOP
   ENDIF

   *** Save the coordinates and sizes of original object
   m.lnhpos=hpos
   m.lnvpos=vpos
   m.lnheight=HEIGHT
   m.lnwidth=WIDTH
   m.lnspacing=spacing

   *** Buttons may be multi-buttons so count them
   *** and figure out direction
   IF objtype=BUTTONTYPE

      *** Picture format is "@*HN \!\<Ok;\?\<Cancel"
      *** The quotation marks *are* stored in the Picture field!!!

      m.lnbuttons=1

      *** Multi-buttns have ';' - Count these and add to default of 1
      DO WHILE AT(";",PICTURE,m.lnbuttons)>0
         m.lnbuttons=m.lnbuttons+1
      ENDDO

      *** Which way do the buttons run?
      *** 4th character holds H/V for direction
      m.llhrztl=.T.
      IF SUBSTR(PICTURE,4,1)="V"
         m.llhrztl=.F.
      ENDIF
   ELSE
      *** Single Object - Defaults
      m.lnbuttons=1
      m.llhrztl=.T.
   ENDIF

   *** Automatically change the button color
   *** unless a scheme is selected in screen builder
   *** or the *:DOS3D NOBCOLOR variation is used.
   IF objtype=BUTTONTYPE .AND. SCHEME=0 .AND. ;
         wordsearch("*:DOS3D","COMMENT")#"NOBCOLOR"

      REPLACE colorpair WITH "(TBC)",SCHEME WITH 0
   ENDIF

   *** Change the *:DOS3D to *-:DOS3D to prevent reprocessing
   REPLACE Comment WITH StrTranC(Comment,"*:DOS3D","*-:DOS3D")

   *** Copy comment snippet to new objects
   *** box objects inherit methods like *:IF
   m.lcComment=comment

   *** Loop trough item objects - usually 1 except on multi buttons
   FOR m.lnx=1 TO m.lnbuttons

      *** Adjust offset for 2nd/3rd etc. buttons - horizontally
      IF m.lnx>1 AND m.llhrztl
         *** Add the width + spacing to the hpos
         m.lnhpos=m.lnhpos+(m.lnwidth+m.lnspacing)
      ENDIF

      *** Adjust offset for 2nd/3rd etc. buttons - vertically
      IF m.lnx>1 AND !m.llhrztl
         *** Add the height + spacing to the vpos
         m.lnvpos=m.lnvpos+(m.lnheight+m.lnspacing)
      ENDIF

      *** Draw shadow only if it will fit on screen
      IF m.lnhpos+m.lnwidth<=m.lnwcols-3 AND ;
            m.lnvpos+m.lnheight<=m.lnwrows-3

         *** Add a new screen object for the line below
         IF insrec()
            REPLACE hpos WITH m.lnhpos+1,vpos WITH m.lnvpos+m.lnheight,;
               HEIGHT WITH 1, WIDTH WITH m.lnwidth,;
               objtype WITH 7, objcode WITH 7,platform WITH "DOS",;
               boxchar WITH "",colorpair WITH "(revcol)",;
               comment WITH m.lcComment
         ENDIF

         *** Add new screen object for the line to the right
         IF m.lnheight>1
            IF insrec()
               REPLACE hpos WITH m.lnhpos+m.lnwidth,;
                  vpos WITH m.lnvpos+1,;
                  HEIGHT WITH m.lnheight-1, WIDTH WITH 1,;
                  objtype WITH 7, objcode WITH 7,platform WITH "DOS",;
                  boxchar WITH "",colorpair WITH "(revcol)",;
                  comment WITH m.lcComment
            ENDIF
         ELSE
            *** Just a single half height box character
            IF insrec()
               REPLACE hpos WITH m.lnhpos+m.lnwidth,;
                  vpos WITH m.lnvpos,;
                  HEIGHT WITH 1, WIDTH WITH 1,;
                  objtype WITH 5, objcode WITH 0,platform WITH "DOS",;
                  expr WITH '""',colorpair WITH "(revcol)",;
                  comment WITH m.lcComment
            ENDIF
         ENDIF

      ENDIF
   ENDFOR

ENDSCAN

RETURN
