 * Program .....: Dissapp.PRG
 * Author ......: Jeffrey McCrimon
 * Date ........: February 1, 1988
 * Version .....: dBASE III PLUS
 * Notes .......: Program to append from a database file with 
 *                different field names and, possibly, data types.
 *
 *                The database file to which data is to be appended must be
 *                in use in workarea 1. To start the program enter 
 *
 *                DO Dissapp
 *
 *                at the dot prompt.
 *
 * --- Set up environment.
 SET TALK OFF
 SET STATUS OFF
 SET SCOREBOARD ON
 SET EXACT ON
 SET ESCAPE ON
 SET CONFIRM ON
 SET COLOR TO W/N
 
 SET PROCEDURE TO Apputil
 ON ESCAPE DO Escback
 *
 * ---Initialize variables.
 *
 null    = ""
 blank   = SPACE(10)
 esckey  = 27
 uparrow = 5
 dnarrow = 24
 delkey  = 7
 f10key  = -9
 retkey  = 13
 pgdnkey = 3
 pgupkey = 18
 homekey = 1
 endkey  = 6
 
 waitmsg = LEFT(" Setting up please wait..." + SPACE(80), 80)
 helpmsg = "  Return to Change Field Name  " + CHR(186) + ;
           "  F10 Append  " + CHR(186) + ;
           "  ESC to Quit Without Appending  "
 editmsg = " Move highlight or type the field name to" + ;
           " use, then press " + CHR(17) + CHR(196) + CHR(217) + " "
 *
 * ---If no database file is open, complain and quit.
 *
 tdbfname = DBF()
 IF null  = tdbfname
    @ 22,1 SAY "You must have a database file in use!"
    RETURN
 ENDIF
 * ---Get database file to append from.
 DO WHILE .T.
    sdbfname = SPACE(12)
    CLEAR
    @ 5,5 SAY "Enter the name of the .DBF file to Append" ;
          GET sdbfname
    READ
    sdbfname = TRIM(LTRIM(sdbfname))
    * ---Strip directories.
    DO WHILE "\" $ sdbfname
       sdbfname = STUFF(sdbfname, 1, AT("\", sdbfname), "")
    ENDDO
    * ---Add .DBF extension if user didn't.
    IF .NOT. "." $ sdbfname
       sdbfname = sdbfname + ".DBF"
    ENDIF
    * ---If the file doesn't exist, we can try for another,
    * ---or just quit.
    IF .NOT. FILE("&sdbfname")
       @ 21, 1 SAY "File does not exist!"
       isagain = .T.
       @ 22, 1 SAY "Do you want to try another .DBF file? (Y/N)";
               GET isagain PICTURE "Y"
       READ
       IF isagain
          * ---Go back for another filename.
          LOOP
       ENDIF
       * ---Quit.
       RETURN
    ENDIF
    * ---File exists. Exit this loop and go on.
    EXIT
 ENDDO
 CLEAR
 DO Drawscr
 SET COLOR TO N/W
 @ 22, 0 SAY waitmsg
 SET COLOR TO W/N
 * ---Open file to append from.
 SELECT 2
 USE &sdbfname
 * ---Count fields in the two databases.
 STORE 0 to sfields, tfields
 DO Numfield WITH tdbfname, tfields
 DO Numfield WITH sdbfname, sfields
 * ---Build a memory variable "array" of the source database file
 * ---field names.
 fieldcnt = "1"
 DO WHILE VAL(fieldcnt) <= tfields
    srcfld&fieldcnt = FIELD(VAL(fieldcnt))
    fieldcnt = LTRIM(STR(VAL(fieldcnt) + 1))
 ENDDO
 cursfield = 1
 curtfield = 1
 srow      = 8
 scol      = 17
 selfield  = 1
 SET COLOR TO N/W
 @ 22, 0 SAY helpmsg
 SET COLOR TO W/N
 DO WHILE .T.
    * ---Fill column 1 with source field names and
    * ---column 2 with destination field names.
    *
    SELECT 2
    nodsfield = 0
    DO Dispflds WITH 8, 17, 20, tfields, cursfield, nodsfield, "S"
    SELECT 1
    nodtfield = 0
    DO Dispflds WITH 8, 42, 20, tfields, curtfield, nodtfield, "T"
    *
    * ---A key is collected with INKEY() then processed until
    * ---all the fields have been assigned, or Escape is pressed
    * ---to abort.
    *
    SELECT 2
    DO WHILE .T.
       *
       * ---Make a macro for accessing memory variable.
       fldmac = "srcfld" + LTRIM(STR(selfield))
       * ---Highlight the current source field name.
       SET COLOR TO N/W
       @ srow, scol SAY LEFT(&fldmac + blank, 10)
       SET COLOR TO W/N
       *
       * ---Get a key.
       keyhit = 0
       DO WHILE keyhit = 0
          keyhit = INKEY()
       ENDDO
       *
       * ---Process the key.
       DO CASE
          CASE keyhit = homekey
               * ---Go to top of column.
               IF selfield = 1 .OR. MOD(selfield, 13) = 0
                  * ---Already at top of column; do nothing.
                  LOOP
               ENDIF
               @ srow, scol SAY LEFT(&fldmac + blank, 10)
               selfield = INT((selfield - 1) / 12) * 12 + 1
               srow = 8
               LOOP
          CASE keyhit = endkey
               * ---Go to bottom of column.
               IF selfield = tfields .OR. MOD(selfield, 12) = 0
                  * ---Already at bottom of column, do nothing.
                  LOOP
               ENDIF
               IF MOD(nodtfield, 12) = 0
                  @ srow, scol SAY LEFT(&fldmac + blank, 10)
                  selfield = INT((selfield - 1) / 12) * 12 + 12
                  srow = 19
                  LOOP
               ELSE
                  * ---Go to bottom of -last- column.
                  @ srow, scol SAY LEFT(&fldmac + blank, 10)
                  srow = nodtfield + 7
                  selfield = tfields
                  LOOP
               ENDIF
          CASE keyhit = pgdnkey
               * ---Scroll to next screen.
               IF curtfield - 1 < tfields
                  selfield = INT((curtfield - 1) / 12) * 12 + 1
                  srow = 8
                  EXIT
               ENDIF
          CASE keyhit = pgupkey
               * ---Scroll to previous screen.
               IF selfield > 12
                  curtfield = INT((selfield - 13) / 12) * 12 + 1
                  cursfield = curtfield
                  selfield = selfield - 12
                  EXIT
               ENDIF
          CASE keyhit = esckey
               * ---Abort.
               EXIT
          CASE keyhit = delkey
               * ---Remove field assignment.
               SET COLOR TO N/W
               @ srow, scol SAY blank
               STORE null TO &fldmac
               LOOP
          CASE keyhit = dnarrow
               * ---Select next field.
               IF selfield + 1 < curtfield .AND. srow + 1 < 20
                  * ---Not currently at bottom of screen and
                  * ---there are more fields.
                  @ srow, scol SAY LEFT(&fldmac + blank, 10)
                  srow = srow + 1
                  selfield = selfield + 1
                  LOOP
               ELSE
                  IF srow = 19 .AND. selfield < curtfield
                     * ---At bottom of screen and there are previous
                     * ---fields. Select the field at the top.
                     srow = 8
                     selfield = selfield + 1
                     EXIT
                  ENDIF
               ENDIF
               LOOP
          CASE keyhit = uparrow
               IF selfield - 1 > 0 .AND. srow - 1 > 7
                  * ---Not at top of field list or at top
                  * ---of column.
                  @ srow, scol SAY LEFT(&fldmac + blank, 10)
                  selfield = selfield - 1
                  srow = srow - 1
                  LOOP
               ELSE
                  IF MOD(selfield, 13) = 0
                     * ---We're at the top of the column.
                     * ---Select field at the bottom.
                     selfield = selfield - 1
                     srow = 19
                     curtfield = INT((curtfield - 12) / 12) * 12 + 1
                     cursfield = curtfield
                     EXIT
                  ENDIF
               ENDIF
          CASE keyhit = retkey
               * ---Display source fields list and get the field.
               temp = null
               DO Getfield WITH temp
               * ---Redisplay prompts.
               SET COLOR TO N/W
               @ 22,  0 SAY helpmsg
               SET COLOR TO W/N
               IF null <> temp
                  * ---Display the selected fieldname.
                  SET COLOR TO N/W
                  @ srow, scol SAY LEFT(temp + blank, 10)
                  SELECT 2
                  &fldmac = temp
               ENDIF
               LOOP
          CASE keyhit = f10key
               * ---Execute the Append.
               SET COLOR TO N/W
               @ 22, 0 SAY waitmsg
               DO Replacer
               EXIT
       ENDCASE
    ENDDO
    IF keyhit = esckey .OR. keyhit = f10key
       * ---If Escape or F10 was pressed we're done.
       EXIT
    ENDIF
 ENDDO
 *
 * ---Set things back to normal.
 SET COLOR TO
 SELECT 2
 USE
 SELECT 1
 CLEAR
 ON ESCAPE
 CLOSE PROCEDURE
 SET TALK ON
 RETURN
 * EOP Append.PRG
