* Utilities and Procedures for Append.PRG
*
PROCEDURE Dispflds
*
* ---Display a list of fields. This procedure displays
* ---source fields, destination fields, or source selection list.
*
PARAMETERS row, col, limit, nofields, fieldno, fldcount, type
drow = row
dcol = col
@ drow, dcol CLEAR TO limit -  1, dcol + 10
DO WHILE fieldno < nofields + 1 .AND. drow < limit
   field = IIF(type = "S", "srcfld", "FIELD()")
   field = STUFF(field, 7, 0, LTRIM(STR(fieldno)))
   IF null = &field .AND. type = "T"
      * ---Quit if last field in target database.
      EXIT
   ENDIF
   @ drow, dcol SAY &field
   fieldno  = fieldno + 1
   drow     = drow + 1
   fldcount = fldcount + 1
ENDDO
RETURN
* EOP: Dispflds.PRG

PROCEDURE Drawscr
*
* ---Display background screen.
*
@  1,  2 SAY "APPEND FROM DISSIMILAR FILE"
@  2,  1 TO  2, 79
@  4, 15 TO  7, 35
@  5, 19 SAY "Source Fields"
@  6, 19 SAY "   on Disk   "
@  7, 15 TO 20, 35
@  7, 15 SAY CHR(195)
@  7, 35 SAY CHR(180)
@  4, 40 TO  7, 60
@  5, 44 SAY "Target Fields"
@  6, 43 SAY "in Current File"
@  7, 40 TO 20, 60
@  7, 40 SAY CHR(195)
@  7, 60 SAY CHR(180)
SET COLOR TO W/N
RETURN
* EOP: Drawscr

PROCEDURE Escback
*
* ---Trap Escape key and return with no interruption.
*
keyhit = esckey
RETURN
* EOP: Escback

PROCEDURE Numfield
PARAMETERS dbfname, numfields
* ---Procedure to count the fields in a database.
*
* ---Construct alias name by removing file extension,
* ---drive indicator, and subdirectories from filename.
*
IF AT (":", dbfname) = 2
   dbfname = SUBSTR(dbfname, 3)
ENDIF
IF ":" $ dbfname
   dbfname = SUBSTR(dbfname, 1, AT(".", dbfname) -1)
ENDIF
DO WHILE "\" $ dbfname
   dbfname = STUFF(dbfname, 1, AT("\", dbfname), null)
ENDDO
SELECT &dbfname
* ---Step through fields until the next one is empty.
DO WHILE null <> FIELD(numfields + 1)
   numfields = numfields + 1
ENDDO
RETURN
* EOP: Numfield


PROCEDURE Replacer
* ---This procedure performs the append.
sfieldno = "1"
tfieldno = "1"
SELECT 1
* ---First, build formulas to convert source data type to
* ---destination data type.
DO WHILE VAL(tfieldno) <= tfields
   SELECT 2
   IF null <> srcfld&tfieldno
      sfname = "sfld" + sfieldno
      tfname = "tfld" + sfieldno
      STORE srcfld&tfieldno TO &sfname
      SELECT 1
      STORE FIELD(VAL(tfieldno)) TO &tfname
      tfieldtype = TYPE("tfname")
      SELECT 2
      sfieldtype = TYPE("sfname")
      DO CASE
      CASE tfieldtype = "C"
         * ---Target field type is character.
         DO CASE
         CASE sfieldtype = "C"
            sfldxpr&sfieldno = "B->" + &sfname
         CASE sfieldtype = "N"
            sfldxpr&sfieldno = "STR(B->" + &sfname + "," +;
                                STR(LEN(&sfname), 2) + ")"
         CASE sfieldtype = "D"
            sfldxpr&sfieldno = "DTOC(B->" + &sfname + ")"
         CASE sfieldtype = "L"
            sfldxpr&sfieldno = "IIF(B->" + &sfname + ", [T], [F])"
         ENDCASE
      CASE tfieldtype = "D"
         * ---Target field type is Date.
         DO CASE
         CASE sfieldtype = "C"
            sfldxpr&sfieldno = "CTOD(B->" + &sfname + ")"
         CASE sfieldtype = "D"
            sfldxpr&sfieldno = "B->" + &sfname
         ENDCASE
      CASE tfieldtype = "N"
         * ---Target field type is numeric.
         DO CASE
         CASE sfieldtype = "C"
            sfldxpr&sfieldno = "VAL(B->" + &sfname + ")"
         CASE sfieldtype = "N"
            sfldxpr&sfieldno = "B->" + &sfname
         CASE sfieldtype = "L"
            sfldxpr&sfieldno = "IIF(B->" + &sfname + ", 1, 0)"
         ENDCASE
      CASE tfieldtype = "L"
         * ---Target field type is logical.
         DO CASE
         CASE sfieldtype = "L"
            sfldxpr&sfieldno = "B->" + &sfname
         CASE sfieldtype = "C"
            sfldxpr&sfieldno = "LEFT(B->" + &sfname + ", 1) $ [TtYy]"
         CASE sfieldtype = "N"
            * ---Source data is numeric. 1 is .T., anything else .F.
            sfldxpr&sfieldno = "B->" + &sfname + " = 0"
         ENDCASE
      ENDCASE
      * ---Select next source field.
      sfieldno = LTRIM(STR(VAL(sfieldno) + 1))
   ENDIF
   * ---Select next target field.
   tfieldno = LTRIM(STR(VAL(tfieldno) + 1))
ENDDO
*
* ---Do the append.
*
SELECT 1
GO TOP
SELECT 2
reccount = LTRIM(STR(RECCOUNT()))
recmsg = LEFT("Appending " + sdbfname + ": " + SPACE(LEN(reccount)) +;
         " of " + reccount + " appended." + SPACE(80), 80)
@ 22, 0 SAY recmsg
GO TOP
recno = 1
DO WHILE .NOT. EOF()
   SELECT 1
   APPEND BLANK
   scount = "1"
   * ---Status message.
   @ 22,  12 + LEN(sdbfname) SAY STR(recno, LEN(reccount))
   * ---Step through each source field.
   DO WHILE VAL(scount) < VAL(sfieldno)
      * ---Build macros to access data.
      tf = "tfld" + scount
      sf = "sfldxpr" + scount
      target = &tf
      source = &sf
      REPLACE &target WITH &source
      * ---Next source field.
      scount = LTRIM(STR(VAL(Scount) + 1))
   ENDDO
   * ---Next source record.
   SELECT 2
   recno = recno + 1
   SKIP
ENDDO
RETURN
* EOP: Replacer

PROCEDURE Getfield
* ---Select fields from list of source fields.
PARAMETERS getfield
PRIVATE srow, keyhit, scol
curfield = 1
srow = 8
hfield = 1
fn = null
@  7, 63 TO 20, 75
@  7, 64 SAY "Fields"
SET COLOR TO N/W
@ 22,  0 SAY editmsg
SET COLOR TO W/N
@ 22, COL()
DO WHILE .T.
   nodispflds = 0
   DO Dispflds WITH 8, 64, 20, sfields, curfield, nodispflds, "T"
   DO WHILE .T.
      SET COLOR TO N/W
      @ srow, 64 SAY FIELD(hfield)
      IF LEN(TRIM(fn)) = 0
         scol = 63
         @ 22, 63 SAY BLANK
         @ 22, 63 SAY FIELD(hfield)
         @ 22, 63 SAY null
      ELSE
         @ 22, 63 SAY fn
      ENDIF
      SET COLOR TO W/N
      scol = COL()
      keyhit = 0
      DO WHILE keyhit = 0
         keyhit = INKEY()
      ENDDO
      DO CASE
      CASE ISALPHA(CHR(ABS(keyhit)))
         * ---A letter was entered.
         SET COLOR TO N/W
         IF LEN(TRIM(fn)) = 0
            @ 22, scol +  1 SAY BLANK
         ENDIF
         @ 22, scol SAY UPPER(CHR(keyhit))
         fn = fn + UPPER(CHR(keyhit))
         scol = scol + 1
         LOOP
      CASE keyhit = homekey
         fn = null
         IF hfield = 1 .OR. MOD(hfield, 13) = 0
            LOOP
         ENDIF
         @ srow, 64 SAY FIELD(hfield)
         hfield = INT((hfield - 1) / 12) * 12 + 1
         srow = 8
         LOOP
      CASE keyhit = endkey
         fn = null
         IF hfield = sfields .OR. MOD(hfield, 12) = 0
            LOOP
         ENDIF
         IF nodispflds = 12 .OR. MOD(nodispflds, 12) = 0
            @ srow, 64 SAY FIELD(hfield)
            hfield = INT((hfield - 1) / 12) * 12 + 12
            srow = 19
            LOOP
         ENDIF
         @ srow, 64 SAY FIELD(hfield)
         srow = nodispflds + 7
         hfield = sfields
         LOOP
      CASE keyhit = pgdnkey
         fn = null
         IF curfield - 1 < sfields
            hfield = (INT((curfield - 1) / 12) * 12) + 1
            srow = 8
            EXIT
         ENDIF
      CASE keyhit = pgupkey
         fn = null
         IF hfield > 12
            curfield = (INT((hfield - 13) / 12) * 12) + 1
            hfield = hfield - 12
            EXIT
         ENDIF
      CASE keyhit = esckey
         getfield = null
         EXIT
      CASE keyhit = dnarrow
         fn = null
         IF hfield <= curfield .AND. srow < 21
            @ srow, 64 SAY FIELD(hfield)
            srow = srow + 1
            hfield = hfield + 1
            LOOP
         ENDIF
         IF srow = 19 .AND. hfield < curfield
            srow = 8
            hfield = hfield + 1
            EXIT
         ENDIF
      CASE keyhit = uparrow
         fn = null
         IF MOD(hfield, 13) = 0
            hfield = hfield - 1
            srow = 19
            curfield = (INT((curfield - 12) / 12) * 12) + 1
            EXIT
         ENDIF
         IF hfield > 1 .AND. srow > 8
            @ srow, 64 SAY FIELD(hfield)
            srow = srow - 1
            hfield = hfield - 1
            LOOP
         ENDIF
      CASE keyhit = retkey
         getfield = IIF(LEN(TRIM(fn)) = 0, FIELD(hfield), fn)
         EXIT
      ENDCASE
   ENDDO
   IF keyhit = retkey .OR. keyhit = esckey
      EXIT
   ENDIF
ENDDO
@  7, 63 CLEAR TO 20, 75
RETURN
* EOP: Getfield
