CLOSE DATA
vc_CurDir = ""
vc_SelDir = GETDIR("C:\"," Select Directory ")
IF EMPTY(vc_SelDir)
	RETURN
ENDIF
SET DEFAULT TO (vc_SelDir)
SELECT 1
* 
* load array ac_Tables with dbf files from selected
* directory,  exit if no dbf files 
* 
=ADIR(ac_Tables,"*.DBF")
IF ADIR(ac_Tables,"*.DBF") = 0
	WAIT WINDOW "No Tables in Selected Directory" NOWAIT
	RETURN
ENDIF
* 
* sort array ac_Tables
* 
WAIT WINDOW "Working, please wait" NOWAIT
=ASORT(ac_Tables,1)
* 
* create cursor to contain dbf, tag, and tag expr
* 
CREATE CURSOR DbfCdx (Table C(12), Tag C(10), Expr M(10))
* 
* process each dbf in the array ac_Tables
* 
FOR I = 1 TO ALEN(ac_Tables,1)
	m.table = ac_Tables[I,1]
* 
* this is the current resource file
* 
	IF SYS(2014,SYS(2005)) = m.table
		LOOP
	ENDIF
	IF NOT USED(m.table)
		USE (m.table) IN SELECT(1)
		SELECT (m.table)
* 
* find all tags for current table.
* the function TAG(exprN) returns the tag name.  Each tag 
* a for loop is used to process each tag, until no
* more tags exist for current table

* 
		FOR J = 1 TO 50
* 
* TAG(J) is empty: no tags or last tag
* 
			IF EMPTY(TAG(J))
* 
* if J is 1, there are no tags for this table,
* fill cursor with record indicating this 
* 
				IF J = 1
					m.tag = "No Tags"
					m.expr = ""
					INSERT INTO DbfCdx FROM MEMVAR
				ENDIF
* 
* if j > 1, this is last tag for this table, so exit
* 
				EXIT
			ELSE
* 
* TGA(J) contains a tag, store the name of the tag
* and the expression for the tag to memvars
* and add record to cursor DbfCdx
* 
				m.tag = TAG(J)
				m.expr = SYS(14,J)
				INSERT INTO DbfCdx FROM MEMVAR
			ENDIF
		ENDFOR
		USE
	ENDIF
ENDFOR
* 
* report from created cursor file
* 
SELECT DbfCdx
DO CASE
	CASE rn_OutWhere = 1
		REPORT FORM DbfCdx PREVIEW
	CASE rn_OutWhere = 2
		WAIT WINDOW "Printing, please wait" NOWAIT
		REPORT FORM DbfCdx TO PRINT NOCONSOLE PDSETUP
		WAIT WINDOW "Printing complete" NOWAIT
	CASE rn_OutWhere = 3
		WAIT WINDOW "Printing report to file, please wait" NOWAIT
		REPORT FORM DbfCdx TO FILE (vc_File) NOCONSOLE
		WAIT WINDOW "Printing complete" NOWAIT
ENDCASE
CLOSE DATA