#include <stdio.h>
#include <stdlib.h>

/* Define X-Base Types */

#define CHAR 0x43
#define DATE 0x44
#define LOGI 0x4c
#define MEMO 0x4d
#define NUME 0x4e
#define FLOA 0x46
#define GENE 0x47

/* Structure for Field Data */
struct fpf {
	char name[11];
	char type;
	int  offset;
	char length;
	char precision;
};

/* File Pointer */
FILE *fp;

/* Main Body of Program */

main(argc, argv)
int argc;
char *argv[];
{
	int i, j, k=1;
	unsigned char *DATA;
	int rs, nf, hs, nr;
	struct fpf *fpfp;

	/* Open File */
	if((fp = fopen(argv[1], "rb")) == NULL)
	{
		printf("Cannot open file\n");
		exit(1);
	}

	/* Allocate Memory for Incoming Data */
	DATA=malloc(32);
	if(!DATA)
	{
		printf("Memory Error");
		exit(2);
	}

	/* Read the Header Information */
	fread(DATA, sizeof(char), 32, fp);

	/* rs = Record Size, hs = Header Size, nf = Number of Fields,
	   nr = Number of Records */

	rs = DATA[10]+(DATA[11]<<8);
	hs = DATA[8]+(DATA[9]<<8);
	nf = (hs-33)>>5;
	nr = DATA[4]+(DATA[5]<<8);

	/* Print Header Information */

	printf("Number of Records....%d\n", nr);
	printf("Record Size..........%d\n", rs);
	printf("Number of Fields.....%d\n", nf);

	/* Allocation Memory for Field Data */
	fpfp = malloc(sizeof(struct fpf)*nf);
	if(!fpfp)
	{
		printf("Memory Error");
		exit(2);
	}

	/* Start Offset at 1 */
	k = 1;

	for(i=0; i<nf; i++)
	{
		/* Read field information */
		fread(DATA, sizeof(char), 32, fp);

		/* Set field Name */
		for(j=0; j<10; j++)
		fpfp[i].name[j] = DATA[j];
		fpfp[i].name[10] = '\0';

		/* Set field Type */
		fpfp[i].type = DATA[11];

		/* Set field Offset to k */
		fpfp[i].offset = k;

		/* Set field Length and Increment offset counter */
		fpfp[i].length = DATA[16];
		k += fpfp[i].length;

		/* Set field Precision Data */
		fpfp[i].precision = DATA[17];
	}

	k=0;
	
	/* Show Field Information */
	printf("Field Name Type      Offset Length Decimal\n");
	printf("---------- --------- ------ ------ -------\n");

	for(i=0; i<nf; i++)
	{
		printf("%-10s %-9s %6d %6d ", fpfp[i].name,
		       (fpfp[i].type == CHAR ? "Character" :
		        fpfp[i].type == DATE ? "Date" :
		        fpfp[i].type == LOGI ? "Logical" :
		        fpfp[i].type == MEMO ? "Memo" :
		        fpfp[i].type == GENE ? "General" :
		        fpfp[i].type == FLOA ? "Float" :
		        fpfp[i].type == NUME ? "Numerical" : "Unknown"),
				 fpfp[i].offset, fpfp[i].length);

		if( (fpfp[i].type == NUME || fpfp[i].type == FLOA) )
		printf("%7d", fpfp[i].precision);

		printf("\n");

		k += fpfp[i].length;
	}

	printf("** Total **                 %6d\n", k);

}
