#include <stdio.h>
#include <stdlib.h>

/* Define X-Base Types */
#define CHAR 0x43
#define DATE 0x44
#define LOGI 0x4c
#define MEMO 0x4d
#define NUME 0x4e
#define FLOA 0x46
#define GENE 0x47

/* Field Information */
struct fpf {
	char name[11];
	char type;
	int  offset;
	char length;
	char precision;
};

/* fp = .dbf, ofp = output file name */
FILE *fp, *ofp;

/* Prototypes */
void ltrim(char *d);
void rtrim(char *d);
void dtrim(char *d);

int main(argc, argv)
int argc;
char *argv[];
{
	int h, i, j, k;
	char rd[256];
	unsigned char *DATA;
	int rs, nf, hs, nr;
	struct fpf *fpfp;
	char table[256];
	char file_name[256];

	/* Open .dbf */

	if((fp = fopen(argv[1], "rb")) == NULL)
	{
		printf("Cannot open file\n");
		exit(1);
	}

	/* Output for Oracle Insert Command */
	while(1)
	{
		printf("What table? ");
		gets(table);

		if(strcmp(table, "\0"))
		break;
	}

	/* Output file name */
	while(1)
	{
		printf("Output Filename? ");
		gets(file_name);

		if(strcmp(file_name, "\0"))
		break;
	}

	if((ofp=fopen(file_name, "w"))==NULL)
	{
		printf("Cannot Open Output File for Write\n");
		exit(3);
	}

	/* Allocate memory for header Data */

	DATA=malloc(32);
	if(!DATA)
	{
		printf("Memory Error");
		exit(2);
	}

	/* Identical to DBFREAD.c */

	fread(DATA, sizeof(char), 32, fp);

	rs = DATA[10]+(DATA[11]<<8);
	hs = DATA[8]+(DATA[9]<<8);
	nf = (hs-33)>>5;
	nr = DATA[4]+(DATA[5]<<8);

	fpfp = malloc(sizeof(struct fpf)*nf);
	if(!fpfp)
	{
		printf("Memory Error");
		exit(2);
	}

	k = 1;

	for(i=0; i<nf; i++)
	{
		fread(DATA, sizeof(char), 32, fp);

		for(j=0; j<10; j++)
		fpfp[i].name[j] = DATA[j];
		fpfp[i].name[10] = '\0';

		fpfp[i].type = DATA[11];

		fpfp[i].offset = k;

		fpfp[i].length = DATA[16];
		k += fpfp[i].length;

		fpfp[i].precision = DATA[17];
	}

	fread(DATA, sizeof(char), 2, fp);

	/* Reallocate DATA space for Record Size */
	realloc(DATA, rs);

	/* Output Data to file */
	for(j=0; j<nr; j++)
	{
		fprintf(ofp, "Insert into %s\n", table);
		fprintf(ofp, "Values%c", 0x28);

		fread(DATA, sizeof(char), rs, fp);

		for(i=0; i<nf; i++)
		{
			k=fpfp[i].offset-1;

			for(h=0; h<fpfp[i].length; h++)
			rd[h] = DATA[h+k];

			rd[h] = '\0';

			switch (fpfp[i].type)
			{
				case CHAR:
				case LOGI:
					rtrim(rd);
					break;

				case DATE:
					dtrim(rd);
					break;

				case NUME:
				case FLOA:
					ltrim(rd);
					break;

				default:
					fprintf(ofp, "''");
			}
			if(i-(nf-1))
				fprintf(ofp, ", ");
		}
	fprintf(ofp, "%c;\n", 0x29);
	}
}

/* Trim Numbers */
void ltrim(d)
char *d;
{
	int i=0, j;

	j=strlen(d);

	while(*d++ == ' ')
	i++;

	if(!(i-j))
	fprintf(ofp, "0");
	else
	{
		*d--;
		while(*d != '\0')
			fprintf(ofp, "%c", *d++);
	}
}

/* Trim Characters */
void rtrim(d)
char *d;
{
	int i, j;

	j=strlen(d)-1;

	while(d[j] == ' ')
	j--;

	if(j<0)
	j=0;

	fprintf(ofp, "'");
	for(i=0; i<j+1; i++)
	fprintf(ofp, "%c", (d[i] == '&' ? '/' : d[i] == '\'' ? '-' : d[i]));
	fprintf(ofp, "'");
}

/* Trim dates to Oracle Datatypes */
void dtrim(d)
char *d;
{

	int i;
	char year[3];
	char month[3];
	char lmonth[4];
	char day[3];

	for(i=2; i<4; i++)
	year[i-2]=d[i];
	year[i-2]='\0';

	for(; i<6; i++)
	month[i-4]=d[i];
	month[i-4]='\0';

	switch(atoi(month)) 
	{
		case 1:
		strcpy(lmonth, "JAN");
		break;

		case 2:
		strcpy(lmonth, "FEB");
		break;

		case 3:
		strcpy(lmonth, "MAR");
		break;

		case 4:
		strcpy(lmonth, "APR");
		break;

		case 5:
		strcpy(lmonth, "MAY");
		break;

		case 6:
		strcpy(lmonth, "JUN");
		break;

		case 7:
		strcpy(lmonth, "JUL");
		break;

		case 8:
		strcpy(lmonth, "AUG");
		break;

		case 9:
		strcpy(lmonth, "SEP");
		break;

		case 10:
		strcpy(lmonth, "OCT");
		break;

		case 11:
		strcpy(lmonth, "NOV");
		break;

		case 12:
		strcpy(lmonth, "DEC");
		break;

		default:
		strcpy(lmonth, "XXX");
		break;
	}

	for(; i<8; i++)
	day[i-6]=d[i];
	day[i-6]='\0';

	fprintf(ofp, "'%s-%s-%s'", day, lmonth, year);
}
