/****************************************************************************/
/*                          qbedoc.c                                        */
/*                                                                          */
/*  Program to read the ASCII portion of a .qbe file.                       */
/*                                                                          */
/****************************************************************************/

#include <ctype.h>
#include <stdio.h>
#include <string.h>

/****************************************************************************/
/*                          definitions                                     */
/****************************************************************************/

/****                      ****  values  ****                            ****/

#define CTRLZ         0x1A      /* end-of-ASCII marker                      */
#define MAXSTRING		 1024

/****              ****  function prototypes  ****                       ****/

int qbedoc ( char *filespec );

/*      globals             */

extern char message[], tempbuff[];

/****************************************************************************/
/*                              qbedoc                                      */
/*  Principal routine of this module.  Reads and prints the ASCII data of   */
/*  the qbe file identified by the filespec passed.                         */
/*  Parameters:                                                             */
/*      char *filespec  -- pointer to specification of the .qbe file        */
/*  Returns:                                                                */
/*      0 if successful, 1 if any error occurs.                             */
/*  Side effects:                                                           */
/*      Uses message and printit().                                         */
/*                                                                          */
/****************************************************************************/

int qbedoc ( char *filespec )
{
	FILE *qbefile;
	char qbehead[25];
	int c;

/*  open file and check for .qbe type       */

	if ( ( qbefile = fopen( filespec, "rb" ) ) == NULL )
	{
		sprintf( message, "Can't open file %s", filespec );
		return 1;
	}

	strcpy( qbehead, "* dBASE IV .QBE file 8" );

	if ( strcmp( fgets( tempbuff, strlen(qbehead) + 1, qbefile ), qbehead ) )
	{
		fclose ( qbefile );
		strcpy( message, "Not a valud .QBE file" );
		return 1;
	}

	while ( ( c = fgetc( qbefile ) ) != CTRLZ )
	{
		ungetc( c, qbefile );
		fgets( message, MAXSTRING, qbefile );
		*( strchr( message,'\r' ) ) = '\0';
		printit( 0 );
	}
	fclose ( qbefile );
	return 0;
}

/*   EOF  */
